/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.DateTime;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.util.StringConverter;
import javafx.util.converter.LocalDateStringConverter;

@BA.ShortName(value="DatePicker")
public class DatePickerWrapper
extends NodeWrapper.ControlWrapper<DatePicker> {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new DatePicker());
        }
        super.innerInitialize(ba, eventName, true);
        this.setDateTicks(DateTime.getNow());
        this.setDateFormat(DateTime.getDateFormat());
        if (ba.subExists(String.valueOf(eventName) + "_valuechanged")) {
            ((DatePicker)this.getObject()).valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

                public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                    ba.raiseEventFromUI(DatePickerWrapper.this.getObject(), String.valueOf(eventName) + "_valuechanged", DatePickerWrapper.LocalDateToLong(newValue));
                }
            });
        }
    }

    public void setDateFormat(String Format2) {
        ((DatePicker)this.getObject()).setConverter((StringConverter)new LocalDateStringConverter(DateTimeFormatter.ofPattern(Format2), null));
    }

    public long getDateTicks() {
        return DatePickerWrapper.LocalDateToLong((LocalDate)((DatePicker)this.getObject()).getValue());
    }

    public void setDateTicks(long l) {
        ((DatePicker)this.getObject()).setValue((Object)(l == 0L ? null : DatePickerWrapper.LongToLocalDate(l)));
    }

    public boolean getEditable() {
        return ((DatePicker)this.getObject()).isEditable();
    }

    public void setEditable(boolean b) {
        ((DatePicker)this.getObject()).setEditable(b);
    }

    @BA.Hide
    public static long LocalDateToLong(LocalDate ld) {
        if (ld == null) {
            return 0L;
        }
        return ld.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @BA.Hide
    public static LocalDate LongToLocalDate(long value) {
        Instant i = Instant.ofEpochMilli(value);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(i, ZoneId.systemDefault());
        return zdt.toLocalDate();
    }

    @BA.Hide
    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        DatePicker vg = (DatePicker)prev;
        if (vg == null) {
            vg = NodeWrapper.buildNativeView(DatePicker.class, props, designer);
            vg.setValue((Object)DatePickerWrapper.LongToLocalDate(System.currentTimeMillis()));
        }
        vg.setEditable(((Boolean)props.get("editable")).booleanValue());
        return NodeWrapper.ControlWrapper.build((Object)vg, props, designer);
    }
}

