﻿Type=Class
Version=6.5
ModulesStructureVersion=1
B4A=true
@EndOfDesignText@

#Event: ExampleEvent (Value As Int)
#DesignerProperty: Key: BooleanExample, DisplayName: Boolean Example, FieldType: Boolean, DefaultValue: True, Description: Example of a boolean property.
#DesignerProperty: Key: IntExample, DisplayName: Int Example, FieldType: Int, DefaultValue: 10, MinRange: 0, MaxRange: 100, Description: Note that MinRange and MaxRange are optional.
#DesignerProperty: Key: StringWithListExample, DisplayName: String With List, FieldType: String, DefaultValue: Sunday, List: Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday
#DesignerProperty: Key: StringExample, DisplayName: String Example, FieldType: String, DefaultValue: Text
#DesignerProperty: Key: ColorExample, DisplayName: Color Example, FieldType: Color, DefaultValue: 0xFFCFDCDC, Description: You can use the built-in color picker to find the color values.
#DesignerProperty: Key: DefaultColorExample, DisplayName: Default Color Example, FieldType: Color, DefaultValue: Null, Description: Setting the default value to Null means that a nullable field will be displayed.
Sub Class_Globals
	Private mEventName As String 'ignore
	Private mCallBack As Object 'ignore
	Private mBase As Panel
	
	Private mLeft, mTop, mWidth, mHeight, mRadius As Int
	Private mBorderLineColor As Int
	Private mBorderLineWidth As Int
	Private mText As String
	Private mTextColor As Int
	Private mTextSize As Float
	
	Private mImageView As ImageView
	Private mIcon As Bitmap
	Private mLabel As Label
	
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	
	mText = "Text"
	mTextColor = Colors.Black
	
	mBorderLineColor = Colors.Black
	mBorderLineWidth = 1dip
	mRadius = 4dip
	
End Sub

Public Sub DesignerCreateView (Base As Panel, Lbl As Label, Props As Map)
	mLeft = Base.Left
	mTop = Base.Top
	mWidth = Base.Width
	mHeight = Base.Height
	mText = Lbl.Text
	
	mBase = Base
	
	InitClass
End Sub

Public Sub GetBase As Panel
	Return mBase
End Sub

Private Sub AddToParent(Parent As Panel, Left As Int, Top As Int, Width As Int, Height As Int, Icon As Bitmap, Text As String, Radius As Int)
	mLeft = Left
	mTop = Top
	mWidth = Width
	mHeight = Height
	mRadius = Radius
	
	mBase.Initialize("mBase")
	Parent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	
	InitClass
End Sub

Private Sub InitClass
	mImageView.Initialize("")
	Private x, w  As Int
	w = 2 * mHeight / 3
	x = (mWidth - w) / 2
	mBase.AddView(mImageView, x, 0, w, w)
'	mImageView.Bitmap = mIcon
	
	mLabel.Initialize("")
	mBase.AddView(mLabel, 0, 2 * mHeight / 3, mWidth, mHeight / 3)
	mLabel.Text = mText
	mLabel.TextColor = mTextColor
	mLabel.Gravity = Gravity.CENTER
End Sub