﻿Type=Class
Version=4.7
ModulesStructureVersion=1
B4J=true
@EndOfDesignText@
'CustomButton Class
#Event: Click
#Event: LongClick
#RaisesSynchronousEvents: Click
#RaisesSynchronousEvents: LongClick

#DesignerProperty: Key: Text, DisplayName: Text, FieldType: String, DefaultValue: Text, Description: Text at the bottom of the button.

'CustomButton is a button based on a Panel with two Labels
'one with a Material Icon and the other with text.
'It has two events: Click and LongClick.
Sub Class_Globals
	Private fx As JFX

	Private mEventName As String 
	Private mCallBack As Object
	Private mBase As Pane
	
	Private mLeft, mTop, mWidth, mHeight As Int
	Private mText, mIcon As String
	Private mIconFont As Font
	Private mTextColor As Paint
	Private mIconTextSize, mTextSize As Float
	Private mTag As Object
	
	Private mLabel, mIconLabel As Label
	Private mParent As Pane
	
	Private mClickTime As Long	'used to distinguish Click and LongClick
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	
	mIcon = Chr(0xE859)
	mText = "Test"
	mTextColor = fx.Colors.Black
End Sub

Public Sub DesignerCreateView (Base As Pane, Lbl As Label, Props As Map)
	mLeft = Base.Left
	mTop = Base.Top
	mIcon = Lbl.Text
	mText = Props.Get("Text")
	mBase.Initialize("mBase")
	mParent = Base.Parent 
	mParent.AddNode(mBase, mLeft, mTop, Base.Width, Base.Height)

	mTextColor = Lbl.TextColor
	mIconFont = Lbl.Font
	mTag = Base.Tag
End Sub

Private Sub Base_Resize (Width As Double, Height As Double)
	mWidth = Width
	mHeight = Height	
	mBase.PrefWidth = mWidth
	mBase.PrefHeight = mHeight
	
	InitClass
End Sub

Public Sub GetBase As Pane
	Return mBase
End Sub

Public Sub AddToParent(Parent As Pane, Left As Int, Top As Int, Width As Int, Height As Int, TextColor As Paint, Icon As String, Text As String)
	mLeft = Left
	mTop = Top
	mWidth = Width
	mHeight = Height
	
	mBase.Initialize("mBase")
	Parent.AddNode(mBase, mLeft, mTop, mWidth, mHeight)
	
	mIcon = Icon
	mText = Text
	mTextColor = TextColor
	
	InitClass
End Sub

Private Sub InitClass
	'calculate the dimensions of the internal Labels
	Private lblLeft, lblWidth  As Int
	lblWidth = 2 * mHeight / 3		'icon Label width and height = 2/3 of button height
	lblLeft = (mWidth - lblWidth) / 2
	
	'initialize and add the icon Label	
	mIconLabel.Initialize("")
	mIconTextSize = mHeight / 2 																		'B4J
	mIconLabel.Font = mIconFont																			'B4J, B4i
	mIconLabel.TextSize = mIconTextSize															'B4J, B4A
	mIconLabel.Alignment = "CENTER"																	'B4J
	mIconLabel.TextColor = mTextColor
	mBase.AddNode(mIconLabel, lblLeft, 0, lblWidth, lblWidth)				'B4J, B4A
	mIconLabel.Text = mIcon
	
	'initialize and add the text Label
	mLabel.Initialize("")
	mTextSize = lblWidth / 3																				'B4J
	mLabel.TextSize = mTextSize																			'B4J, B4A
	mLabel.TextColor = mTextColor
	mLabel.Alignment = "TOP_CENTER"																	'B4J
	mBase.AddNode(mLabel, 0, 2 * mHeight / 3, mWidth, mHeight / 3)	'B4J
	mLabel.Text = mText
End Sub

Private Sub mBase_MousePressed (EventData As MouseEvent)
	mClickTime = DateTime.Now
End Sub

Private Sub mBase_MouseReleased (EventData As MouseEvent)
	If DateTime.Now - mClickTime < 500 Then
		If SubExists(mCallBack, mEventName & "_Click") = True Then
			CallSub(mCallBack,  mEventName & "_Click")
		End If	
	Else
		If SubExists(mCallBack, mEventName & "_LongClick") = True Then
			CallSub(mCallBack,  mEventName & "_LongClick")
		End If		
	End If
End Sub

'set the icon typeface
'must be FontAwsome or Material Icons
Public Sub setIconFont(IconFont As Font)
	mIconFont = IconFont
End Sub

'get or set the Tag property
Public Sub setTag(Tag As Object)
	mTag = Tag
	mBase.Tag = Tag
End Sub

Public Sub getTag As Object
	Return mTag
End Sub