﻿Type=Class
Version=3.6
ModulesStructureVersion=1
B4i=true
@EndOfDesignText@
'CustomButton Class
#Event: Click
#Event: LongClick
#RaisesSynchronousEvents: Click
#RaisesSynchronousEvents: LongClick

#DesignerProperty: Key: Text, DisplayName: Text, FieldType: String, DefaultValue: Text, Description: Text at the bottom of the button.

'CustomButton is a button based on a Panel with two Labels
'one with a Material Icon and the other with text.
'It has two events: Click and LongClick.
Sub Class_Globals
	Private mEventName As String
	Private mCallBack As Object
	Private mBase As Panel
	
	Private mLeft, mTop, mWidth, mHeight As Int
	Private mText, mIcon As String
	Private mIconFont As Font
	Private mTextColor As Int
	Private mIconTextSize, mTextSize As Float
	Private mTag As Object
	
	Private mLabel, mIconLabel As Label
	Private mParent As Panel
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	
	mIcon = Chr(0xE859)
	mText = "Test"
	mTextColor = Colors.Black
End Sub

Public Sub DesignerCreateView (Base As Panel, Lbl As Label, Props As Map)
	mLeft = Base.Left
	mTop = Base.Top
	mWidth = Base.Width
	mHeight = Base.Height
	mIcon = Lbl.Text
	mText = Props.Get("Text")
	mBase.Initialize("mBase")
	mParent = Base.Parent
	mParent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	
	mTextColor = Lbl.TextColor
	mIconFont = Lbl.Font	
	mTag = Base.Tag
	
	InitClass
End Sub

Private Sub Base_Resize (Width As Double, Height As Double)
	mHeight = Height
	mWidth = Width
End Sub

Public Sub GetBase As Panel
	Return mBase
End Sub

Public Sub AddToParent(Parent As Panel, Left As Int, Top As Int, Width As Int, Height As Int, TextColor As Int, Icon As String, Text As String)
	mLeft = Left
	mTop = Top
	mWidth = Width
	mHeight = Height
	mParent = Parent
	
	mBase.Initialize("mBase")
	Parent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	
	mIcon = Icon
	mText = Text
	mTextColor = TextColor
	
	InitClass
End Sub

Private Sub InitClass
	'calculate the dimensions of the internal Labels
	Private lblLeft, lblWidth  As Int
	lblWidth = 2 * mHeight / 3		'icon Label width and height = 2/3 of button height
	lblLeft = (mWidth - lblWidth) / 2
	
	'initialize and add the icon Label	
	mIconLabel.Initialize("")
	mIconTextSize = mHeight / 2 / GetDeviceLayoutValues.Scale				'B4i, B4A
	mIconFont = Font.CreateNew2(mIconFont.Name, mIconTextSize)			'B4i
	mIconLabel.Font = mIconFont																			'B4i
	mIconLabel.TextAlignment = mIconLabel.ALIGNMENT_CENTER					'B4i
	mIconLabel.TextColor = mTextColor
	mBase.AddView(mIconLabel, lblLeft, 0, lblWidth, lblWidth)				'B4i, B4A
	mIconLabel.Text = mIcon
	
	'initialize and add the text Label
	mLabel.Initialize("")
	mTextSize = lblWidth / 3 / GetDeviceLayoutValues.Scale					'B4i, B4A
	mLabel.Font = Font.CreateNew(mTextSize)													'B4i
	mLabel.TextColor = mTextColor
	mLabel.TextAlignment = mIconLabel.ALIGNMENT_CENTER							'B4i
	mBase.AddView(mLabel, 0, 2 * mHeight / 3, mWidth, mHeight / 3)	'B4i, B4A
	mLabel.Text = mText
End Sub

Private Sub mBase_Click
	If SubExists(mCallBack, mEventName & "_Click", 0) = True Then
		CallSub(mCallBack,  mEventName & "_Click")
	End If
End Sub

Private Sub mBase_LongClick
	If SubExists(mCallBack, mEventName & "_LongClick", 0) = True Then
		CallSub(mCallBack,  mEventName & "_LongClick")
	End If
End Sub

'set the icon typeface
'must be FontAwsome or Material Icons
Public Sub setIconFont(IconFont As Font)
	mIconFont = IconFont
End Sub

'get or set the Tag property
Public Sub setTag(Tag As Object)
	mTag = Tag
	mBase.Tag = Tag
End Sub

Public Sub getTag As Object
	Return mTag
End Sub