﻿Type=Class
Version=6.5
ModulesStructureVersion=1
B4A=true
@EndOfDesignText@
'CustomButton Class
#Event: Click
#Event: LongClick
#RaisesSynchronousEvents: Click
#RaisesSynchronousEvents: LongClick

#DesignerProperty: Key: Text, DisplayName: Text, FieldType: String, DefaultValue: Text, Description: Text at the bottom of the button.

'CustomButton is a button based on a Panel with two Labels
'one with a Material Icon and the other with text.
'It has two events: Click and LongClick.
Sub Class_Globals
	Private mEventName As String
	Private mCallBack As Object
	Private mBase As Panel
	
	Private mLeft, mTop, mWidth, mHeight As Int
	Private mText, mIcon As String
	Private mIconTypeface As Typeface
	Private mTextColor As Int
	Private mIconTextSize, mTextSize As Float
	Private mTag As Object
	
	Private mLabel, mIconLabel As Label
	Private mParent As Panel
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	
	mIcon = Chr(0xE859)
	mText = "Test"
	mTextColor = Colors.Black
End Sub

Public Sub DesignerCreateView (Base As Panel, Lbl As Label, Props As Map)
	mLeft = Base.Left
	mTop = Base.Top
	mWidth = Base.Width
	mHeight = Base.Height
	mIcon = Lbl.Text
	mText = Props.Get("Text")
	mBase.Initialize("mBase")
	mParent = Base.Parent
	mParent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	
	mTextColor = Lbl.TextColor
	mIconTypeface = Lbl.Typeface
	mTag = Base.Tag
	
	InitClass
End Sub

Public Sub GetBase As Panel
	Return mBase
End Sub

Public Sub AddToParent(Parent As Panel, Left As Int, Top As Int, Width As Int, Height As Int, TextColor As Int, Icon As String, Text As String)
	mLeft = Left
	mTop = Top
	mWidth = Width
	mHeight = Height
	mParent = Parent
	
	mBase.Initialize("mBase")
	Parent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	
	mIcon = Icon
	mText = Text
	mTextColor = TextColor
	
	InitClass
End Sub

Private Sub InitClass
	'calculate the dimensions of the internal Labels
	Private lblLeft, lblWidth  As Int
	lblWidth = 2 * mHeight / 3		'icon Label width and height = 2/3 of button height
	lblLeft = (mWidth - lblWidth) / 2
	
	'initialize and add the icon Label
	mIconLabel.Initialize("")
	mIconTextSize = mHeight / 2 / GetDeviceLayoutValues.Scale
	mIconLabel.Typeface = mIconTypeface'
	mIconLabel.TextSize = mIconTextSize
	mIconLabel.Gravity = Gravity.CENTER
	mIconLabel.TextColor = mTextColor
	mBase.AddView(mIconLabel, lblLeft, 0, lblWidth, lblWidth)
	mIconLabel.Text = mIcon
	
	'initialize and add the text Label
	mLabel.Initialize("")
	mTextSize = lblWidth / 3 / GetDeviceLayoutValues.Scale
	mLabel.TextSize = mTextSize
	mLabel.TextColor = mTextColor
	mLabel.Gravity = Bit.Or(Gravity.CENTER_HORIZONTAL, Gravity.TOP)
	mBase.AddView(mLabel, 0, 2 * mHeight / 3, mWidth, mHeight / 3)
	mLabel.Text = mText
End Sub

Private Sub mBase_Click
	If SubExists(mCallBack, mEventName & "_Click") = True Then
		CallSub(mCallBack,  mEventName & "_Click")
	End If
End Sub

Private Sub mBase_LongClick
	If SubExists(mCallBack, mEventName & "_LongClick") = True Then
		CallSub(mCallBack,  mEventName & "_LongClick")
	End If
End Sub

'set the icon typeface
'must be FontAwsome or Material Icons
Public Sub setIconTypeface(IconTypeface As Typeface)
	mIconTypeface = IconTypeface
End Sub

'get or set the Tag property
Public Sub setTag(Tag As Object)
	mTag = Tag
	mBase.Tag = Tag
End Sub

Public Sub getTag As Object
	Return mTag
End Sub