#include "B4RDefines.h"

B4R::Serial* b4r_main::_serial1;
B4R::B4RSoftwareSerial* b4r_main::_softwareserial1;
B4R::AsyncStreams* b4r_main::_astream;
B4R::Pin* b4r_main::_motordirection1;
B4R::Pin* b4r_main::_motordirection2;
B4R::Pin* b4r_main::_motorspeed;
UInt b4r_main::_speed;
static B4R::Serial be_gann1_3;
static B4R::B4RSoftwareSerial be_gann2_3;
static B4R::AsyncStreams be_gann3_3;
static B4R::Pin be_gann4_3;
static B4R::Pin be_gann4_7;
static B4R::Pin be_gann4_11;


 void b4r_main::_appstart(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 16;BA.debugLine="Private Sub AppStart";
 //BA.debugLineNum = 17;BA.debugLine="Serial1.Initialize(115200)";
b4r_main::_serial1->Initialize((ULong) (115200));
 //BA.debugLineNum = 18;BA.debugLine="Log(\"AppStart\")";
B4R::Common::LogHelper(1,102,F("AppStart"));
 //BA.debugLineNum = 19;BA.debugLine="MotorDirection1.Initialize(4, MotorDirection1.MOD";
b4r_main::_motordirection1->Initialize((Byte) (4),Pin_MODE_OUTPUT);
 //BA.debugLineNum = 20;BA.debugLine="MotorDirection2.Initialize(5, MotorDirection2.MOD";
b4r_main::_motordirection2->Initialize((Byte) (5),Pin_MODE_OUTPUT);
 //BA.debugLineNum = 21;BA.debugLine="MotorSpeed.Initialize(3, MotorSpeed.MODE_OUTPUT)";
b4r_main::_motorspeed->Initialize((Byte) (3),Pin_MODE_OUTPUT);
 //BA.debugLineNum = 22;BA.debugLine="SoftwareSerial1.Initialize(9600, 11, 12) 'softwar";
b4r_main::_softwareserial1->Initialize((ULong) (9600),(Byte) (11),(Byte) (12));
 //BA.debugLineNum = 23;BA.debugLine="astream.Initialize(SoftwareSerial1.Stream, \"astre";
b4r_main::_astream->Initialize(b4r_main::_softwareserial1->getStream(),_astream_newdata,NULL);
 //BA.debugLineNum = 26;BA.debugLine="MotorDirection1.DigitalWrite(True)";
b4r_main::_motordirection1->DigitalWrite(Common_True);
 //BA.debugLineNum = 27;BA.debugLine="MotorDirection2.DigitalWrite(False)";
b4r_main::_motordirection2->DigitalWrite(Common_False);
 //BA.debugLineNum = 28;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}
void b4r_main::_astream_newdata(B4R::Array* _buffer){
const UInt cp = B4R::StackMemory::cp;
B4R::Object be_ann19_4;
B4R::Object be_ann20_1;
B4R::Object be_ann28_1;
B4R::Object be_ann38_1;
 //BA.debugLineNum = 30;BA.debugLine="Sub AStream_NewData (Buffer() As Byte)";
 //BA.debugLineNum = 31;BA.debugLine="Select Buffer(0)";
switch (B4R::BR::switchObjectToInt(4,be_ann19_4.wrapNumber((Long)((Byte*)_buffer->getData((UInt) (0)))[B4R::Array::staticIndex]),be_ann20_1.wrapNumber((Long)0),be_ann28_1.wrapNumber((Long)1),be_ann38_1.wrapNumber((Long)2))) {
case 0: {
 //BA.debugLineNum = 33;BA.debugLine="If Buffer(1) = 0 Then";
if (((Byte*)_buffer->getData((UInt) (1)))[B4R::Array::staticIndex]==0) { 
 //BA.debugLineNum = 34;BA.debugLine="MotorSpeed.DigitalWrite(False)";
b4r_main::_motorspeed->DigitalWrite(Common_False);
 //BA.debugLineNum = 35;BA.debugLine="Log(\"Motor OFF\")";
B4R::Common::LogHelper(1,102,F("Motor OFF"));
 }else {
 //BA.debugLineNum = 37;BA.debugLine="MotorSpeed.DigitalWrite(True)";
b4r_main::_motorspeed->DigitalWrite(Common_True);
 //BA.debugLineNum = 38;BA.debugLine="Log(\"Motor ON\")";
B4R::Common::LogHelper(1,102,F("Motor ON"));
 };
 break; }
case 1: {
 //BA.debugLineNum = 41;BA.debugLine="If Buffer(1) = 0 Then";
if (((Byte*)_buffer->getData((UInt) (1)))[B4R::Array::staticIndex]==0) { 
 //BA.debugLineNum = 42;BA.debugLine="MotorDirection1.DigitalWrite(True)";
b4r_main::_motordirection1->DigitalWrite(Common_True);
 //BA.debugLineNum = 43;BA.debugLine="MotorDirection2.DigitalWrite(False)";
b4r_main::_motordirection2->DigitalWrite(Common_False);
 //BA.debugLineNum = 44;BA.debugLine="Log(\"Direction >>>\")";
B4R::Common::LogHelper(1,102,F("Direction >>>"));
 }else {
 //BA.debugLineNum = 46;BA.debugLine="MotorDirection1.DigitalWrite(False)";
b4r_main::_motordirection1->DigitalWrite(Common_False);
 //BA.debugLineNum = 47;BA.debugLine="MotorDirection2.DigitalWrite(True)";
b4r_main::_motordirection2->DigitalWrite(Common_True);
 //BA.debugLineNum = 48;BA.debugLine="Log(\"Direction <<<\")";
B4R::Common::LogHelper(1,102,F("Direction <<<"));
 };
 break; }
case 2: {
 //BA.debugLineNum = 51;BA.debugLine="Speed = Buffer(1)";
b4r_main::_speed = (UInt) (((Byte*)_buffer->getData((UInt) (1)))[B4R::Array::staticIndex]);
 //BA.debugLineNum = 52;BA.debugLine="MotorSpeed.AnalogWrite(Speed)";
b4r_main::_motorspeed->AnalogWrite(b4r_main::_speed);
 //BA.debugLineNum = 53;BA.debugLine="Log(\"Speed: \", Speed)";
B4R::Common::LogHelper(2,102,F("Speed: "),4,b4r_main::_speed);
 break; }
}
;
 //BA.debugLineNum = 55;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}

void b4r_main::initializeProcessGlobals() {
     B4R::StackMemory::buffer = (byte*)malloc(STACK_BUFFER_SIZE);
     b4r_main::_process_globals();

   
}
void b4r_main::_process_globals(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 8;BA.debugLine="Sub Process_Globals";
 //BA.debugLineNum = 9;BA.debugLine="Public Serial1 As Serial";
b4r_main::_serial1 = &be_gann1_3;
 //BA.debugLineNum = 10;BA.debugLine="Private SoftwareSerial1 As SoftwareSerial";
b4r_main::_softwareserial1 = &be_gann2_3;
 //BA.debugLineNum = 11;BA.debugLine="Private astream As AsyncStreams";
b4r_main::_astream = &be_gann3_3;
 //BA.debugLineNum = 12;BA.debugLine="Private MotorDirection1, MotorDirection2, MotorSp";
b4r_main::_motordirection1 = &be_gann4_3;
b4r_main::_motordirection2 = &be_gann4_7;
b4r_main::_motorspeed = &be_gann4_11;
 //BA.debugLineNum = 13;BA.debugLine="Private Speed As UInt";
b4r_main::_speed = 0;
 //BA.debugLineNum = 14;BA.debugLine="End Sub";
}
