﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.71
@EndOfDesignText@
Sub Class_Globals
	Private Root As B4XView 'ignore
	Private xui As XUI 'ignore
	
	Private lblToastMessage As B4XView
	Public ToastMessageTimer As Timer

	Public Mode As String
	Private clvEdit As CustomListView
	Private edtColumn() As B4XView
	Private btnAdd, btnDelete, btnUpdate, btnPrevious, btnNext, btnFirst, btnLast As B4XView
	Private lblColumn, edtColumn0, edtColumn() As B4XView
End Sub

'You can add more parameters here.
Public Sub Initialize As Object
	Return Me
End Sub

'This event will be called once, before the page becomes visible.
Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("Edit")
	
	ToastMessageTimer.Initialize("ToastMessageTimer", 3000)

	InitEditPane
	
	ShowEntry(B4XPages.MainPage.CurrentIndex)
End Sub

Private Sub B4XPage_Appear
	ShowEntry(B4XPages.MainPage.CurrentIndex)
End Sub

Private Sub B4XPage_Disappear
	B4XPages.MainPage.Show
End Sub

Private Sub btnMove_Click
	Private btn As Button
	Private Tag As String
	
	btn = Sender
	Tag = btn.Tag

	Select Tag
		Case "First"
			B4XPages.MainPage.CurrentIndex = 0
		Case "Prev"
			B4XPages.MainPage.CurrentIndex = Max(0, B4XPages.MainPage.CurrentIndex - 1)
		Case "Next"
			B4XPages.MainPage.CurrentIndex = Min(B4XPages.MainPage.CurrentIndex + 1, B4XPages.MainPage.RowIDList.Size - 1)
		Case "Last"
			B4XPages.MainPage.CurrentIndex = B4XPages.MainPage.RowIDList.Size - 1
	End Select
	ShowEntry(B4XPages.MainPage.CurrentIndex)
End Sub

Private Sub btnEntry_Click
	Private btn As Button
	Private Tag As String
	
	btn = Sender
	Tag = btn.Tag
	
	Select Tag
		Case "Add"
			AddEntry
		Case "Delete"
			DeleteEntry
		Case "Update"
			UpdateEntry
	End Select
End Sub

Private Sub ShowEntry(EntryIndex As Int)
	Private col, RowID As Int
	
	If B4XPages.MainPage.RowIDList.Size = 0 Then 	'check if database is empty
		Return													'if the database is empty leave the routine
	End If
	
	If Mode = "Add" Then
		For col = 0 To B4XPages.MainPage.ColNumber - 1
			edtColumn(col).Text = ""
		Next
	Else
		Private ResultSet1 As ResultSet
		RowID = B4XPages.MainPage.RowIDList.Get(EntryIndex)		'get the RowID for the given entry index
		'read the entry with the given RowID
		ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery("SELECT * FROM " & B4XPages.MainPage.SQLTabelName & " WHERE rowid = " & RowID)
		ResultSet1.NextRow
		For col = 0 To B4XPages.MainPage.ColNumber - 1
			edtColumn(col).Text = ResultSet1.GetString2(col)
		Next
		ResultSet1.Close		'close the ResultSet, we don't it anymore
	End If
	ShowButtons
End Sub

Public Sub AddEntry
	Private Query As String
	Private ResultSet1 As ResultSet
	Private col, RowID As Int
	Private Values As List
	
	'check if all dields are filled
	For col = 0 To B4XPages.MainPage.ColNumber - 1
		If edtColumn(col).Text = "" Then
			ShowToastMessage("No entry for " & B4XPages.MainPage.ColAliasNames(col), False)	' confirmation for the user
			Return
		End If
	Next
	
	'first we check if the entry already does exist
	Query = "SELECT * FROM " & B4XPages.MainPage.SQLTabelName & " WHERE "
	
'	Values.Initialize
	Private Vals(B4XPages.MainPage.ColNumber) As String
	For col = 0 To B4XPages.MainPage.ColNumber - 1
		If col = 0 Then
			Query = Query & B4XPages.MainPage.ColNames(col) & " = ?"
		Else
			Query = Query & " AND " & B4XPages.MainPage.ColNames(col) & " = ?"
		End If
		Vals(col) = edtColumn(col).Text
	Next
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery2(Query, Vals)

	If ResultSet1.NextRow = True Then
		'if it exists show a message and do nothing else
		ShowToastMessage("This entry already exists", False)
	Else
		'if not, add the entry
		'a NULL for the ID column increments the primary key automatically by one
		'we use ExecNonQuery2 because it's easier, we don't need to take care of the data types
		Query = "INSERT INTO " & B4XPages.MainPage.SQLTabelName & " VALUES ("
		Values.Initialize
		For col = 0 To B4XPages.MainPage.ColNumber - 1
			If col = 0 Then
				Query = Query & "?"
			Else
				Query = Query & ", ?"
			End If
			Values.Add(edtColumn(col).Text)
		Next
		Query = Query & ")"
		B4XPages.MainPage.SQL1.ExecNonQuery2(Query, Values)
		
		ShowToastMessage("Entry added", False)	' confirmation for the user
		
		'to display the ID of the last entry we read the max value of the ID column
		RowID = B4XPages.MainPage.SQL1.ExecQuerySingleResult("SELECT max(rowid) FROM " & B4XPages.MainPage.SQLTabelName)
		B4XPages.MainPage.RowIDList.Add(RowID)											'add the last ID to the list
		B4XPages.MainPage.CurrentIndex = B4XPages.MainPage.RowIDList.Size - 1		'set the current index to the last one
	End If
	ResultSet1.Close												'close the cursor, we don't it anymore
	
	Mode = "Edit"
	
	ShowButtons
End Sub

Private Sub DeleteEntry
	Private Question, Query As String
	
	'ask the user for confirmation
	Question = "Do you really want to delete "
	For i = 1 To B4XPages.MainPage.ColNumber - 1
		Question = Question & CRLF & edtColumn(i).Text
	Next
	
	Private sf As Object = xui.Msgbox2Async(Question, "Delete entry", "Yes", "", "No", Null)
	Wait For (sf) Msgbox_Result (Result As Int)
	If Result = xui.DialogResponse_Positive Then
		Query = "DELETE FROM " & B4XPages.MainPage.SQLTabelName & " WHERE rowid = " & B4XPages.MainPage.RowIDList.Get(B4XPages.MainPage.CurrentIndex)
		B4XPages.MainPage.SQL1.ExecNonQuery(Query)									'delete the entry
		B4XPages.MainPage.RowIDList.RemoveAt(B4XPages.MainPage.CurrentIndex)							'remove the ID from the list
		If B4XPages.MainPage.CurrentIndex = B4XPages.MainPage.RowIDList.Size Then			'if the current index is the last one
			B4XPages.MainPage.CurrentIndex = B4XPages.MainPage.CurrentIndex - 1					'decrement it by 1
		End If
		ShowEntry(B4XPages.MainPage.CurrentIndex)										'show the next entry
		ShowToastMessage("Entry deleted", False)	'confirmation for the user
		ShowButtons
	End If
End Sub

Private Sub UpdateEntry
	Private Query As String
	Private col As Int
	Private Values As List
	
	If Mode = "Add" Then
		AddEntry
	Else
		Values.Initialize
		Query = "UPDATE " & B4XPages.MainPage.SQLTabelName & " Set "
		For col = 0 To B4XPages.MainPage.ColNumber - 1
			If col = 0 Then
				Query = Query & B4XPages.MainPage.ColNames(col) & " = ?"
			Else
				Query = Query & ", " & B4XPages.MainPage.ColNames(col) & " = ?"
			End If
			Values.Add(edtColumn(col).Text)
		Next
		Query = Query & " WHERE rowid = " & B4XPages.MainPage.RowIDList.Get(B4XPages.MainPage.CurrentIndex)
		B4XPages.MainPage.SQL1.ExecNonQuery2(Query, Values)
		ShowToastMessage("Entry updated", False)
	End If
End Sub

Sub ShowButtons
	If Mode = "Add" Then
		btnPrevious.Visible = False		'hide the navigation buttons
		btnNext.Visible = False
		btnFirst.Visible = False
		btnLast.Visible = False
		btnDelete.Visible = False
		btnUpdate.Visible = False
	Else
		btnDelete.Visible = True
		btnUpdate.Visible = True
		If B4XPages.MainPage.RowIDList.Size <= 1 Then 		'check if the database has less than 2 empty
			btnPrevious.Visible = False				'hide the navigation buttons
			btnNext.Visible = False
			btnFirst.Visible = False
			btnLast.Visible = False
		Else
			'show or hide the Previous and Next buttons depending on the value of the current index
			If B4XPages.MainPage.CurrentIndex = 0 Then
				btnPrevious.Visible = False
				btnFirst.Visible = False
			Else
				btnPrevious.Visible = True
				btnFirst.Visible = True
			End If
			
			If B4XPages.MainPage.CurrentIndex = B4XPages.MainPage.RowIDList.Size - 1 Then
				btnNext.Visible = False
				btnLast.Visible = False
			Else
				btnNext.Visible = True
				btnLast.Visible = True
			End If
		End If
	End If
End Sub

Private Sub InitEditPane
	Private i As Int
	Private edtColumn(B4XPages.MainPage.ColNumber) As B4XView
	
	For i = 0 To B4XPages.MainPage.ColNumber - 1
		clvEdit.Add(CreateEditItem(i, 50dip, clvEdit.GetBase.Width), "")
	Next
End Sub

Private Sub CreateEditItem(i As Int, Height As Int, Width As Int) As B4XView
	Private pnl As B4XView = xui.CreatePanel("")
	pnl.SetLayoutAnimated(0, 0, 0, Width, Height)
	pnl.LoadLayout("EditItem")
	
	lblColumn.Text = B4XPages.MainPage.ColNames(i)
	edtColumn(i) = edtColumn0
	Return pnl
End Sub

Private Sub ShowToastMessage(Message As String, LongDuration As Boolean)
	lblToastMessage.Text = Message
	
	If LongDuration Then
		ToastMessageTimer.Interval = 5000
	Else
		ToastMessageTimer.Interval = 3000
	End If
	ToastMessageTimer.Enabled = True
	lblToastMessage.Visible = True
End Sub

Private Sub ToastMessageTimer_Tick
	lblToastMessage.Visible = False
	ToastMessageTimer.Enabled = False
End Sub
