﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.85
@EndOfDesignText@
#Region Shared Files
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Shared Files" "..\Files"
'Ctrl + click to sync files: ide://run?file=%WINDIR%\System32\Robocopy.exe&args=..\..\Shared+Files&args=..\Files&FilesSync=True
#End Region

'Ctrl + click to export as zip: ide://run?File=%B4X%\Zipper.jar&Args=\%PROJECT_NAME%.zip

'B4A ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4A\%PROJECT_NAME%.b4a 
'B4i ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4i\%PROJECT_NAME%.b4i 
'B4J ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4J\%PROJECT_NAME%.b4j

Sub Class_Globals
	Private Root As B4XView
	Private xui As XUI
	
	Private pnlTest As B4XView
	Private cvsTest As B4XCanvas
End Sub

Public Sub Initialize
'	B4XPages.GetManager.LogEvents = True
End Sub

'This event will be called once, before the page becomes visible.
Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("MainPage")
	
	cvsTest.Initialize(pnlTest)
	
	Draw
End Sub

Private Sub Draw
	Private fntText As B4XFont
	Private rectText As B4XRect				'the text rectangle
	Private rectTextOuter As B4XRect	'the outer text rectangle
	Private Text As String
	Private x0, y0, x1, y1, x2, y2 As Int
	
	x0 = pnlTest.Width * 0.2
	y0 = 200dip
	
	fntText = xui.CreateDefaultFont(100)
	
	Text = "My text"
	rectText = cvsTest.MeasureText(Text, fntText)	'
	
	rectTextOuter.Initialize(x0 + rectText.Left, y0 + rectText.Top, x0 + rectText.Right, y0 + rectText.Bottom)
	
	cvsTest.DrawText(Text, x0, y0, fntText, xui.Color_Blue, "LEFT")
	cvsTest.DrawLine(x0 - 10dip, y0, x0 + rectText.Right + 20dip, y0, xui.Color_Red, 1dip)
	cvsTest.DrawLine(x0, y0 + rectText.Top - 10dip, x0, y0 + 10dip, xui.Color_Red, 1dip)
	cvsTest.DrawRect(rectTextOuter, xui.Color_Green, False, 1dip)
	
	x1 = x0 + rectText.Right
	x2 = x1 + 20dip
	y1 = y0 + rectText.Top
	cvsTest.DrawLine(x1, y1, x2, y1, xui.Color_DarkGray, 1dip)
	y1 = y0 + rectText.CenterY
	cvsTest.DrawLine(x1, y1, x2, y1, xui.Color_DarkGray, 1dip)
	y1 = y0 + rectText.Bottom
	cvsTest.DrawLine(x1, y1, x2, y1, xui.Color_DarkGray, 1dip)
		
	y1 = y0 + rectText.Bottom
	y2 = y1 + 20dip
	x1 = x0 + rectText.Left
	cvsTest.DrawLine(x1, y1, x1, y2, xui.Color_DarkGray, 1dip)
	x1 = x0 + rectText.CenterX
	cvsTest.DrawLine(x1, y1, x1, y2, xui.Color_DarkGray, 1dip)
	x1 = x0 + rectText.Right
	cvsTest.DrawLine(x1, y1, x1, y2, xui.Color_DarkGray, 1dip)
	
	Private fntSmall As B4XFont
	Private rectSmall As B4XRect
	fntSmall = xui.CreateDefaultFont(16)
	rectSmall = cvsTest.MeasureText("Top line", fntSmall)
	
	
	rectSmall = cvsTest.MeasureText("y0", fntSmall)
	x1 = x0 - 15dip - rectSmall.Right
	y1 = y0 - rectSmall.CenterY
	cvsTest.DrawText("y0", x1, y1, fntSmall, xui.Color_Red, "LEFT")
	
	rectSmall = cvsTest.MeasureText("x0", fntSmall)
	x1 = x0 
	y1 = y0 + rectText.Top - rectSmall.Bottom - 15dip
	cvsTest.DrawText("x0", x1, y1, fntSmall, xui.Color_Red, "CENTER")

	rectSmall = cvsTest.MeasureText("Top line", fntSmall)
	x1 = x0 + rectText.Right + 25dip
	y1 = y0 + rectText.Top - rectSmall.CenterY
	cvsTest.DrawText("Top line", x1, y1, fntSmall, xui.Color_DarkGray, "LEFT")
	rectSmall = cvsTest.MeasureText("CenterY line", fntSmall)
	y1 = y0 + rectText.CenterY - rectSmall.CenterY
	cvsTest.DrawText("CenterY line", x1, y1, fntSmall, xui.Color_DarkGray, "LEFT")
	rectSmall = cvsTest.MeasureText("Base line", fntSmall)
	y1 = y0 - rectSmall.CenterY
	cvsTest.DrawText("Base line", x1, y1, fntSmall, xui.Color_Red, "LEFT")
	rectSmall = cvsTest.MeasureText("Bottom line", fntSmall)
	y1 = y0 + rectText.Bottom - rectSmall.CenterY
	cvsTest.DrawText("Bottom line", x1, y1, fntSmall, xui.Color_DarkGray, "LEFT")
	
	rectSmall = cvsTest.MeasureText("Left line", fntSmall)
	x1 = x0 + rectText.Left
	y1 = y0 + rectText.Bottom - rectSmall.Top + 25dip
	cvsTest.DrawText("Left line", x1, y1, fntSmall, xui.Color_DarkGray, "CENTER")
	rectSmall = cvsTest.MeasureText("CenterX line", fntSmall)
	x1 = x0 + rectText.CenterX
	y1 = y0 + rectText.Bottom - rectSmall.Top + 25dip
	cvsTest.DrawText("CenterX line", x1, y1, fntSmall, xui.Color_DarkGray, "CENTER")
	rectSmall = cvsTest.MeasureText("Right line", fntSmall)
	x1 = x0 + rectText.Right
	y1 = y0 + rectText.Bottom - rectSmall.Top + 25dip
	cvsTest.DrawText("Right line", x1, y1, fntSmall, xui.Color_DarkGray, "CENTER")
	
	Private Padding As Int
	Padding = 10dip
	x0 = pnlTest.Width * 0.2
	y0 = 400dip
	rectTextOuter.Initialize(x0 + rectText.Left - Padding, y0 + rectText.Top - Padding, x0 + rectText.Right + Padding, y0 + rectText.Bottom + Padding)
	cvsTest.DrawRect(rectTextOuter, xui.Color_Blue, True, 1dip)
	cvsTest.DrawText(Text, x0, y0, fntText, xui.Color_Yellow, "LEFT")
	
	Log("Left = " & rectText.Left)
	Log("CenterX = " & rectText.CenterX)
	Log("Right = " & rectText.Right)
	Log("Width = " & rectText.Width)
	Log("Top = " & rectText.Top)
	Log("CenterY = " & rectText.CenterY)
	Log("Bottom = " & rectText.Bottom)
	Log("Height = " & rectText.Height)
End Sub

