﻿Type=Class
Version=4.2
ModulesStructureVersion=1
B4J=true
@EndOfDesignText@
'Custom View class
#Event: ExampleEvent (Value As Int)
#DesignerProperty: Key: BooleanExample, DisplayName: Boolean Example, FieldType: Boolean, DefaultValue: True, Description: Example of a boolean property.
#DesignerProperty: Key: IntExample, DisplayName: Int Example, FieldType: Int, DefaultValue: 10, MinRange: 0, MaxRange: 100, Description: Note that MinRange and MaxRange are optional.
#DesignerProperty: Key: StringWithListExample, DisplayName: String With List, FieldType: String, DefaultValue: Sunday, List: Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday
#DesignerProperty: Key: StringExample, DisplayName: String Example, FieldType: String, DefaultValue: Text
#DesignerProperty: Key: ColorExample, DisplayName: Color Example, FieldType: Color, DefaultValue: 0xFFCFDCDC, Description: You can use the built-in color picker to find the color values.
Sub Class_Globals
	Private fx As JFX
	Private cEventName As String 'ignore
	Private cCallBack As Object 'ignore
	Private mBase As Pane
	Private pnlMain As Pane
	Private btnUp, btnDown As Button
	Private lblValue As Label
'	Private CSSUtils As CallSubUtils

	Private cLeft, cTop, cWidth, cHeight, btnWidth As Int
	Private cText As String
	Private cValueIndex As Int
	Private lstValues As List
	Private cParent As Pane
	Private cTag As String
End Sub

Public Sub Initialize (CallBack As Object, EventName As String)
	cEventName = EventName
	cCallBack = CallBack
End Sub

Public Sub DesignerCreateView (Base As Pane, lbl As Label, Props As Map)
	mBase = Base
	cParent = mBase.Parent
	
	cLeft = mBase.Left
	cTop = mBase.Top
	cWidth = mBase.Width
	cHeight = mBase.Height
	
	pnlMain = mBase
	cText = lbl.Text
	cTag = mBase.Tag
End Sub

Public Sub AddToParent(Parent As Pane, Left As Int, Top As Int, Width As Int, Height As Int)
	cParent = Parent
	
	cLeft = Left
	cTop = Top
	cWidth = Width
	cHeight = Height	
	cParent.AddNode(pnlMain, cLeft, cTop, cWidth, cHeight)
	Init
End Sub

Private Sub Base_Resize (Width As Double, Height As Double)
	cWidth = mBase.Width
	cHeight = mBase.Height	
	Init
End Sub

Private Sub Init
	btnWidth = 0.8 * cHeight
	lblValue.Initialize("")
	pnlMain.AddNode(lblValue, 0, 0, cWidth - 2 * btnWidth, cHeight)
	lblValue.Text =	cText
	lblValue.TextSize = cHeight / 1.8
	lblValue.Alignment = "CENTER"
	CSSUtils.SetBorder(lblValue, 1, fx.Colors.LightGray, 3)

	btnUp.Initialize("btnUp")
	pnlMain.AddNode(btnUp, cWidth - 2 * btnWidth, 0, btnWidth, cHeight)
	btnUp.Text = "▲"
	btnUp.TextSize = cHeight / 3
	btnUp.Alignment = "CENTER"
		
	btnDown.Initialize("btnDown")
	pnlMain.AddNode(btnDown, cWidth - btnWidth, 0, btnWidth, cHeight)
	btnDown.Text = "▼" 
	btnDown.TextSize = cHeight / 3
	btnDown.Alignment = "CENTER"
End Sub	

Private Sub btnUp_MouseClicked (EventData As MouseEvent)
	If EventData.PrimaryButtonPressed = True Then
		If cValueIndex < lstValues.Size - 1 Then
			cValueIndex = cValueIndex + 1
			lblValue.Text = lstValues.Get(cValueIndex)
			ValueChanged(lstValues.Get(cValueIndex))
		End If
	End If
End Sub

Private Sub btnDown_MouseClicked (EventData As MouseEvent)
	If EventData.PrimaryButtonPressed = True Then
		If cValueIndex > 0 Then
			cValueIndex = cValueIndex - 1
			lblValue.Text = lstValues.Get(cValueIndex)
			ValueChanged(lstValues.Get(cValueIndex))
		End If	
	End If
End Sub

Public Sub SetValues(Values As List)
	lstValues = Values
End Sub

Public Sub setValueIndex(Index As Int)
	cValueIndex = Index
	lblValue.Text = lstValues.Get(cValueIndex)
	ValueChanged(lstValues.Get(cValueIndex))
End Sub

Public Sub getValueIndex As Int
	Return cValueIndex
End Sub

Public Sub getValue As Int
	Return lstValues.Get(cValueIndex)
End Sub

Public Sub setTag(Tag As Object)
	cTag = Tag
End Sub

Public Sub getTag As Object
	Return cTag
End Sub

Private Sub ValueChanged(Value As Object)
	If SubExists(cCallBack, cEventName & "_ValueChanged") Then
		CallSub2(cCallBack, cEventName & "_ValueChanged", Value)
	End If
End Sub