#include "B4RDefines.h"

B4R::Serial* b4r_main::_serial1;
B4R::Pin* b4r_main::_pinbutton;
B4R::Pin* b4r_main::_pinpot;
B4R::Pin* b4r_main::_pinled;
bool b4r_main::_sateon_off;
B4R::Timer* b4r_main::_timerpulseperiod;
ULong b4r_main::_pulsewidth;
ULong b4r_main::_pulseperiod;
ULong b4r_main::_bouncetime;
ULong b4r_main::_bouncedelay;
static B4R::Serial be_gann1_3;
static B4R::Pin be_gann2_3;
static B4R::Pin be_gann2_7;
static B4R::Pin be_gann2_11;
static B4R::Timer be_gann4_3;


 void b4r_main::_appstart(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 19;BA.debugLine="Private Sub AppStart";
 //BA.debugLineNum = 20;BA.debugLine="Serial1.Initialize(115200)";
b4r_main::_serial1->Initialize((ULong) (115200));
 //BA.debugLineNum = 21;BA.debugLine="Log(\"AppStart\")";
B4R::Common::LogHelper(1,102,F("AppStart"));
 //BA.debugLineNum = 24;BA.debugLine="pinButton.Initialize(pinButton.A5, pinButton.MODE";
b4r_main::_pinbutton->Initialize(Pin_A5,Pin_MODE_INPUT_PULLUP);
 //BA.debugLineNum = 25;BA.debugLine="pinButton.AddListener(\"pinButton_StateChanged\")";
b4r_main::_pinbutton->AddListener(_pinbutton_statechanged);
 //BA.debugLineNum = 27;BA.debugLine="pinLED.Initialize(10, pinLED.MODE_OUTPUT)";
b4r_main::_pinled->Initialize((Byte) (10),Pin_MODE_OUTPUT);
 //BA.debugLineNum = 29;BA.debugLine="pinPot.Initialize(pinPot.A2, pinPot.MODE_INPUT)";
b4r_main::_pinpot->Initialize(Pin_A2,Pin_MODE_INPUT);
 //BA.debugLineNum = 31;BA.debugLine="TimerPulsePeriod.Initialize(\"TimerPulsePeriod_Tic";
b4r_main::_timerpulseperiod->Initialize(_timerpulseperiod_tick,b4r_main::_pulseperiod);
 //BA.debugLineNum = 32;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}
void b4r_main::_endpulse(Byte _tag){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 70;BA.debugLine="Private Sub EndPulse(Tag As Byte)";
 //BA.debugLineNum = 71;BA.debugLine="pinLED.DigitalWrite(False)				'switch the LED OFF";
b4r_main::_pinled->DigitalWrite(Common_False);
 //BA.debugLineNum = 73;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}
void b4r_main::_pinbutton_statechanged(bool _state){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 34;BA.debugLine="Private Sub pinButton_StateChanged (State As Boole";
 //BA.debugLineNum = 37;BA.debugLine="If State = False Then";
if (_state==Common_False) { 
 //BA.debugLineNum = 38;BA.debugLine="If Millis - BounceTime < BounceDelay Then";
if (Common_Millis()-b4r_main::_bouncetime<b4r_main::_bouncedelay) { 
 //BA.debugLineNum = 39;BA.debugLine="Return";
B4R::StackMemory::cp = cp;
if (true) return ;
 }else {
 //BA.debugLineNum = 41;BA.debugLine="SateON_OFF = Not(SateON_OFF)";
b4r_main::_sateon_off = Common_Not(b4r_main::_sateon_off);
 //BA.debugLineNum = 42;BA.debugLine="BounceTime = Millis";
b4r_main::_bouncetime = Common_Millis();
 //BA.debugLineNum = 43;BA.debugLine="TimerPulsePeriod.Enabled = SateON_OFF";
b4r_main::_timerpulseperiod->setEnabled(b4r_main::_sateon_off);
 //BA.debugLineNum = 45;BA.debugLine="If SateON_OFF = False Then";
if (b4r_main::_sateon_off==Common_False) { 
 //BA.debugLineNum = 46;BA.debugLine="pinLED.DigitalWrite(False)";
b4r_main::_pinled->DigitalWrite(Common_False);
 };
 };
 };
 //BA.debugLineNum = 50;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}

void b4r_main::initializeProcessGlobals() {
     B4R::StackMemory::buffer = (byte*)malloc(STACK_BUFFER_SIZE);
     b4r_main::_process_globals();

   
}
void b4r_main::_process_globals(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 8;BA.debugLine="Sub Process_Globals";
 //BA.debugLineNum = 9;BA.debugLine="Public Serial1 As Serial";
b4r_main::_serial1 = &be_gann1_3;
 //BA.debugLineNum = 10;BA.debugLine="Private pinButton, pinPot, pinLED As Pin";
b4r_main::_pinbutton = &be_gann2_3;
b4r_main::_pinpot = &be_gann2_7;
b4r_main::_pinled = &be_gann2_11;
 //BA.debugLineNum = 11;BA.debugLine="Private SateON_OFF = False As Boolean	'state ON o";
b4r_main::_sateon_off = Common_False;
 //BA.debugLineNum = 12;BA.debugLine="Private TimerPulsePeriod As Timer			'Timer for Pu";
b4r_main::_timerpulseperiod = &be_gann4_3;
 //BA.debugLineNum = 13;BA.debugLine="Private PulseWidth As ULong						'calculated in T";
b4r_main::_pulsewidth = 0L;
 //BA.debugLineNum = 14;BA.debugLine="Private PulsePeriod = 50 As ULong		'remains const";
b4r_main::_pulseperiod = (ULong) (50);
 //BA.debugLineNum = 15;BA.debugLine="Private BounceTime As ULong";
b4r_main::_bouncetime = 0L;
 //BA.debugLineNum = 16;BA.debugLine="Private BounceDelay = 10 As ULong";
b4r_main::_bouncedelay = (ULong) (10);
 //BA.debugLineNum = 17;BA.debugLine="End Sub";
}
void b4r_main::_timerpulseperiod_tick(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 52;BA.debugLine="Private Sub TimerPulsePeriod_Tick";
 //BA.debugLineNum = 59;BA.debugLine="PulseWidth = MapRange(pinPot.AnalogRead, 0, 1023,";
b4r_main::_pulsewidth = (ULong) (Common_MapRange((Long) (b4r_main::_pinpot->AnalogRead()),(Long) (0),(Long) (1023),(Long) (0),(Long) (b4r_main::_pulseperiod)));
 //BA.debugLineNum = 60;BA.debugLine="If PulseWidth = PulsePeriod Then	'100% modulation";
if (b4r_main::_pulsewidth==b4r_main::_pulseperiod) { 
 //BA.debugLineNum = 61;BA.debugLine="pinLED.DigitalWrite(True)				'switch the LED ON";
b4r_main::_pinled->DigitalWrite(Common_True);
 }else if(b4r_main::_pulsewidth==0) { 
 //BA.debugLineNum = 63;BA.debugLine="pinLED.DigitalWrite(False)			'switch the LED OFF";
b4r_main::_pinled->DigitalWrite(Common_False);
 }else {
 //BA.debugLineNum = 65;BA.debugLine="pinLED.DigitalWrite(True)				'switch the LED ON";
b4r_main::_pinled->DigitalWrite(Common_True);
 //BA.debugLineNum = 66;BA.debugLine="CallSubPlus(\"EndPulse\", PulseWidth, 0)";
B4R::__c->CallSubPlus(_endpulse,b4r_main::_pulsewidth,(Byte) (0));
 };
 //BA.debugLineNum = 68;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}
