﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=7.8
@EndOfDesignText@
'xCustomButton CustomView cross platform class.
'Version 1.0
'Author: Klaus CHRISTL (klaus)
'
'Events declarations
#Event: Click
#Event: LongClick
#Event: CheckedChange(Checked As Boolean)
#RaisesSynchronousEvents: Click
#RaisesSynchronousEvents: LongClick
#RaisesSynchronousEvents: CheckedChange

'Designer property declarations
#DesignerProperty: Key: ButtonType, DisplayName: ButtonType, FieldType: String, DefaultValue: STANDARD, List: STANDARD|TOGGLE, Description: Select the buttton type.
#DesignerProperty: Key: Text, DisplayName: Text, FieldType: String, DefaultValue: Text, Description: Text at the bottom of the button; is also the OFF text for a TOGGLE button.
#DesignerProperty: Key: OnStateText, DisplayName: OnStateText, FieldType: String, DefaultValue: ON, Description: Text at the bottom of the button in the ON state.
#DesignerProperty: Key: BackgroundColor, DisplayName: BackgroundColor, FieldType: Color, DefaultValue: 0x00FFFFFF, Description: Background color.
#DesignerProperty: Key: PressedColor, DisplayName: PressedColor, FieldType: Color, DefaultValue: 0xFFFFFF00, Description: Background color when the button is pressed.
#DesignerProperty: Key: OnStateColor, DisplayName: OnStateColor, FieldType: Color, DefaultValue: 0xFFFF00FF, Description: Color for the icon and the text in the ON state.
#DesignerProperty: Key: OnStateBackgroundColor, DisplayName: OnStateBackgroundColor, FieldType: Color, DefaultValue: 0x00FFFFFF, Description: Color of the background for the ON state.

'xCustomButton is a button based on a Panel with two Labels
'one with a Material Icon and the other with text.
'It has two button types: 
'STANDARD with two events: Click and LongClick.
'TOGGLE with one event CheckedChange.
Sub Class_Globals
#If B4J
	Private fx As JFX
#End If
	Private xui As XUI

	Private mEventName As String
	Private mCallBack As Object
	Public mBase As B4XView
	Public Tag As Object
	
	Private mLeft, mTop, mWidth, mHeight As Int
	Private mText, mIcon As String
	
	Private mLabelFont, mIconFont As B4XFont
	
	Private mTextColor As Int
	Private mIconTextSize, mLabelTextSize As Double
	
	Private mLabel, mIconLabel As B4XView
	Private mParent As B4XView
	Private cvsBase As B4XCanvas
	Private rectBase As B4XRect
	Private mPressedColor, mBackgroundColor, mOnStateColor, mOnStateBackgroundColor As Int
	Private mONState = False As Boolean
	Private mButtonType As String
	Private mOnStateText As String
	
	Private tmrClick As Timer
	Private mTimeDown, mClickTime As Long	'used to distinguish Click and LongClick
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	
	mIcon = Chr(0xE859)
	mText = "Test"
	mTextColor = xui.Color_Black
	
	mClickTime = 400
	tmrClick.Initialize("tmrClick", mClickTime)
	
	mPressedColor = xui.Color_Yellow
	mButtonType = "STANDARD"
	mBackgroundColor = xui.Color_Transparent
	mOnStateColor = xui.Color_Blue
End Sub

Public Sub DesignerCreateView (Base As Object, Lbl As Label, Props As Map)
	'we use a Dummy obkect to get the Tag property and the Parent.
	Private mDummy As B4XView
	mDummy = Base
	mLeft = mDummy.Left
	mTop = mDummy.Top
	mWidth = mDummy.Width
	mHeight = mDummy.Height
	Tag = mDummy.Tag
	mIcon = Lbl.Text
	mText = Props.Get("Text")
	mPressedColor = xui.PaintOrColorToColor(Props.Get("PressedColor"))
	mBackgroundColor = xui.PaintOrColorToColor(Props.Get("BackgroundColor"))
	If mBackgroundColor = 16777215 Then
		mBackgroundColor = xui.Color_Transparent
	End If
	mButtonType = Props.Get("ButtonType")
	mOnStateText = Props.Get("OnStateText")
	mOnStateColor = xui.PaintOrColorToColor(Props.Get("OnStateColor"))
	mOnStateBackgroundColor = xui.PaintOrColorToColor(Props.Get("OnStateBackgroundColor"))
	
	'we create a new mBase object to get the Touch event
	mBase = xui.CreatePanel("mBase")
	mParent = mDummy.Parent
	mParent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	mBase.Tag = Me
	
	mTextColor = xui.PaintOrColorToColor(Lbl.TextColor)
	
	'we remove the mDumm / Base object, no more needed
	mDummy.RemoveViewFromParent
	
	mIconFont = Lbl.As(B4XView).Font
	
	InitClass
End Sub

Public Sub GetBase As Object
	Return mBase
End Sub

Public Sub AddToParent(Parent As Object, Left As Int, Top As Int, Width As Int, Height As Int, TextColor As Object, Icon As String, Text As String)
	mLeft = Left
	mTop = Top
	mWidth = Width
	mHeight = Height
	mParent = Parent

	mBase = xui.CreatePanel("mBase")
	
	mParent.AddView(mBase, mLeft, mTop, mWidth, mHeight)
	mBase.Tag = Me
	
	mIcon = Icon
	mText = Text
	mTextColor = xui.PaintOrColorToColor(TextColor)
	
	mIconFont = xui.CreateMaterialIcons(10)
	
	InitClass
End Sub

Private Sub InitClass
	'calculate the dimensions of the internal Labels
	Private lblLeft, lblWidth  As Int
	lblWidth = 2 * mHeight / 3		'icon Label width and height = 2/3 of button height
	lblLeft = (mWidth - lblWidth) / 2
	
	'initialize and add the icon Label
	Private lbl As Label
	lbl.Initialize("")
	mIconLabel = lbl
	
	mIconTextSize = mHeight / 2 / xui.Scale
	mLabelTextSize = lblWidth / 3 / xui.Scale
	mLabelFont = xui.CreateDefaultFont(10)	
	
	mIconLabel.Font = mIconFont
	mIconLabel.SetTextAlignment("CENTER", "CENTER")
	mIconLabel.TextSize = mIconTextSize
	mIconLabel.TextColor = xui.PaintOrColorToColor(mTextColor)
	mBase.AddView(mIconLabel, lblLeft, 0, lblWidth, lblWidth)
	mIconLabel.Text = mIcon
	
	'initialize and add the text Label
	Private lbl As Label
	lbl.Initialize("")
	mLabel = lbl
	mLabel.SetTextAlignment("TOP", "CENTER")
	mLabel.Font = mLabelFont
	mLabel.TextSize = mLabelTextSize
	mLabel.TextColor = xui.PaintOrColorToColor(mTextColor)
	mBase.AddView(mLabel, 0, 2 * mHeight / 3, mWidth, mHeight / 3)
	mLabel.Text = mText
	
	cvsBase.Initialize(mBase)
	rectBase.Initialize(0, 0, mBase.Width, mBase.Height)
End Sub

Private Sub mBase_Touch (Action As Int, X As Float, Y As Float)
	Select Action
		Case mBase.TOUCH_ACTION_DOWN
			mTimeDown = DateTime.Now
			tmrClick.Enabled = True
			Select mButtonType
				Case "STANDARD"
					mBase.Color = mPressedColor
				Case "TOGGLE"
					If mONState = False Then
						mBase.Color = mOnStateBackgroundColor
						mONState = True
						mLabel.Text = mOnStateText
						mLabel.TextColor = mOnStateColor
						mIconLabel.TextColor = mOnStateColor
					Else
						If mBackgroundColor = xui.Color_Transparent Then
							cvsBase.ClearRect(rectBase)
							cvsBase.Invalidate
						Else
							mBase.Color = mBackgroundColor
						End If
						mONState = False
						mLabel.Text = mText
						mLabel.TextColor = mTextColor
						mIconLabel.TextColor = mTextColor
					End If
			End Select
		Case mBase.TOUCH_ACTION_UP
			Select mButtonType
				Case "STANDARD"
					If DateTime.Now - mTimeDown <= mClickTime Then
						If xui.SubExists(mCallBack, mEventName & "_Click", 0) Then
							CallSubDelayed(mCallBack, mEventName & "_Click")
							tmrClick.Enabled = False
						End If
					End If
					mBase.Color = mBackgroundColor
				Case "TOGGLE"
					If xui.SubExists(mCallBack, mEventName & "_CheckedChange", 1) Then
						CallSubDelayed2(mCallBack, mEventName & "_CheckedChange", mONState)
						tmrClick.Enabled = False
					End If
			End Select
	End Select
End Sub

Private Sub tmrClick_Tick
	If xui.SubExists(mCallBack, mEventName & "_LongClick", 0) Then
		CallSubDelayed(mCallBack, mEventName & "_LongClick")
		tmrClick.Enabled = False
	End If
End Sub

'set the LabelFont property
'it must be B4XFont text font
Public Sub setLabelFont(LabelFont As B4XFont)
	mLabelFont = LabelFont
	mLabel.Font = mLabelFont
	mLabel.TextSize = mLabelTextSize
End Sub

'set the icon IconFont property
'should be "FontAwesome or "Material Icons" B4XFont font
Public Sub setIconFont(IconFont As B4XFont)
	mIconFont = IconFont
	mIconLabel.Font = mIconFont
	mIconLabel.TextSize = mIconTextSize
End Sub

Public Sub getIconFont As B4XFont
	Return mIconFont
End Sub

'get or set the Icon property
'should be "FontAwesome Icons or "Material Icons" Icons
Public Sub setIcon(Icon As String)
	mIconLabel.Text = Icon
End Sub

Public Sub getIcon As String
	Return mIconLabel.Text
End Sub

'get or set the PressedColor property
'Background color when the button is pressed.
'it must be y xui color
Public Sub setPressedColor(PressedColor As Int)
	mPressedColor = PressedColor
End Sub

Public Sub getPressedColor As Int
	Return mPressedColor
End Sub

'get or set the BackgroundColor property
'it must be y xui color
Public Sub setBackgroundColor(BackgroundColor As Int)
	mBackgroundColor = BackgroundColor
End Sub

Public Sub getBackgroundColor As Int
	Return mBackgroundColor
End Sub

'get or set the Text property
'Text at the bottom of the button; is also the OFF text for a TOGGLE button.
'is also the OFF text for a TOGGLE button
Public Sub setText(Text As String)
	mText = Text
End Sub

Public Sub getText As String
	Return mText
End Sub

'get or set the OnStateText property
'Text at the bottom of the button in the ON state.
Public Sub setOnStateText(OnStateText As String)
	mOnStateText = OnStateText
End Sub

Public Sub getOnStateText As String
	Return mOnStateText
End Sub

'get or set the OnStateColor property
'color for the icon and the text in the ON state.
'it must be y xui color
Public Sub setOnStateColor(OnStateColor As String)
	mOnStateColor = OnStateColor
End Sub

Public Sub getOnStateColor As String
	Return mOnStateColor
End Sub

'get or set the OnStateBackgroundColor property
Public Sub setOnStateBackgroundColor(OnStateBackgroundColor As String)
	mOnStateBackgroundColor = OnStateBackgroundColor
End Sub

Public Sub getOnStateBackgroundColor As String
	Return mOnStateBackgroundColor
End Sub
