﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=StaticCode
Version=6.47
@EndOfDesignText@
'Static code module
Sub Process_Globals
	Private xui As XUI
	Private fx As JFX
	
	Public SelectedRowID As Long
	Public RowIDList As List
	
	Private frmProducts As Form
	Private tblData As B4XTable
	Private lblSelectedItem As B4XView
End Sub

Public Sub Show
	If frmProducts.IsInitialized = False Then
		frmProducts.Initialize("frmProducts", 600, 600)
		frmProducts.RootPane.LoadLayout("ShowTable")
		frmProducts.Title = "SLQiteLight4   Products"
	End If

	ShowTableProducts
	
	frmProducts.Show
End Sub

Private Sub frmProducts_Closed
	B4XPages.MainPage.ShowTableStock
End Sub

Sub btnAdd_Click
	B4XPages.MainPage.ProductEditMode = "Add"
	EditProduct.Show
End Sub

Sub btnEdit_Click
	B4XPages.MainPage.ProductEditMode = "Edit"
	EditProduct.Show
End Sub

Sub btnDelete_Click
	Private sf As Object = xui.Msgbox2Async("Do you really want to delete the selected entry ?", "D E L E T E", "Yes", "", "No", Null)
	Wait For (sf) Msgbox_Result (Result As Int)

	If Result = xui.DialogResponse_Positive Then
		B4XPages.MainPage.SQL1.ExecNonQuery("DELETE FROM Stock WHERE rowid = " & SelectedRowID)
		ShowTableProducts
	End If
End Sub

Sub ShowTableProducts
	Private Query As String
	
	Query = "SELECT Products.Name, Products.Price, Suppliers.Name AS Supplier "
	Query = Query & "FROM Products, Suppliers "
	Query = Query & "WHERE Suppliers.rowid = Products.SupplierID"

'	wbvTable.LoadHtml(Utils.ExecuteHtml(B4XPages.MainPage.SQL1, Query, Null, 0, True)) '***
	ReadDataBaseIDs
End Sub

'Reads the database IDs in IDList
Sub ReadDataBaseIDs
	Private ResultSet1 As ResultSet
	
	RowIDList.Initialize		'initialize the ID list

	'We read only the ID column and put them in a List
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery("SELECT rowid FROM Products")
	
'	If ResultSet1.RowCount > 0 Then		'check if entries exist
		RowIDList.Initialize						'initialize the ID list
		
		Do While ResultSet1.NextRow
			RowIDList.Add(ResultSet1.GetInt2(0))		'add the ID's to the ID list
		Loop
'	Else
'		ToastMessageShow("No items found", False)
'	End If
	ResultSet1.Close									'close the ResultSet, we don't need it anymore
End Sub

Sub UpdateSelectedItem
	Private Query As String
	Private ResultSet1 As ResultSet
	
	Query = "SELECT Products.Name, Suppliers.Name"
	Query = Query & " FROM Products, Suppliers"
	Query = Query & " WHERE Products.rowid = " & SelectedRowID & " AND Suppliers.rowID = Products.SupplierID"

	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery(Query)
	ResultSet1.NextRow
	lblSelectedItem.Text = ResultSet1.GetString2(0) & " / " & ResultSet1.GetString2(1)

	ResultSet1.Close
End Sub

'Routine from the DBUtils demo program, equivalent to the Click event
Sub wbvTable_LocationChanged (Location As String)
	'parse the row and column numbers from the URL

	If Location.Contains("stub") Then
		Private values() As String
		Private Row As Int

		values = Regex.Split("[.]", Location.SubString(7))
	
		Row = values(1)
		SelectedRowID = RowIDList.Get(Row)
	
		UpdateSelectedItem
	End If
End Sub
