﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=10.7
@EndOfDesignText@
'BlueToothAdministration Class
'version: 1.00

#Event: Connected (Success As Boolean)
#Event: StateChanged (State As String)
Sub Class_Globals
	Private Admin As BluetoothAdmin
	Public Ast As AsyncStreamsManagement
	Private Serial As Serial
	Private PH As Phone
	Private mParent As Object
	Private mEventName As String
	Private lblStatus As Label
	Private ProgressBar1 As ProgressBar

	Private GenericDeviceName, DeviceName As String
	
	Public BluetoothState, ConnectionState, DeviceFound As Boolean
	Private DeviceName, DeviceMacAdress As String
	
	Public CharSet = "UTF-8" As String
	Public State As String
End Sub

'Initializes the object.
'Parent = Parent modu
'EventName = generic event name
'Code Example: <code>
'Private BT As BluetoothManagement
'BT.Initialize(Me, "BT")</code>
Public Sub Initialize(Parent As Object, EventName As String, StatusLabel As Label, Pgb As ProgressBar)
	mParent = Parent
	mEventName = EventName
	lblStatus = StatusLabel
	Admin.Initialize("Admin")
	Serial.Initialize("Serial")
	ProgressBar1 = Pgb
	
	If Admin.IsEnabled = False Then
		If Admin.Enable = False Then
			ToastMessageShow("Error enabling Bluetooth adapter.", True)
		Else
			ToastMessageShow("Enabling Bluetooth adapter...", False)
		End If
	Else
		BluetoothState = True
	End If
End Sub

Public Sub Connect(Name As String) 
	GenericDeviceName = Name
	Dim success As Boolean = Admin.StartDiscovery
	If success = False Then
		lblStatus.Text = "Error starting discovery process."
	Else
		lblStatus.Text = "Start discovery"
		ProgressBar1.Visible = True
	End If
End Sub

Public Sub Disconnect
	If Ast.AStreams.IsInitialized Then Ast.AStreams.Close
	If Serial.IsInitialized Then Serial.Disconnect
End Sub

'event raised when a device is found
Private Sub Admin_DeviceFound (Name As String, MacAddress As String)
	Log(Name & ":" & MacAddress)
	If Name.Contains(GenericDeviceName) Then
		Log(GenericDeviceName & " found")
		DeviceName = Name
		DeviceMacAdress = MacAddress
		'unfortunately we must wait for the end of discovery on newer devices
		'with the call below, my device, Android 11, throughs the error below.
		'java.io.IOException: read failed, socket might closed or timeout, read ret: -1
		If PH.SdkVersion <= 24 Then
			Admin.CancelDiscovery
			lblStatus.Text = GenericDeviceName & " found"
		Else
			lblStatus.Text = GenericDeviceName & " found, please wait."
		End If
	End If
End Sub

'event raised when discovery is finished
'Admin.StartDiscovery starts the discovery for about 12 seconds
'After this time, the DiscoveryFinished event is raised or if Admin.CancelDiscovery is called 
Private Sub Admin_DiscoveryFinished
	If DeviceName = "" Then
		lblStatus.Text = "Device " & GenericDeviceName & " Not found"
	Else
		lblStatus.Text = "Connecting to: " & GenericDeviceName
		Serial.Connect(DeviceMacAdress)
	End If
End Sub

Private Sub Admin_StateChanged (NewState As Int, OldState As Int)
	Log("State changed: " & NewState)
	lblStatus.Text = "State changed: " & NewState
	BluetoothState = NewState = Admin.STATE_ON
End Sub

'will be called when a client connects to this device
Sub Serial_Connected (Success As Boolean)
	Private msg As String
	If Success = True Then
		If Ast.IsInitialized Then Ast.Close
		Ast.Initialize(Me, "Ast", Serial.InputStream, Serial.OutputStream)
		msg = "Connected"
		ProgressBar1.Visible = False
	Else
		Log(LastException.Message)
		msg = LastException.Message
	End If
	lblStatus.Text = msg
	CallSubDelayed2(mParent, mEventName & "_Connected", Success)
End Sub

'sends an Array of Bytes via AsynchStreams
Public Sub SendBytes(Buffer() As Byte)
	Ast.WriteBytes(Buffer)
End Sub

'sends a text via AsynchStreams
'the default CharacterSet is "UTF-8"
'you can define other CharacterSets with the CharSet variable
Public Sub SendText(Text As String)
	Ast.WriteBytes(Text.GetBytes(CharSet))
End Sub

Public Sub Ast_NewText(Text As String)
	CallSubDelayed2(mParent, mEventName & "_NewText", Text)
	Log(Text)
End Sub