﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Service
Version=7.3
@EndOfDesignText@
#Region  Service Attributes 
	#StartAtBoot: False
	#ExcludeFromLibrary: True
#End Region

Sub Process_Globals
	Private serial As Serial
	Public admin As BluetoothAdmin
	Private ast As AsyncStreamsText
	Public Connected = False As Boolean
	Public Connecting = False As Boolean
	Public TryToConnect = False As Boolean
End Sub

Sub Service_Create
	serial.Initialize("serial")
	admin.Initialize("admin")
End Sub

Public Sub Connect
	admin.StartDiscovery
	TryToConnect = True
	CallSub(Main, "SetState")
End Sub

Private Sub admin_DeviceFound (Name As String, MacAddress As String)
	Log($"Device found: ${Name}"$)
	If Name = "HC-05" Then
		Log("CancelDiscovery")
		admin.CancelDiscovery
		Log("Connect serial")
		Log(MacAddress)
		serial.Connect(MacAddress)
		Log("Connected?")
		TryToConnect = False
		Connecting = True
		CallSub(Main, "SetState")
	End If
End Sub

Private Sub admin_DiscoveryFinished
	If Connecting = False Then
		TryToConnect = False
		CallSub(Main, "SetState")	
	End If
End Sub

Private Sub admin_StateChanged (NewState As Int, OldState As Int)
	Log("OldState " &	OldState)
	Log("NewState " &	NewState)
End Sub

Private Sub Serial_Connected (Success As Boolean)
	If Success Then
		If ast.IsInitialized Then ast.Close
		ast.Initialize(Me, "Ast", serial.InputStream, serial.OutputStream)
		Log("Connected")
		Connected = True
	Else
		Log(LastException)
	End If
	Connecting = False
	CallSub(Main, "SetState")
End Sub

Public Sub SendMessage(msg() As Byte)
	ast.astreams.Write(msg) 'sending bytes, not text
End Sub

Private Sub ast_NewText (Text As String)
	CallSub2(Main, "MessageFromDevice", Text)
End Sub

Private Sub ast_Terminated
	Connected = False
	CallSub(Main, "SetState")
End Sub

Sub Service_Start (StartingIntent As Intent)

End Sub

'Return true to allow the OS default exceptions handler to handle the uncaught exception.
Sub Application_Error (Error As Exception, StackTrace As String) As Boolean
	Return True
End Sub

Sub Service_Destroy

End Sub
