#include "B4RDefines.h"

B4R::Serial* b4r_main::_serial1;
B4R::Pin* b4r_main::_pinbutton;
B4R::Pin* b4r_main::_pinpot;
B4R::Pin* b4r_main::_pinledblue;
bool b4r_main::_reading;
B4R::Timer* b4r_main::_timer1;
ULong b4r_main::_bouncetime;
ULong b4r_main::_bouncedelay;
static B4R::Serial be_gann1_3;
static B4R::Pin be_gann2_3;
static B4R::Pin be_gann2_7;
static B4R::Pin be_gann2_11;
static B4R::Timer be_gann4_3;


 void b4r_main::_appstart(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 17;BA.debugLine="Private Sub AppStart";
 //BA.debugLineNum = 18;BA.debugLine="Serial1.Initialize(115200)";
b4r_main::_serial1->Initialize((ULong) (115200));
 //BA.debugLineNum = 19;BA.debugLine="Log(\"AppStart\")";
B4R::Common::LogHelper(1,102,F("AppStart"));
 //BA.debugLineNum = 22;BA.debugLine="pinButton.Initialize(pinButton.A5, pinButton.MODE";
b4r_main::_pinbutton->Initialize(Pin_A5,Pin_MODE_INPUT_PULLUP);
 //BA.debugLineNum = 23;BA.debugLine="pinButton.AddListener(\"pinButton_StateChanged\")";
b4r_main::_pinbutton->AddListener(_pinbutton_statechanged);
 //BA.debugLineNum = 25;BA.debugLine="pinLedBlue.Initialize(10, pinLedBlue.MODE_OUTPUT)";
b4r_main::_pinledblue->Initialize((Byte) (10),Pin_MODE_OUTPUT);
 //BA.debugLineNum = 27;BA.debugLine="Timer1.Initialize(\"Timer1_Tick\", 200)";
b4r_main::_timer1->Initialize(_timer1_tick,(ULong) (200));
 //BA.debugLineNum = 29;BA.debugLine="pinPot.Initialize(pinPot.A1, pinPot.MODE_INPUT)";
b4r_main::_pinpot->Initialize(Pin_A1,Pin_MODE_INPUT);
 //BA.debugLineNum = 30;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}
void b4r_main::_pinbutton_statechanged(bool _state){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 32;BA.debugLine="Sub pinButton_StateChanged (State As Boolean)";
 //BA.debugLineNum = 33;BA.debugLine="Log(\"State: \", State)";
B4R::Common::LogHelper(2,102,F("State: "),8,_state);
 //BA.debugLineNum = 35;BA.debugLine="If State = False Then";
if (_state==Common_False) { 
 //BA.debugLineNum = 36;BA.debugLine="If Millis - BounceTime < BounceDelay Then";
if (Common_Millis()-b4r_main::_bouncetime<b4r_main::_bouncedelay) { 
 //BA.debugLineNum = 37;BA.debugLine="Return";
B4R::StackMemory::cp = cp;
if (true) return ;
 }else {
 //BA.debugLineNum = 39;BA.debugLine="Reading = Not(Reading)";
b4r_main::_reading = Common_Not(b4r_main::_reading);
 //BA.debugLineNum = 40;BA.debugLine="BounceTime = Millis";
b4r_main::_bouncetime = Common_Millis();
 //BA.debugLineNum = 41;BA.debugLine="Timer1.Enabled = Reading";
b4r_main::_timer1->setEnabled(b4r_main::_reading);
 //BA.debugLineNum = 42;BA.debugLine="Log(\"Reading: \", Reading)";
B4R::Common::LogHelper(2,102,F("Reading: "),8,b4r_main::_reading);
 //BA.debugLineNum = 43;BA.debugLine="If Reading = False Then";
if (b4r_main::_reading==Common_False) { 
 //BA.debugLineNum = 44;BA.debugLine="pinLedBlue.AnalogWrite(0)";
b4r_main::_pinledblue->AnalogWrite((UInt) (0));
 };
 };
 };
 //BA.debugLineNum = 48;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}

void b4r_main::initializeProcessGlobals() {
     B4R::StackMemory::buffer = (byte*)malloc(STACK_BUFFER_SIZE);
     b4r_main::_process_globals();

   
}
void b4r_main::_process_globals(){
const UInt cp = B4R::StackMemory::cp;
 //BA.debugLineNum = 8;BA.debugLine="Sub Process_Globals";
 //BA.debugLineNum = 9;BA.debugLine="Public Serial1 As Serial";
b4r_main::_serial1 = &be_gann1_3;
 //BA.debugLineNum = 10;BA.debugLine="Private pinButton, pinPot, pinLedBlue As Pin";
b4r_main::_pinbutton = &be_gann2_3;
b4r_main::_pinpot = &be_gann2_7;
b4r_main::_pinledblue = &be_gann2_11;
 //BA.debugLineNum = 11;BA.debugLine="Private Reading = False As Boolean";
b4r_main::_reading = Common_False;
 //BA.debugLineNum = 12;BA.debugLine="Private Timer1 As Timer";
b4r_main::_timer1 = &be_gann4_3;
 //BA.debugLineNum = 13;BA.debugLine="Private BounceTime As ULong";
b4r_main::_bouncetime = 0L;
 //BA.debugLineNum = 14;BA.debugLine="Private BounceDelay = 10 As ULong";
b4r_main::_bouncedelay = (ULong) (10);
 //BA.debugLineNum = 15;BA.debugLine="End Sub";
}
void b4r_main::_timer1_tick(){
const UInt cp = B4R::StackMemory::cp;
UInt _value = 0;
 //BA.debugLineNum = 50;BA.debugLine="Private Sub Timer1_Tick";
 //BA.debugLineNum = 51;BA.debugLine="Private Value As UInt";
_value = 0;
 //BA.debugLineNum = 52;BA.debugLine="Value = pinPot.AnalogRead";
_value = b4r_main::_pinpot->AnalogRead();
 //BA.debugLineNum = 53;BA.debugLine="Log(\"Value = \", Value)";
B4R::Common::LogHelper(2,102,F("Value = "),4,_value);
 //BA.debugLineNum = 54;BA.debugLine="pinLedBlue.AnalogWrite(Value / 4)";
b4r_main::_pinledblue->AnalogWrite((UInt) (_value/(Double)4));
 //BA.debugLineNum = 55;BA.debugLine="End Sub";
B4R::StackMemory::cp = cp;
}
