﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Activity
Version=6.8
@EndOfDesignText@
#Region  Activity Attributes 
	#FullScreen: False
	#IncludeTitle: True
#End Region

Sub Process_Globals
	Public Query As String
	Public Active = False As Boolean
	
	' Boolean operator used in the filter
	' can be OR or AND
	Public BooleanOperator = "AND " As String
	
	' Variables used to hold the selected indexes of the Spinners
	Public SelectedProduct As Int
	Public SelectedSupplier As Int
	Public SelectedDateBegin As Int
	Public SelectedDateEnd As Int

End Sub

Sub Globals
	Private spnProducts, spnSuppliers, spnDateBegin, spnDateEnd As Spinner
End Sub

Sub Activity_Create(FirstTime As Boolean)
	Activity.LoadLayout("FilterStock")
	Activity.Title = "SQLiteLight4  Stock filter"
	
	InitSpinners
End Sub

Sub Activity_Resume

End Sub

Sub Activity_Pause (UserClosed As Boolean)

End Sub

Sub InitSpinners
	Private i As Int
	Private Query As String
	Private Cursor1 As Cursor
	
	Query = "SELECT DISTINCT Name FROM Products"
	Cursor1 = Starter.SQL1.ExecQuery(Query)
	
	spnProducts.Clear
	spnProducts.Add("no filter")
	For i = 0 To Cursor1.RowCount - 1
		Cursor1.Position = i
		spnProducts.Add(Cursor1.GetString2(0))
	Next
	spnProducts.SelectedIndex = SelectedProduct
	
	Query = "SELECT DISTINCT Name FROM Suppliers"
	Cursor1 = Starter.SQL1.ExecQuery(Query)
	
	spnSuppliers.Clear
	spnSuppliers.Add("no filter")
	For i = 0 To Cursor1.RowCount - 1
		Cursor1.Position = i
		spnSuppliers.Add(Cursor1.GetString2(0))
	Next
	spnSuppliers.SelectedIndex = SelectedSupplier
	
	Query = "SELECT DISTINCT date(Stock.Date / 1000, 'unixepoch') AS Date FROM Stock ORDER BY Date ASC"
	Cursor1 = Starter.SQL1.ExecQuery(Query)
	
	spnDateBegin.Add("no filter")
	spnDateEnd.Add("no filter")
	For i = 0 To Cursor1.RowCount - 1
		Cursor1.Position = i
		spnDateBegin.Add(Cursor1.GetString2(0))
		spnDateEnd.Add(Cursor1.GetString2(0))
	Next		
	spnDateBegin.SelectedIndex = SelectedDateBegin
	spnDateEnd.SelectedIndex = SelectedDateEnd
End Sub

Private Sub spnProducts_ItemClick (Position As Int, Value As Object)
	SelectedProduct = Position
End Sub

Private Sub spnSuppliers_ItemClick (Position As Int, Value As Object)
	SelectedSupplier = Position
End Sub

Private Sub spnDateBegin_ItemClick (Position As Int, Value As Object)
	SelectedDateBegin = Position
End Sub

Private Sub spnDateEnd_ItemClick (Position As Int, Value As Object)
	SelectedDateEnd = Position
End Sub

Private Sub btnFilter_Click
	Query = BuildQuery	
	Active = True
	Activity.Finish
End Sub

Private Sub BuildQuery As String
	Private Query As String
	
	Query = ""
	
	If SelectedProduct > 0 Then
		Query = " AND Products.Name = '" & spnProducts.SelectedItem & "'"
	End If

	If SelectedSupplier > 0 Then
		Query = Query & " AND Suppliers.Name = '" & spnSuppliers.SelectedItem & "'"
	End If

	If SelectedDateBegin > 0 Or SelectedDateEnd > 0 Then
		If SelectedDateBegin = SelectedDateEnd Then
			Query = Query & " AND date(Stock.Date / 1000, 'unixepoch') = '" & spnDateBegin.SelectedItem & "' ORDER BY date(Stock.Date / 1000, 'unixepoch') ASC"
		Else If SelectedDateBegin > 0 And SelectedDateEnd > 0 Then
			If SelectedDateBegin <= SelectedDateEnd Then
				Query = Query & " AND date(Stock.Date / 1000, 'unixepoch') BETWEEN '" & spnDateBegin.SelectedItem & "' AND '" & spnDateEnd.SelectedItem & "' ORDER BY date(Stock.Date / 1000, 'unixepoch') ASC"
			Else
				Query = Query & " AND date(Stock.Date / 1000, 'unixepoch') BETWEEN '" & spnDateEnd.SelectedItem & "' AND '" & spnDateBegin.SelectedItem & "' ORDER BY date(Stock.Date / 1000, 'unixepoch') ASC"
			End If
		Else If SelectedDateBegin > 0 Then
			Query = Query & " AND date(Stock.Date / 1000, 'unixepoch') >= '" & spnDateBegin.SelectedItem & "' ORDER BY date(Stock.Date / 1000, 'unixepoch') ASC"
		Else If SelectedDateEnd > 0 Then
			Query = Query & " AND date(Stock.Date / 1000, 'unixepoch') <= '" & spnDateEnd.SelectedItem & "' ORDER BY date(Stock.Date / 1000, 'unixepoch') ASC"
		End If		
	End If		
	
	Return Query
End Sub