﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Activity
Version=6.8
@EndOfDesignText@
#Region  Activity Attributes 
	#FullScreen: False
	#IncludeTitle: True
#End Region

Sub Process_Globals
	Public EditMode As String
	Public SelectedRowID As Long
	Public RowIDList As List
End Sub

Sub Globals
	Private wbvTable As WebView
	Private lblSelectedItem As Label
End Sub

Sub Activity_Create(FirstTime As Boolean)
	Activity.LoadLayout("ShowTable")
	Activity.Title = "SLQiteLight4   Suppliers"
End Sub

Sub Activity_Resume
	ShowTableSuppliers
End Sub

Sub Activity_Pause (UserClosed As Boolean)

End Sub

Sub btnAdd_Click
	EditMode = "Add"
	StartActivity(EditSupplier)
End Sub

Sub btnEdit_Click
	EditMode = "Edit"
	StartActivity(EditSupplier)
End Sub

Sub btnDelete_Click
	Private Answ As Int
	
	Answ = Msgbox2("Do you really want to delete the selected entry ?", "D E L E T E", "Yes", "", "No", Null)
	
	If Answ = DialogResponse.POSITIVE Then
		Starter.SQL1.ExecNonQuery("DELETE FROM Stock WHERE rowid = " & SelectedRowID)
		ShowTableSuppliers
	End If
End Sub

Sub ShowTableSuppliers
	Private Query As String
	
	Query = "SELECT Name, Address, City "
	Query = Query & "FROM Suppliers "
	
	wbvTable.LoadHtml(Utils.ExecuteHtml(Starter.SQL1, Query, Null, 0, True))
	ReadDataBaseIDs
End Sub

'Reads the database IDs in IDList
Sub ReadDataBaseIDs
	Private ResultSet1 As ResultSet
	
	RowIDList.Initialize		'initialize the ID list

	'We read only the ID column and put them in a List
	ResultSet1 = Starter.SQL1.ExecQuery("SELECT rowid FROM Suppliers")
	
	If ResultSet1.RowCount > 0 Then						'check if entries exist
		RowIDList.Initialize							'initialize the ID list
		Do While ResultSet1.NextRow
			RowIDList.Add(ResultSet1.GetInt2(0))		'add the ID's to the ID list			
		Loop
	Else
		ToastMessageShow("No items found", False)
	End If
	ResultSet1.Close														'close the cursor, we don't need it anymore
End Sub

Sub UpdateSelectedItem
	Private Query As String
	Private Cursor1 As Cursor
	
	Query = "SELECT Name"
	Query = Query & " FROM Suppliers" 
	Query = Query & " WHERE rowid = " & SelectedRowID

	Cursor1 = Starter.SQL1.ExecQuery(Query)
	Cursor1.Position = 0
	lblSelectedItem.Text = Cursor1.GetString2(0) 

	Cursor1.Close
End Sub

'Routine from the DBUtils demo program, equivalent to the Click event
Sub wbvTable_OverrideUrl (Url As String) As Boolean
	'parse the row and column numbers from the URL
	Private values() As String
	Private Row As Int

	values = Regex.Split("[.]", Url.SubString(7))
	
	Row = values(1)
	SelectedRowID = RowIDList.Get(Row)
		
	UpdateSelectedItem

	Return True 'Don't try to navigate to this URL
End Sub