﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=StaticCode
Version=7.31
@EndOfDesignText@
'Static code module
Sub Process_Globals
'	Private fx As JFX
End Sub

'Draws a rectangle with gradient colors
'cvs - B4XCanvas
'Rect - The region that will be filled.
'GradColors - An Array of two or more colors that define the gradient.
'Orientation - One of the following: TL_BR, TOP_BOTTOM, TR_BL, LEFT_RIGHT, RIGHT_LEFT, BL_TR, BOTTOM_TOP, BR_TL And RECTANGLE
Public Sub RectGradient(cvs As B4XCanvas, Rect As B4XRect, GradColors() As Int, Orientation As String)
	Private rct1 As B4XRect
	rct1.Initialize(0, 0, Rect.Width, Rect.Height)

	Private Gradient As BitmapCreator
	Gradient.Initialize(rct1.Width, rct1.Height)
	Gradient.FillGradient(GradColors, rct1, Orientation)

	Private GradientBrush As BCBrush = Gradient.CreateBrushFromBitmapCreator(Gradient)
	Private BC As BitmapCreator
	BC.Initialize(rct1.Width, rct1.Height)
	BC.DrawRect2(BC.TargetRect, GradientBrush, True, 1)
	cvs.DrawBitmap(BC.Bitmap, Rect)
End Sub

'Draws a rounded rectangle with gradient colors
'cvs - B4XCanvas
'Rect - The region that will be filled.
'Radius - corner radius
'GradColors - An Array of two or more colors that define the gradient.
'Orientation - One of the following: TL_BR, TOP_BOTTOM, TR_BL, LEFT_RIGHT, RIGHT_LEFT, BL_TR, BOTTOM_TOP, BR_TL And RECTANGLE
Public Sub RoundRectGradient(cvs As B4XCanvas, Rect As B4XRect, Radius As Float, GradColors() As Int, Orientation As String)
	'Inner rectangle for the bitmap
	Private rct1 As B4XRect
	rct1.Initialize(0, 0, Rect.Width, Rect.Height)
	
	'BitmapCreator object for the gradient
	Private Gradient As BitmapCreator
	Gradient.Initialize(rct1.Width, rct1.Height)
	Gradient.FillGradient(GradColors, rct1, Orientation)
	
	'Create the gradient as a brush
	Private GradientBrush As BCBrush = Gradient.CreateBrushFromBitmapCreator(Gradient)
	
	'Create the gradient rectangle as a bitmap
	Private BC As BitmapCreator
	BC.Initialize(rct1.Width, rct1.Height)
	BC.DrawRectRounded2(BC.TargetRect, GradientBrush, True, 0, Radius)

	'Draw the bitmap
	cvs.DrawBitmap(BC.Bitmap, Rect)
End Sub

'Draws a circle with radial gradient
'cvs - B4XCanvas
'CenterX and CenterY - center coordinates
'Radius - circle radius
'GradColors - An Array of two or more colors that define the gradient.
Public Sub CircleRadialGradient(cvs As B4XCanvas, CenterX As Float, CenterY As Float, Radius As Float, GradColors() As Int, Filled As Boolean, StrokeWidth As Int)
	Private rct1, rct2 As B4XRect

	rct1.Initialize(CenterX - Radius, CenterY - Radius, CenterX + Radius, CenterY + Radius)
	rct2.Initialize(0, 0, 2 * Radius, 2 * Radius)
	Private Gradient As BitmapCreator
	Gradient.Initialize(rct2.Width, rct2.Height)
	Gradient.FillRadialGradient(GradColors, rct2)

	Private GradientBrush As BCBrush = Gradient.CreateBrushFromBitmapCreator(Gradient)
	Private BC As BitmapCreator
	BC.Initialize(rct2.Width, rct2.Height)
	BC.DrawCircle2(Radius, Radius, Radius, GradientBrush, Filled, StrokeWidth)
	
	cvs.DrawBitmap(BC.Bitmap, rct1)
End Sub

'Draws a circle with radial gradient
'cvs - B4XCanvas
'CenterX and CenterY - center coordinates
'Radius - circle radius
'GradColors - An Array of two or more colors that define the gradient.
'Orientation - One of the following: TL_BR, TOP_BOTTOM, TR_BL, LEFT_RIGHT, RIGHT_LEFT, BL_TR, BOTTOM_TOP, BR_TL And RECTANGLE 
Public Sub CircleGradient(cvs As B4XCanvas, CenterX As Float, CenterY As Float, Radius As Float, GradColors() As Int, Orientation As String, Filled As Boolean, StrokeWidth As Int)
	Private rct1, rct2 As B4XRect

	rct1.Initialize(CenterX - Radius, CenterY - Radius, CenterX + Radius, CenterY + Radius)
	rct2.Initialize(0, 0, 2 * Radius, 2 * Radius)
	Private Gradient As BitmapCreator
	Gradient.Initialize(rct2.Width, rct2.Height)
	Gradient.FillGradient(GradColors, rct2, Orientation)

	Private GradientBrush As BCBrush = Gradient.CreateBrushFromBitmapCreator(Gradient)
	Private BC As BitmapCreator
	BC.Initialize(rct2.Width, rct2.Height)
	BC.DrawCircle2(Radius, Radius, Radius, GradientBrush, Filled, StrokeWidth)
	
	cvs.DrawBitmap(BC.Bitmap, rct1)
End Sub

'Draws an arc with radial gradient
'cvs - B4XCanvas
'CenterX and CenterY - center coordinates
'Radius - circle radius
'StartAngle - starting angle
'SwipeAngle - swipe angle
'GradColors - An Array of two or more colors that define the gradient.
Public Sub ArcRadialGradient(cvs As B4XCanvas, CenterX As Float, CenterY As Float, Radius As Float, StartAngle As Float, SwipeAngle As Float, GradColors() As Int)
	'Outer rectangle of the circle with destination (outer) coordinates
	Private rectCircle As B4XRect
	rectCircle.Initialize(CenterX - Radius, CenterY - Radius, CenterX + Radius, CenterY + Radius)

	'Outer rectangle of the circle with inner coordinates
	Private rb As B4XRect
	rb.Initialize(0, 0, 2 * Radius, 2 * Radius)
	
	'Path for the arc
	Private mPath As B4XPath
	mPath.InitializeArc(CenterX, CenterY, Radius, StartAngle, SwipeAngle)
	
	'Set the clipping
	cvs.ClipPath(mPath)
	
	'BitmapCreator object for the final bitmap
	Private BC As BitmapCreator
	BC.Initialize(2 * Radius, 2 * Radius)
	BC.FillRadialGradient(GradColors, rb)
	cvs.DrawBitmap(BC.Bitmap, rectCircle)
	
	cvs.RemoveClip
End Sub

'Adds an arc to the given BCPath
Public Sub ArcTo(Path As BCPath, CenterX As Int, CenterY As Int, Radius As Int, StartAngle As Int, SweepAngle As Int)
	Private Angle As Int
	Private x, y As Float
	
	For Angle = StartAngle + 1 To StartAngle + SweepAngle
		x = CenterX + Radius * CosD(Angle)
		y = CenterY + Radius * SinD(Angle)
		Path.LineTo(x, y)
	Next
End Sub

'Adds a parabola which goes through three points to the given path
'The three points are the last point in the path and the two given points 
Public Sub ParabolaTo (Path As BCPath, Point1X As Float, Point1Y As Float, Point2X As Float, Point2Y As Float)
	Dim LastPoint As InternalBCPathPointData = Path.Points.Get(Path.Points.Size - 1)
	Dim CurrentX As Float = LastPoint.X
	Dim Currenty As Float = LastPoint.Y
	Dim NumberOfSteps As Int = 15 '<--- change as needed
	Dim dt As Float = 1 / NumberOfSteps
	Dim t As Float = dt
	For i = 1 To NumberOfSteps
		Dim tt1 As Float =  (1 - t) * (1 - t)
		Dim tt2 As Float = 2 * (1 - t) * t
		Dim tt3 As Float = t * t
		Dim x As Float = tt1 * CurrentX + tt2 * Point1X + tt3 * Point2X
		Dim y As Float = tt1 * Currenty + tt2 * Point1Y + tt3 * Point2Y
		Path.LineTo(x, y)
		t = t + dt
	Next
End Sub

