﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.85
@EndOfDesignText@
#Region Shared Files
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Shared Files" "..\Files"
'Ctrl + click to sync files: ide://run?file=%WINDIR%\System32\Robocopy.exe&args=..\..\Shared+Files&args=..\Files&FilesSync=True
#End Region

'Ctrl + click to export as zip: ide://run?File=%B4X%\Zipper.jar&Args=\%PROJECT_NAME%.zip

'B4A ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4A\%PROJECT_NAME%.b4a 
'B4i ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4i\%PROJECT_NAME%.b4i 
'B4J ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4J\%PROJECT_NAME%.b4j

Sub Class_Globals
	Private Root As B4XView
	Private xui As XUI
	
	Private pnlBackground, pnlLayer0, pnlLayer1, pnlLayer2, pnlLayer(3) As B4XView
	Private cvsBackground, cvsLayer(3) As B4XCanvas
	Private xbmpBackground As B4XBitmap
	Private xRect, xRect0 As B4XRect
	Private xFont As B4XFont
	
	Private x100, y100, xc, yc, xc0, yc0, x1, y1, x2, y2, w1, w1_2, w2, w2_2, w2_21, Radius As Double
End Sub

Public Sub Initialize
'	B4XPages.GetManager.LogEvents = True
End Sub

Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("Main")
	pnlLayer = Array As B4XView(pnlLayer0, pnlLayer1, pnlLayer2)
	
	'initialize the canvases
	cvsBackground.Initialize(pnlBackground) ' 
	For i = 0 To 2
		cvsLayer(i).Initialize(pnlLayer(i))
	Next
	
	'transfer the events to the underlying object
	'in B4J and B4i events are not transmitted automatically to the underlying object 
	'when there is no event active routine for the object
#If B4J
	Private jo = pnlLayer(2) As JavaObject
	jo.RunMethod("setMouseTransparent", Array As Object(True))
	Private jo = pnlLayer(1) As JavaObject
	jo.RunMethod("setMouseTransparent", Array As Object(True))
#Else If B4i
  pnlLayer(2).As(Panel).UserInteractionEnabled = False
  pnlLayer(1).As(Panel).UserInteractionEnabled = False
#End If

	'initialize the background bitmap
	xbmpBackground = xui.LoadBitmap(File.DirAssets, "rose.jpg")

	Drawing
End Sub

'Return true to allow the default exceptions handler to handle the uncaught exception.
Sub Application_Error (Error As Exception, StackTrace As String) As Boolean
	Return True
End Sub

Private Sub Drawing
	'create the default font
	xFont = xui.CreateDefaultFont(16)	
	
	'intialize the screen rectangle
	xRect0.Initialize(0, 0,pnlBackground.Width, pnlBackground.Height)
	
	'draw the background image
	cvsBackground.DrawBitmap(xbmpBackground, xRect0)
	cvsBackground.Invalidate
	
	'variables for 100%x and 100%y
	x100 = pnlLayer(0).Width
	y100 = pnlLayer(0).Height
	
	DrawLayer0
	DrawLayer1
	DrawLayer2
End Sub

Private Sub DrawLayer0
	'draw background color
	cvsLayer(0).DrawRect(xRect0, xui.Color_DarkGray, True, 1)
	
	'set a transparent circle or square
	xc0 = 0.25 * x100
	yc0 = 0.2 * y100
	w2 = 0.3 * x100
	w2_2 = w2 / 2
	w2_21 = w2_2 + 1
#If B4J
	'in B4J we use a square instead of a circle
	xRect.Initialize(xc0 - w2_2, yc0 - w2_2, xc0 + w2_2, yc0 + w2_2)
	cvsLayer(0).ClearRect(xRect)	'sets the rectangle to transparent
#Else
	cvsLayer(0).DrawCircle(xc0, yc0, w2_2, xui.Color_Transparent, True, 1dip)
#End If
	
	cvsLayer(0).Invalidate
End Sub

Private Sub DrawLayer1
	'set background color to transparent
	cvsLayer(1).ClearRect(xRect0)

	'draw the two squares
	xc = 0.25 * x100
	yc = 0.2 * y100
	w1 = 0.35 * x100
	w1_2 = w1 / 2
	xRect.Initialize(xc - w1_2, yc - w1_2, xc + w1_2, yc + w1_2)
	cvsLayer(1).DrawRect(xRect, xui.Color_Green, False, 2)
	w1 = 0.3 * x100
	w1_2 = w1 / 2
	xRect.Initialize(xc - w1_2, yc - w1_2, xc + w1_2, yc + w1_2)
	cvsLayer(1).DrawRect(xRect, xui.Color_Blue, False, 5)
	
	'draw a rounded rectangle
	xRect.Initialize(0.05 * x100, 0.55 * y100, 0.52 * x100, 0.75 * y100)
	Private xPath As B4XPath
	xPath.InitializeRoundedRect(xRect, 30dip)
	cvsLayer(1).DrawPath(xPath, xui.Color_Red, False, 3dip)

	'draw an oval with a border
	xRect.Initialize(0.05 * x100 + 10dip, 0.55 * y100 + 10dip, 0.52 * x100 - 10dip, 0.75 * y100 - 10dip)
	Private xPath As B4XPath
	xPath.InitializeOval(xRect)
	cvsLayer(1).DrawPath(xPath, xui.Color_Magenta, True, 1dip)
	cvsLayer(1).DrawPath(xPath, xui.Color_Yellow, False, 3dip)
	
	'draw the background image smaller and rotated
	xRect.Initialize(0.6 * x100, 0.1 * y100, 0.85 * x100, 0.1 * y100 + 0.336 * x100)
	cvsLayer(1).DrawBitmapRotated(xbmpBackground, xRect, 30)
	
	cvsLayer(1).Invalidate
End Sub

Private Sub DrawLayer2
	'draw background color
	cvsLayer(2).DrawRect(xRect0, xui.Color_ARGB(255, 240, 240, 240), True, 1dip)
	
	'draw the four lines on layer(2)
	x1 = 0.05 * x100
	y1 = 0.04 * y100
	x2 = 0.4 * x100
	y2 = 0.09 * y100
	cvsLayer(2).DrawLine(x1, y1, x2, y2, xui.Color_Red, 1dip)
	y1 = 0.06 * y100
	y2 = 0.11 * y100
	cvsLayer(2).DrawLine(x1, y1, x2, y2, xui.Color_Green, 3dip)
	y1 = 0.08 * y100
	y2 = 0.15 * y100
	cvsLayer(2).DrawLine(x1, y1, x2, y2, xui.Color_Yellow, 5dip)
	y1 = 0.1 * y100
	y2 = 0.17 * y100
	cvsLayer(2).DrawLine(x1, y1, x2, y2, xui.Color_RGB(0, 128, 255), 8dip)
	
	'draw the three horizontal texts
	x1 = 0.6 * x100
	y1 = 0.08 * y100
	cvsLayer(2).DrawText("Rose", x1, y1, xFont, xui.Color_Blue, "LEFT")
	DrawCross(x1, y1, xui.Color_Red)
	y1 = 0.13 * y100
	cvsLayer(2).DrawText("Rose", x1, y1, xFont, xui.Color_Blue, "CENTER")
	DrawCross(x1, y1, xui.Color_Red)
	y1 = 0.18 * y100
	cvsLayer(2).DrawText("Rose", x1, y1, xFont, xui.Color_Blue, "RIGHT")
	DrawCross(x1, y1, xui.Color_Red)

	'draw the three rotated texts
	x1 = 0.8 * x100
	y1 = 0.08 * y100
	cvsLayer(2).DrawTextRotated("Rose", x1, y1, xFont, xui.Color_Blue, "LEFT", -30)
	DrawCross(x1, y1, xui.Color_Red)
	y1 = 0.13 * y100
	cvsLayer(2).DrawTextRotated("Rose", x1, y1, xFont, xui.Color_Blue, "CENTER", -30)
	DrawCross(x1, y1, xui.Color_Red)
	y1 = 0.18 * y100
	cvsLayer(2).DrawTextRotated("Rose", x1, y1, xFont, xui.Color_Blue, "RIGHT", -30)
	DrawCross(x1, y1, xui.Color_Red)
	
	'draw an empty circle
	xc = 0.3 * x100
	yc = 0.32 * y100
	Radius = 50dip
	cvsLayer(2).DrawCircle(xc, yc, Radius, xui.Color_Red, False, 5dip)
	
	'draw a clipped arc
	Private mPath As B4XPath
	xc = 0.08 * x100
	yc = 0.5 * y100
	Radius = 0.2 * x100
	mPath.InitializeArc(xc, yc, Radius, -30, 60)
	cvsLayer(2).ClipPath(mPath)
	cvsLayer(2).DrawRect(cvsLayer(2).TargetRect, xui.Color_Magenta, True, 1dip)
	cvsLayer(2).RemoveClip
	
	'draw a clipped triangle
	mPath.Initialize(0.5 * x100, 0.45 * y100)
	mPath.LineTo(0.7 * x100, 0.45 * y100)
	mPath.LineTo(0.6 * x100, 0.6 * y100)
	cvsLayer(2).ClipPath(mPath)
	cvsLayer(2).DrawRect(cvsLayer(2).TargetRect, xui.Color_Blue, True, 1dip)
	cvsLayer(2).RemoveClip
	
	'draw an arc Path
	Private mPath As B4XPath
	xc = 0.08 * x100
	yc = 0.75 * y100
	Radius = 0.2 * x100
	mPath.InitializeArc(xc, yc, Radius, -30, 60)
	cvsLayer(2).DrawPath(mPath, xui.Color_Green, True, 1dip)
'	cvsLayer(2).RemoveClip
	
	'draw a triangle path
	Private mPath As B4XPath
	mPath.Initialize(0.3 * x100, 0.69 * y100)
	mPath.LineTo(0.45 * x100, 0.69 * y100)
	mPath.LineTo(0.375 * x100, 0.82 * y100)
	cvsLayer(2).DrawPath(mPath, xui.Color_Green, True, 1dip)
'	cvsLayer(2).RemoveClip
	
	'draw a rotated triangle path with the center
	Private mPath As B4XPath
	mPath.Initialize(0.5 * x100, 0.69 * y100)
	mPath.LineTo(0.67 * x100, 0.69 * y100)
	mPath.LineTo(0.58 * x100, 0.82 * y100)
	cvsLayer(2).DrawPathRotated(mPath, xui.Color_Green, True, 1dip, 15, 0.5 * x100, 0.7 * y100)
'	cvsLayer(2).RemoveClip
	DrawCross(0.5 * x100, 0.69 * y100, xui.Color_Red)

	'draw a rotated triangle path with the center
	Private mPath As B4XPath
	mPath.Initialize(0.67 * x100, 0.69 * y100)
	mPath.LineTo(0.83 * x100, 0.69 * y100)
	mPath.LineTo(0.75 * x100, 0.82 * y100)
	cvsLayer(2).DrawPathRotated(mPath, xui.Color_Green, True, 1dip, 15, 0.75 * x100, 0.82 * y100)
'	cvsLayer(2).RemoveClip
	DrawCross(0.75 * x100, 0.82 * y100, xui.Color_Red)
	
	cvsLayer(2).Invalidate
	
	'saves the bitmap of layer(2)
	Dim Out As OutputStream
	xui.SetDataFolder("SimpleDrawMethods")
	Out = File.OpenOutput(xui.DefaultFolder, "Test.png", False)
	cvsLayer(2).CreateBitmap.WriteToStream(Out, 100, "PNG")
	Out.Close
End Sub

'Draws a cross at the given coordinates with the given color
'x any y = coordinates in pixels
'Color = color of the two lines
'Code example: <code>
'DrawCross(20, 50, fx.Colors.Red)</code>
Private Sub DrawCross(x As Int, y As Int, Color As Int)
	Private d = 5dip As Int
	
	cvsLayer(2).DrawLine(x - d, y, x + d, y, Color, 1)
	cvsLayer(2).DrawLine(x, y - d, x, y + d, Color, 1)
End Sub

' B4XSwitch VakueChanged event routine, all three B4XSwitches call this routine
Private Sub stwLayer_ValueChanged (Value As Boolean)
	Dim stw As B4XSwitch
	Dim index As Int
	
	stw = Sender
	index = stw.Tag
	pnlLayer(index).Visible = Value
End Sub

Private Sub pnlLayer0_Touch (Action As Int, X As Float, Y As Float)
	Select Action
		Case pnlLayer0.TOUCH_ACTION_MOVE
			'redraws the background of the transparent part
			xRect.Initialize(xc0 - w2_21, yc0 - w2_21, xc0 + w2_21, yc0 + w2_21)
			cvsLayer(0).DrawRect(xRect, xui.Color_DarkGray, True, 1)
	
			xc0 = X
			yc0 = Y
			xRect.Initialize(xc0 - w2_2 , yc0 - w2_2, xc0 + w2_2, yc0 + w2_2)
			'draws the new transparent part
#If B4J
			cvsLayer(0).ClearRect(xRect)
#Else
			cvsLayer(0).DrawCircle(xc0, yc0, w2_2, xui.Color_Transparent, True, 1dip)
#End If
	cvsLayer(0).Invalidate
	End Select
End Sub
