﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.71
@EndOfDesignText@
Sub Class_Globals
	Private Root As B4XView 'ignore
	Private xui As XUI 'ignore
	
	Private clvSetFilter As CustomListView
	Private cbxColumn0, cbxColumn() As B4XComboBox		' ComboBoxes for the Filter pane, added by code in InitSpinners

	Private lblColumn, btnBooleanOperator As B4XView
	
	Public flagFilterActive = False As Boolean
	' Boolean operator used in the filter
	' can be 'OR ' or 'AND ' with a space at the end
	Private BooleanOperator = "OR " As String

	' Variables used to hold the selected indexes of the Spinners
	Public SelectedItemIndex() As Int
	Public Query As String
End Sub

'You can add more parameters here.
Public Sub Initialize As Object
	Return Me
End Sub

'This event will be called once, before the page becomes visible.
Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("SetFilter")
	'load the layout to Root
	
	InitFilterPane
End Sub

Private Sub btnFilter_Click
	Query = GetFilterQuery

	'set the filter to active
	flagFilterActive = True
	
	'memorize the selected indexes of the Comboboxes
	Private col As Int
	For col = 0 To B4XPages.MainPage.ColNumber - 1
		SelectedItemIndex(col) = cbxColumn(col).SelectedIndex
	Next
	
	'close the current page
	B4XPages.ClosePage(B4XPages.MainPage.Filter)
	
	'go back to MainPage and call Show
	B4XPages.MainPage.Show
End Sub

Private Sub btnBooleanOperator_Action
	If BooleanOperator = "AND " Then
		BooleanOperator = "OR "
	Else
		BooleanOperator = "AND "
	End If
	btnBooleanOperator.Text = BooleanOperator
End Sub

Private Sub GetFilterQuery As String
	'a query will look like something
	' WHERE FirstName = 'John'
	' WHERE FirstName = 'John' AND LastName = 'KENNEDY'
	' WHERE FirstName = 'John' AND City = 'London'
	' WHERE FirstName = 'John' AND LastName = 'KENNEDY' AND City = 'London'
	'the single quotes are needed because the values are strings
	
	Private Query1 = " WHERE " As String	'beginning of the query1
	
	Private col As Int
	For col = 0 To B4XPages.MainPage.ColNumber - 1
		If cbxColumn(col).SelectedIndex > 0 Then
			If col = 0 Then
				Query1 = Query1 & B4XPages.MainPage.ColNames(col) & " = '" & cbxColumn(col).GetItem(cbxColumn(col).SelectedIndex) & "' "
			Else
				If Query1 = " WHERE " Then
					Query1 = Query1 & B4XPages.MainPage.ColNames(col) & " = '" & cbxColumn(col).GetItem(cbxColumn(col).SelectedIndex) & "' "
				Else
					Query1 = Query1 & BooleanOperator & B4XPages.MainPage.ColNames(col) & " = '" & cbxColumn(col).GetItem(cbxColumn(col).SelectedIndex) & "' "
				End If
			End If
		End If
	Next

	'if nothing was selected set Query = ""
	If Query1 = " WHERE " Then
		Query1 = ""
	End If
	
	Return Query1
End Sub

Private Sub UpdateFilter(col As Int)
	Private Query1 As String
	Private lstItems As List
	
	lstItems.Initialize
	Query1 = "SELECT DISTINCT " & B4XPages.MainPage.ColNames(col) & " FROM " & B4XPages.MainPage.SQLTabelName & " ORDER BY " & B4XPages.MainPage.ColNames(col) & " ASC"
	
'	cbxSetFilter(col).Items.Clear
'	cbxSetFilter(col).Items.Add("no filter")
	lstItems.Add("no filter")
	Private ResultSet1 As ResultSet
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery(Query1)
	
	Do While ResultSet1.NextRow
		lstItems.Add(ResultSet1.GetString(B4XPages.MainPage.ColNames(col)))
	Loop
	cbxColumn(col).SetItems(lstItems)
	
	ResultSet1.Close
End Sub

'Initialize the Spinners (ComboBoxes)
Private Sub InitFilterPane
	' Adds the Label and ComboBox nodes onto the ScrollPane pane by code
	Private i As Int
	Private cbxColumn(B4XPages.MainPage.ColNumber) As B4XComboBox
	Private SelectedItemIndex(B4XPages.MainPage.ColNumber) As Int
	
	For i = 0 To B4XPages.MainPage.ColNumber - 1
		clvSetFilter.Add(CreateEditItem(i, 50dip, clvSetFilter.GetBase.Width), "")
		UpdateFilter(i)
	Next
	
'	For i = 0 To B4XPages.MainPage.ColNumber - 1
'		UpdateFilter(i)
'	Next
End Sub

Private Sub CreateEditItem(i As Int, Height As Int, Width As Int) As B4XView
	Private pnl As B4XView = xui.CreatePanel("")
	pnl.SetLayoutAnimated(0, 0, 0, Width, Height)
	pnl.LoadLayout("FilterItem")
	
	lblColumn.Text = B4XPages.MainPage.ColNames(i)
	cbxColumn(i) = cbxColumn0.mBase.Tag
	Return pnl
End Sub
