﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=StaticCode
Version=6.47
@EndOfDesignText@
'Static code module
Sub Process_Globals
	Private xui As XUI
	Private fx As JFX
	
	Public SelectedRowID As Long
	Public RowIDList As List
	
	Private frmSuppliers As Form
	Private tblData As B4XTable
	Private lblSelectedItem As B4XView
End Sub

Private Sub frmEdit_Closed
	B4XPages.MainPage.Show
End Sub

Public Sub Show
	If frmSuppliers.IsInitialized = False Then
		frmSuppliers.Initialize("frmSuppliers", 600, 600)
		frmSuppliers.RootPane.LoadLayout("ShowTable")
		frmSuppliers.Title = "SLQiteLight4   Suppliers"
	End If

	ShowTableSuppliers
	
	frmSuppliers.Show
End Sub

Private Sub frmSuppliers_Closed
	B4XPages.MainPage.ShowTableStock
End Sub

Sub btnAdd_Click
	B4XPages.MainPage.SupplierEditMode = "Add"
	EditSupplier.Show
End Sub

Sub btnEdit_Click
	B4XPages.MainPage.SupplierEditMode = "Edit"
	EditSupplier.Show
End Sub

Sub btnDelete_Click
	Private sf As Object = xui.Msgbox2Async("Do you really want to delete the selected entry ?", "D E L E T E", "Yes", "", "No", Null)
	Wait For (sf) Msgbox_Result (Result As Int)

	If Result = xui.DialogResponse_Positive Then
		B4XPages.MainPage.SQL1.ExecNonQuery("DELETE FROM Stock WHERE rowid = " & SelectedRowID)
		ShowTableSuppliers
	End If
End Sub

Sub ShowTableSuppliers
	Private Query As String
	
	Query = "SELECT Name, Address, City "
	Query = Query & "FROM Suppliers "
	
'	wbvTable.LoadHtml(Utils.ExecuteHtml(Main.SQL1, Query, Null, 0, True)) '***
	ReadDataBaseIDs
End Sub

'Reads the database rowids in IDList
Sub ReadDataBaseIDs
	Private ResultSet1 As ResultSet
	
	RowIDList.Initialize		'initialize the ID list

	'We read only the ID column and put them in a List
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery("SELECT rowid FROM Suppliers")
	
	Do While ResultSet1.NextRow
		RowIDList.Add(ResultSet1.GetInt2(0))		'add the ID's to the ID list
	Loop
	
	ResultSet1.Close		'close the ResultSet, we don't need it anymore
End Sub

Sub UpdateSelectedItem
	Private Query As String
	Private ResultSet1 As ResultSet
	
	Query = "SELECT Name"
	Query = Query & " FROM Suppliers"
	Query = Query & " WHERE rowid = " & SelectedRowID

	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery(Query)
	ResultSet1.NextRow
	lblSelectedItem.Text = ResultSet1.GetString2(0)

	ResultSet1.Close
End Sub

'Routine from the DBUtils demo program, equivalent to the Click event
Sub wbvTable_LocationChanged (Location As String)
	'parse the row and column numbers from the URL
	
	If Location.Contains("stub") Then
		Private values() As String
		Private Row As Int

		values = Regex.Split("[.]", Location.SubString(7))
	
		Row = values(1)
		SelectedRowID = RowIDList.Get(Row)
		
		UpdateSelectedItem
	End If
End Sub