﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.8
@EndOfDesignText@
Sub Class_Globals
	Private Root As B4XView 'ignore
	Private xui As XUI 'ignore
	
	Public SelectedRowID As Long
	Public SelectedSupplierName As String
	Public RowIDList As List
	
	Private tblData As B4XTable
	Private lblSelectedItem As B4XView
	Private btnEdit, btnDelete As B4XView
End Sub

'You can add more parameters here.
Public Sub Initialize As Object
	Return Me
End Sub

'This event will be called once, before the page becomes visible.
Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("ShowTable")
	
	B4XPages.SetTitle(Me, "SLQiteLight4   Suppliers")
	
	SelectedRowID = 1
	UpdateSelectedItem
	
	InitTable
	ShowTableSuppliers
End Sub

Public Sub Show
	ShowTableSuppliers
End Sub

Private Sub frmSuppliers_Closed
	B4XPages.MainPage.ShowTableStock
End Sub

Sub btnAdd_Click
	B4XPages.MainPage.SupplierEditMode = "Add"
	B4XPages.ShowPage("EditSupplier")
End Sub

Sub btnEdit_Click
	B4XPages.MainPage.SupplierEditMode = "Edit"
	B4XPages.ShowPage("EditSupplier")
End Sub

Sub btnDelete_Click
	Private sf As Object = xui.Msgbox2Async("Do you really want to delete the supplier " & SelectedSupplierName & CRLF & "And all products in stock ?", "D E L E T E", "Yes", "", "No", Null)
	Wait For (sf) Msgbox_Result (Result As Int)

	If Result = xui.DialogResponse_Positive Then
		Private rs As ResultSet
		rs = B4XPages.MainPage.SQL1.ExecQuery2("SELECT rowid FROM Products WHERE Products.SupplierID = ?", Array As String(SelectedRowID))
		Do While rs.NextRow
			B4XPages.MainPage.SQL1.ExecNonQuery("DELETE FROM Stock WHERE ProductID = " & rs.GetLong2(0))
		Loop
		B4XPages.MainPage.SQL1.ExecNonQuery("DELETE FROM Products WHERE SupplierID = " & SelectedRowID)
		B4XPages.MainPage.SQL1.ExecNonQuery("DELETE FROM Suppliers WHERE rowid = " & SelectedRowID)
		B4XPages.MainPage.Show
		B4XPages.MainPage.Products.Show
		ShowTableSuppliers
	End If
End Sub

Sub ShowTableSuppliers
	Private Query As String
	
	Query = "SELECT Name, Address, City "
	Query = Query & "FROM Suppliers "
	
	Dim Data As List
	Data.Initialize
	Dim rs As ResultSet = B4XPages.MainPage.SQL1.ExecQuery(Query)
	Do While rs.NextRow
		Dim row(3) As Object
		For i = 0 To 2
			row(i) = rs.GetString2(i)
		Next
		Data.Add(row)
	Loop
	rs.Close
	tblData.SetData(Data)
	
	ReadDataBaseIDs
End Sub

Private Sub InitTable
	tblData.AddColumn("Name", tblData.COLUMN_TYPE_TEXT)
	tblData.AddColumn("Address", tblData.COLUMN_TYPE_TEXT)
	tblData.AddColumn("City", tblData.COLUMN_TYPE_TEXT)
End Sub

'Reads the database rowids in IDList
Sub ReadDataBaseIDs
	Private ResultSet1 As ResultSet
	
	RowIDList.Initialize		'initialize the ID list

	'We read only the ID column and put them in a List
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery("SELECT rowid FROM Suppliers")
	
	Do While ResultSet1.NextRow
		RowIDList.Add(ResultSet1.GetInt2(0))		'add the ID's to the ID list
	Loop
	
	ResultSet1.Close		'close the ResultSet, we don't need it anymore
End Sub

Sub UpdateSelectedItem
	Private Query As String
	Private ResultSet1 As ResultSet
	
	Query = "SELECT Name"
	Query = Query & " FROM Suppliers"
	Query = Query & " WHERE rowid = " & SelectedRowID

	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery(Query)
	ResultSet1.NextRow
	lblSelectedItem.Text = ResultSet1.GetString2(0)

	ResultSet1.Close
End Sub

Private Sub tblData_CellClicked (ColumnId As String, RowId As Long)
	SelectedRowID = RowIDList.Get(RowId - 1)
	SelectedSupplierName = B4XPages.MainPage.SQL1.ExecQuerySingleResult2("SELECT Name FROM Suppliers WHERE rowid = ?", Array As String (SelectedRowID))
	UpdateSelectedItem
	btnDelete.Visible = True
	btnEdit.Visible = True
End Sub
