﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.85
@EndOfDesignText@
#Region Shared Files
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Shared Files" "..\Files"
'Ctrl + click to sync files: ide://run?file=%WINDIR%\System32\Robocopy.exe&args=..\..\Shared+Files&args=..\Files&FilesSync=True
#End Region

'Ctrl + click to export as zip: ide://run?File=%B4X%\Zipper.jar&Args=\%PROJECT_NAME%.zip

'B4A ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4A\%PROJECT_NAME%.b4a 
'B4i ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4i\%PROJECT_NAME%.b4i 
'B4J ide://run?file=%WINDIR%\System32\cmd.exe&Args=/c&Args=start&Args=..\..\B4J\%PROJECT_NAME%.b4j

Sub Class_Globals
	Private Root As B4XView
	Private xui As XUI
	
	Private DU As DDD 'declares the DesignerUtils Class
End Sub

Public Sub Initialize
'	B4XPages.GetManager.LogEvents = True
End Sub

Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	
	'the lines below must be before LoadLayout
	xui.RegisterDesignerClass(Me)	'register the calling module
	DU.Initialize									'initialize DesignerUtils
	xui.RegisterDesignerClass(DU)	'register DesignerUtils
	
	Root.LoadLayout("MainPage")
	'gets the views in the ToolBar Class
	For Each p As B4XView In DU.GetViewsByClass("ToolBar")
		'loads the layout in each view, only one in our case
		p.LoadLayout("ToolBar")
	Next
End Sub

'scales the ToolBar layout
'this routine is called in the Desiger ToolBar layout
Private Sub ScaleToolBar(DesignerArgs As DesignerArgs)
	Private i, Origin, Space, Width As Int
	Private Parent As B4XView
	
	Parent = DesignerArgs.Parent
	Private pnl As B4XView
	pnl = DesignerArgs.GetViewByName("pnlToolBar")
	pnl.Width = Parent.Width
	Space = Parent.Width / 80 '1.25 % of the total width
	Width = (Parent.Width - (pnl.NumberOfViews + 1) * Space) / pnl.NumberOfViews
	Origin = (Parent.Width - Width * pnl.NumberOfViews - (pnl.NumberOfViews + 1) * Space) / 2 + Space
	For i = 0 To pnl.NumberOfViews - 1
		Private v As B4XView
		v = pnl.GetView(i)
		v.Left = Origin + i * (Width + Space)
		v.Width = Width
	Next
	DU.RemoveLayoutData(Parent) 'removes the layout data
End Sub