﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=7.8
@EndOfDesignText@
'Custom View class 

Sub Class_Globals
#If B4J
	Private fx As JFX
#End If
	Private mEventName As String 'ignore
	Private mCallBack As Object 'ignore

	Private pnlGraph As B4XView
	Private xui As XUI
	Private cvsGraph As B4XCanvas
	Private xFont As B4XFont
End Sub

Public Sub Initialize (Callback As Object, EventName As String)
	mEventName = EventName
	mCallBack = Callback
	
	'define a default font with a size of 20
	xFont = xui.CreateDefaultFont(20)
End Sub

Public Sub DesignerCreateView (Base As Object, Lbl As Label, Props As Map)
	pnlGraph = Base

	cvsGraph.Initialize(pnlGraph)
End Sub

Public Sub GetBase As Object
	Return pnlGraph
End Sub

Public Sub Drawing
	' draw a horizontal line onto xplGraph
	cvsGraph.DrawLine(20dip, 20dip, 160dip, 20dip, xui.Color_Red, 3dip)

	' draw a empty rectangle onto xplGraph
	Private rect1 As B4XRect
	rect1.Initialize(20dip, 40dip, 150dip, 100dip)
	cvsGraph.DrawRect(rect1, xui.Color_Blue, False, 3dip)

	' draw a filled rectangle onto xplGraph
	rect1.Initialize(20dip, 120dip, 150dip, 180dip)
	cvsGraph.DrawRect(rect1, xui.Color_Blue, True, 1dip)

	' draw a filled circle with a border onto xplGraph
	Private centerX, centerY, radius As Float
	centerX = 220dip
	centerY = 70dip
	radius = 30dip
	cvsGraph.DrawCircle(centerX, centerY, radius, xui.Color_Green, True, 3dip)
	cvsGraph.DrawCircle(centerX, centerY, radius, xui.Color_Red, False, 3dip)
	
	Private refX, refY, hl As Float
	refX = 80dip
	refY = 230dip
	hl = 5dip
	
	' draw texts with three alignments onto xplGraph
	cvsGraph.DrawText("Test text", refX, refY, xFont, xui.Color_Black, "LEFT")
	DrawCross(refX, refY, hl)
	
	refY = 260dip
	cvsGraph.DrawText("Test text", refX, refY, xFont, xui.Color_Black, "CENTER")
	DrawCross(refX, refY, hl)

	refY = 290dip
	cvsGraph.DrawText("Test text", refX, refY, xFont, xui.Color_Black, "RIGHT")
	DrawCross(refX, refY, hl)
	
	' draw rotated texts with three alignments onto pnlGraph
	refX = 230dip
	refY = 210dip
	cvsGraph.DrawTextRotated("Test text", refX, refY, xFont, xui.Color_Black, "LEFT", 45)
	DrawCross(refX, refY, hl)

	refY = 250dip
	cvsGraph.DrawTextRotated("Test text", refX, refY, xFont, xui.Color_Black, "CENTER", 45)
	DrawCross(refX, refY, hl)

	refY = 290dip
	cvsGraph.DrawTextRotated("Test text", refX, refY, xFont, xui.Color_Black, "RIGHT", 45)
	DrawCross(refX, refY, hl)
	
	cvsGraph.Invalidate
End Sub

'Draw a cross on the reference point
Private Sub DrawCross(x As Int, y As Int, l As Int)
	cvsGraph.DrawLine(x - l, y, x + l, y, xui.Color_Red, 1dip)
	cvsGraph.DrawLine(x, y - l, x, y +l, xui.Color_Red, 1dip)
End Sub
