﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=StaticCode
Version=6.47
@EndOfDesignText@
'Static code module
Sub Process_Globals
	Private fx As JFX
	Private frmEditStock As Form
	Private edtNumber, edtDate As B4XView
	Private btnAdd, btnUpdate As B4XView
	Private cbxProduct As B4XComboBox
End Sub

Public Sub Show
	If frmEditStock.IsInitialized = False Then
		frmEditStock.Initialize("frmEditStock", 600, 600)
		frmEditStock.RootPane.LoadLayout("EditStock")
		frmEditStock.Title = "SLQiteLight4   Edit Stock"
	End If

	InitPage 
	
	Select B4XPages.MainPage.StockEditMode
		Case "Add"
			InitNewItem
			btnUpdate.Visible = False
		Case "Edit"
			InitEditItem
	End Select
	frmEditStock.Show
End Sub

Private Sub frmEditStock_Closed
	B4XPages.MainPage.Show
End Sub

Sub btnAdd_Click
	Private Query As String
	
	Query = "INSERT INTO Stock VALUES (" & edtNumber.Text & ", " & Products.RowIDList.Get(cbxProduct.SelectedIndex) & ", " & DateTime.Now & ")"
	B4XPages.MainPage.SQL1.ExecNonQuery(Query)
	btnUpdate.Visible = True
End Sub

Sub btnUpdate_Click
	Private Query As String
	
	Log(cbxProduct.SelectedIndex)
	Log(Products.RowIDList.Get(cbxProduct.SelectedIndex))
	Query = "UPDATE Stock SET Number = " & edtNumber.Text & ", ProductID = " & Products.RowIDList.Get(cbxProduct.SelectedIndex) & ", Date = " & DateTime.DateParse(edtDate.Text)
	Query = Query & " WHERE rowid = " & B4XPages.MainPage.StockSelectedRowID
	
	B4XPages.MainPage.SQL1.ExecNonQuery(Query)
End Sub

Sub InitPage
	Private ResultSet1 As ResultSet
	Private Query As String
	Private lstStock As List
	
	Products.RowIDList.Initialize
	
	Query = "SELECT Products.Name, Suppliers.Name, Products.rowid From Products, Suppliers"
	Query = Query & " WHERE Suppliers.rowid = Products.SupplierID"
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery(Query)
	
	If lstStock.IsInitialized = False Then
		lstStock.Initialize
	End If
	lstStock.Clear
	Do While ResultSet1.NextRow
		lstStock.Add(ResultSet1.GetString2(0) & " / " & ResultSet1.GetString2(1))
		Products.RowIDList.Add(ResultSet1.GetLong2(2))
	Loop
	cbxProduct.SetItems(lstStock)
	ResultSet1.Close
End Sub

Sub InitNewItem
	edtNumber.Text = 1
	cbxProduct.SelectedIndex = 0
	edtDate.Text = DateTime.Date(DateTime.Now)
End Sub

Sub InitEditItem
	Private ResultSet1 As ResultSet
	Private Query As String
	
	Query = "SELECT Stock.Number, Products.Name, Stock.Date, Products.rowid From Stock, Products WHERE Products.rowid = Stock.ProductID AND Stock.rowid = " & B4XPages.MainPage.StockSelectedRowID
	ResultSet1 = B4XPages.MainPage.SQL1.ExecQuery(Query)
	ResultSet1.NextRow
	edtNumber.Text = ResultSet1.GetInt2(0)
	cbxProduct.SelectedIndex = Products.RowIDList.IndexOf(ResultSet1.GetLong2(3))
	edtDate.Text = DateTime.Date(ResultSet1.GetLong2(2))
	ResultSet1.Close
End Sub

