﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.85
@EndOfDesignText@
#Region Shared Files
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Shared Files" "..\Files"
'Ctrl + click to sync files: ide://run?file=%WINDIR%\System32\Robocopy.exe&args=..\..\Shared+Files&args=..\Files&FilesSync=True
#End Region

'Ctrl + click to export as zip: ide://run?File=%B4X%\Zipper.jar&Args=Project.zip&VMArgs=-DZeroSharedFiles%3DTrue

Sub Class_Globals
	Private Root As B4XView
	Private xui As XUI
	Private WebView1 As WebView
	#if B4A
	Private WebViewExtras1 As WebViewExtras
	#end if
	Private HtmlFilesVersion As String = "1.00"
End Sub

Public Sub Initialize
'	B4XPages.GetManager.LogEvents = True
End Sub

'This event will be called once, before the page becomes visible.
Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("MainPage")
	xui.SetDataFolder("CKEditor Example")
	Wait For (CopyHtmlFiles) Complete (unused As Boolean)
	#if B4A
	WebViewExtras1.addWebChromeClient(WebView1, "WebView1")
	WebViewExtras1.addJavascriptInterface(WebView1, "B4A")
	#end if
	WebView1.LoadUrl(xui.FileUri(xui.DefaultFolder, "index.html"))
End Sub

Private Sub CopyHtmlFiles As ResumableSub
	If File.Exists(xui.DefaultFolder, "html_files_version.txt") Then
		Dim s As String = File.ReadString(xui.DefaultFolder, "html_files_version.txt")
		If s = HtmlFilesVersion Then Return True
	End If
	Log("copying files...")
	For Each s As String In Array("bg.png", "ckeditor.js.map", "ckeditor.js", "github.svg", "index.html", "logo.svg", "sample.css", "umbrellas.jpg")
		Wait For (File.CopyAsync(File.DirAssets, s, xui.DefaultFolder, s)) Complete (Success As Boolean)
		Log("Success: " & Success)
	Next
	File.WriteString(xui.DefaultFolder, "html_files_version.txt", HtmlFilesVersion)
	Return True
End Sub

Private Sub Button1_Click
	Dim js As String = $"window.editor.getData()"$
	Wait For (RunJavaScript(js)) Complete(Html As String)
	B4XPages.SetTitle(Me, Html.Length)
	Log(Html)
End Sub

Private Sub RunJavaScript (js As String) As ResumableSub
	#if B4A
	WebViewExtras1.executeJavascript(WebView1, $"B4A.CallSub('Process_HTML', true, ${js})"$)
	Wait For Process_Html(html As String)
	Return html
	#Else If B4J
	Return WebView1.As(JavaObject).RunMethodJO("getEngine", Null).RunMethod("executeScript", Array(js))
	#Else If B4i
	Dim sf As Object = WebView1.EvaluateJavaScript(js)
	Wait For (sf) WebView1_JSComplete (Success As Boolean, Result As String)
	Return Result
	#end if
End Sub



