/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.util.FileUtils;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.direct.ClassPathOpener;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.command.UsageException;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.command.dexer.MiniServer;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.ClassDefItem;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.EncodedMethod;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.Type;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    public static final int CONCURRENCY_LEVEL = 4;
    private static final String DEX_EXTENSION = ".dex";
    private static final String DEX_PREFIX = "classes";
    private static final String IN_RE_CORE_CLASSES = "Ill-advised or mistaken usage of a core class (java.* or javax.*)\nwhen not building a core library.\n\nThis is often due to inadvertently including a core library file\nin your application's project, when using an IDE (such as\nEclipse). If you are sure you're not intentionally defining a\ncore class, then this is the most likely explanation of what's\ngoing on.\n\nHowever, you might actually be trying to define a class in a core\nnamespace, the source of which you may have taken, for example,\nfrom a non-Android virtual machine project. This will most\nassuredly not work. At a minimum, it jeopardizes the\ncompatibility of your app with future versions of the platform.\nIt is also often of questionable legality.\n\nIf you really intend to build a core library -- which is only\nappropriate as part of creating a full virtual machine\ndistribution, as opposed to compiling an application -- then use\nthe \"--core-library\" option to suppress this error message.\n\nIf you go ahead and use \"--core-library\" but are in fact\nbuilding an application, then be forewarned that your application\nwill still fail to build or run, at some point. Please be\nprepared for angry customers who find, for example, that your\napplication ceases to function once they upgrade their operating\nsystem. You will be to blame for this problem.\n\nIf you are legitimately using some code that happens to be in a\ncore package, then the easiest safe alternative you have is to\nrepackage that code. That is, move the classes in question into\nyour own package namespace. This means that they will never be in\nconflict with core system classes. JarJar is a tool that may help\nyou in this endeavor. If you find that you cannot do this, then\nthat is an indication that the path you are on will ultimately\nlead to pain, suffering, grief, and lamentation.\n";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String[] JAVAX_CORE = new String[]{"accessibility", "crypto", "imageio", "management", "naming", "net", "print", "rmi", "security", "sip", "sound", "sql", "swing", "transaction", "xml"};
    private static final int MAX_METHOD_ADDED_DURING_DEX_CREATION = 2;
    private static final int MAX_FIELD_ADDED_DURING_DEX_CREATION = 9;
    private AtomicInteger errors = new AtomicInteger(0);
    private Arguments args;
    private DexFile outputDex;
    private TreeMap<String, byte[]> outputResources;
    private final List<byte[]> libraryDexBuffers = new ArrayList<byte[]>();
    private ExecutorService classTranslatorPool;
    private ExecutorService classDefItemConsumer;
    private List<Future<Boolean>> addToDexFutures = new ArrayList<Future<Boolean>>();
    private ExecutorService dexOutPool;
    private List<Future<byte[]>> dexOutputFutures = new ArrayList<Future<byte[]>>();
    private Object dexRotationLock = new Object();
    private int maxMethodIdsInProcess = 0;
    private int maxFieldIdsInProcess = 0;
    private volatile boolean anyFilesProcessed;
    private long minimumFileAge = 0L;
    private Set<String> classesInMainDex = null;
    private List<byte[]> dexOutputArrays = new ArrayList<byte[]>();
    private OutputStreamWriter humanOutWriter = null;
    private final DxContext context;

    public Main(DxContext context) {
        this.context = context;
    }

    public static void main(String[] argArray) throws IOException {
        DxContext context = new DxContext();
        Arguments arguments = new Arguments(context);
        arguments.parse(argArray);
        int result = new Main(context).runDx(arguments);
        if (result != 0) {
            System.exit(result);
        }
    }

    public static void clearInternTables() {
        Prototype.clearInternTable();
        RegisterSpec.clearInternTable();
        CstType.clearInternTable();
        Type.clearInternTable();
    }

    public static int run(Arguments arguments) throws IOException {
        return new Main(new DxContext()).runDx(arguments);
    }

    public int runDx(Arguments arguments) throws IOException {
        this.errors.set(0);
        this.libraryDexBuffers.clear();
        this.args = arguments;
        this.args.makeOptionsObjects();
        OutputStream humanOutRaw = null;
        if (this.args.humanOutName != null) {
            humanOutRaw = this.openOutput(this.args.humanOutName);
            this.humanOutWriter = new OutputStreamWriter(humanOutRaw);
        }
        try {
            if (this.args.multiDex) {
                int n = this.runMultiDex();
                return n;
            }
            int n = this.runMonoDex();
            return n;
        }
        finally {
            this.closeOutput(humanOutRaw);
        }
    }

    private int runMonoDex() throws IOException {
        File incrementalOutFile = null;
        if (this.args.incremental) {
            if (this.args.outName == null) {
                this.context.err.println("error: no incremental output name specified");
                return -1;
            }
            incrementalOutFile = new File(this.args.outName);
            if (incrementalOutFile.exists()) {
                this.minimumFileAge = incrementalOutFile.lastModified();
            }
        }
        if (!this.processAllFiles()) {
            return 1;
        }
        if (this.args.incremental && !this.anyFilesProcessed) {
            return 0;
        }
        byte[] outArray = null;
        if (!(this.outputDex.isEmpty() && this.args.humanOutName == null || (outArray = this.writeDex(this.outputDex)) != null)) {
            return 2;
        }
        if (this.args.incremental) {
            outArray = this.mergeIncremental(outArray, incrementalOutFile);
        }
        outArray = this.mergeLibraryDexBuffers(outArray);
        if (this.args.jarOutput) {
            this.outputDex = null;
            if (outArray != null) {
                this.outputResources.put("classes.dex", outArray);
            }
            if (!this.createJar(this.args.outName)) {
                return 3;
            }
        } else if (outArray != null && this.args.outName != null) {
            OutputStream out = this.openOutput(this.args.outName);
            out.write(outArray);
            this.closeOutput(out);
        }
        return 0;
    }

    private int runMultiDex() throws IOException {
        assert (!this.args.incremental);
        if (this.args.mainDexListFile != null) {
            this.classesInMainDex = new HashSet<String>();
            Main.readPathsFromFile(this.args.mainDexListFile, this.classesInMainDex);
        }
        this.dexOutPool = Executors.newFixedThreadPool(this.args.numThreads);
        if (!this.processAllFiles()) {
            return 1;
        }
        if (!this.libraryDexBuffers.isEmpty()) {
            throw new DexException("Library dex files are not supported in multi-dex mode");
        }
        if (this.outputDex != null) {
            this.dexOutputFutures.add(this.dexOutPool.submit(new DexWriter(this.outputDex)));
            this.outputDex = null;
        }
        try {
            this.dexOutPool.shutdown();
            if (!this.dexOutPool.awaitTermination(600L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Timed out waiting for dex writer threads.");
            }
            for (Future<byte[]> f : this.dexOutputFutures) {
                this.dexOutputArrays.add(f.get());
            }
        }
        catch (InterruptedException ex) {
            this.dexOutPool.shutdownNow();
            throw new RuntimeException("A dex writer thread has been interrupted.");
        }
        catch (Exception e) {
            this.dexOutPool.shutdownNow();
            throw new RuntimeException("Unexpected exception in dex writer thread");
        }
        if (this.args.jarOutput) {
            int i = 0;
            while (i < this.dexOutputArrays.size()) {
                this.outputResources.put(Main.getDexFileName(i), this.dexOutputArrays.get(i));
                ++i;
            }
            if (!this.createJar(this.args.outName)) {
                return 3;
            }
        } else if (this.args.outName != null) {
            File outDir = new File(this.args.outName);
            assert (outDir.isDirectory());
            int i = 0;
            while (i < this.dexOutputArrays.size()) {
                FileOutputStream out = new FileOutputStream(new File(outDir, Main.getDexFileName(i)));
                try {
                    ((OutputStream)out).write(this.dexOutputArrays.get(i));
                }
                finally {
                    this.closeOutput(out);
                }
                ++i;
            }
        }
        return 0;
    }

    private static String getDexFileName(int i) {
        if (i == 0) {
            return "classes.dex";
        }
        return DEX_PREFIX + (i + 1) + DEX_EXTENSION;
    }

    private static void readPathsFromFile(String fileName, Collection<String> paths) throws IOException {
        try (BufferedReader bfr = null;){
            String line;
            FileReader fr = new FileReader(fileName);
            bfr = new BufferedReader(fr);
            while ((line = bfr.readLine()) != null) {
                paths.add(Main.fixPath(line));
            }
        }
    }

    private byte[] mergeIncremental(byte[] update, File base) throws IOException {
        Dex dexA = null;
        Dex dexB = null;
        if (update != null) {
            dexA = new Dex(update);
        }
        if (base.exists()) {
            dexB = new Dex(base);
        }
        if (dexA == null && dexB == null) {
            return null;
        }
        Dex result = dexA == null ? dexB : (dexB == null ? dexA : new DexMerger(new Dex[]{dexA, dexB}, CollisionPolicy.KEEP_FIRST, this.context).merge());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        result.writeTo(bytesOut);
        return bytesOut.toByteArray();
    }

    private byte[] mergeLibraryDexBuffers(byte[] outArray) throws IOException {
        ArrayList<Dex> dexes = new ArrayList<Dex>();
        if (outArray != null) {
            dexes.add(new Dex(outArray));
        }
        for (byte[] libraryDex : this.libraryDexBuffers) {
            dexes.add(new Dex(libraryDex));
        }
        if (dexes.isEmpty()) {
            return null;
        }
        Dex merged = new DexMerger(dexes.toArray(new Dex[dexes.size()]), CollisionPolicy.FAIL, this.context).merge();
        return merged.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processAllFiles() {
        block40: {
            block45: {
                server = new MiniServer();
                server.start();
                this.createDexFile();
                if (this.args.jarOutput) {
                    this.outputResources = new TreeMap<K, V>();
                }
                this.anyFilesProcessed = false;
                fileNames = this.args.fileNames;
                Arrays.sort(fileNames);
                this.classTranslatorPool = new ThreadPoolExecutor(this.args.numThreads, this.args.numThreads, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2 * this.args.numThreads, true), new ThreadPoolExecutor.CallerRunsPolicy());
                this.classDefItemConsumer = Executors.newSingleThreadExecutor();
                try {
                    block43: {
                        block42: {
                            if (this.args.mainDexListFile == null) break block42;
                            mainPassFilter /* !! */  = this.args.strictNameCheck != false ? new MainDexListFilter() : new BestEffortMainDexListFilter();
                            i = 0;
                            if (true) ** GOTO lbl52
                        }
                        System.out.println("*************************");
                        strippedPackages = System.getProperty("b4a_skiplist", "");
                        sp = strippedPackages.split(",");
                        b4aFilter = new ClassPathOpener.FileNameFilter(){

                            @Override
                            public boolean accept(String paramString) {
                                String[] stringArray = sp;
                                int n = sp.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String s = stringArray[n2];
                                    if (s.length() > 0 && paramString.startsWith(s)) {
                                        return false;
                                    }
                                    ++n2;
                                }
                                return true;
                            }
                        };
                        if (!this.args.multiDex) break block43;
                        System.out.println("waiting for latch(1).");
                        if (!MiniServer.latch.await(10L, TimeUnit.MINUTES)) {
                            System.exit(1);
                        }
                        jars = new ArrayList<Object>();
                        var10_19 = fileNames;
                        var9_21 = fileNames.length;
                        var8_23 = 0;
                        if (true) ** GOTO lbl84
                    }
                    i = 0;
                    while (true) {
                        block44: {
                            if (i < fileNames.length) break block44;
                            System.out.println("waiting for latch.");
                            if (!MiniServer.latch.await(10L, TimeUnit.MINUTES)) {
                                System.exit(1);
                            }
                            i = 0;
                            if (true) ** GOTO lbl122
                        }
                        if (fileNames[i].endsWith("jar")) {
                            this.processOne((String)fileNames[i], b4aFilter);
                        }
                        ++i;
                    }
                }
                catch (StopProcessing strippedPackages) {
                    break block40;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break block40;
                }
                do {
                    this.processOne((String)fileNames[i], mainPassFilter /* !! */ );
                    ++i;
lbl52:
                    // 2 sources

                } while (i < fileNames.length);
                if (this.dexOutputFutures.size() > 0) {
                    throw new DexException("Too many classes in --main-dex-list, main dex capacity exceeded");
                }
                if (this.args.minimalMainDex) {
                    block41: {
                        i = this.dexRotationLock;
                        synchronized (i) {
                            while (true) {
                                while (true) {
                                    if (this.maxMethodIdsInProcess <= 0 && this.maxFieldIdsInProcess <= 0) {
                                        break block41;
                                    }
                                    try {
                                        this.dexRotationLock.wait();
                                    }
                                    catch (InterruptedException var5_13) {
                                        // empty catch block
                                    }
                                }
                                break;
                            }
                            catch (Throwable v0) {
                                throw v0;
                            }
                        }
                    }
                    this.rotateDexFile();
                }
                i = 0;
                while (i < fileNames.length) {
                    this.processOne((String)fileNames[i], new NotFilter(mainPassFilter /* !! */ ));
                    ++i;
                }
                break block40;
                do {
                    if ((filename = var10_19[var8_23]).endsWith(".jar")) {
                        jars.add(filename);
                    }
                    ++var8_23;
lbl84:
                    // 2 sources

                } while (var8_23 < var9_21);
                Collections.sort(jars, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return (int)(new File(o1).length() - new File(o2).length());
                    }
                });
                var10_19 = fileNames;
                var9_21 = fileNames.length;
                var8_23 = 0;
                while (var8_23 < var9_21) {
                    filename = var10_19[var8_23];
                    if (!filename.endsWith(".jar")) {
                        jars.add(filename);
                    }
                    ++var8_23;
                }
                jars.toArray(fileNames);
                System.out.println("files: " + Arrays.toString(fileNames));
                filesInMainDex = new ClassPathOpener.FileNameFilter(){

                    @Override
                    public boolean accept(String path) {
                        return path.startsWith("bin") || path.startsWith("android/support/multidex") || path.startsWith("androidx/multidex") || path.contains("Service") || path.contains("Activity") || path.contains("Receiver") || path.contains("Provider");
                    }
                };
                var11_27 = fileNames;
                var10_20 = fileNames.length;
                var9_21 = 0;
                while (var9_21 < var10_20) {
                    filename = var11_27[var9_21];
                    this.processOne((String)filename, filesInMainDex);
                    ++var9_21;
                }
                otherFiles = new ClassPathOpener.FileNameFilter(){

                    @Override
                    public boolean accept(String path) {
                        return !filesInMainDex.accept(path) && b4aFilter.accept(path);
                    }
                };
                var12_29 = fileNames;
                var11_28 = fileNames.length;
                var10_20 = 0;
                while (var10_20 < var11_28) {
                    filename = var12_29[var10_20];
                    this.processOne((String)filename, otherFiles);
                    ++var10_20;
                }
                break block45;
                do {
                    if (!fileNames[i].endsWith("jar")) {
                        this.processOne((String)fileNames[i], b4aFilter);
                    }
                    ++i;
lbl122:
                    // 2 sources

                } while (i < fileNames.length);
            }
            System.out.println("after process files.");
        }
        try {
            this.classTranslatorPool.shutdown();
            this.classTranslatorPool.awaitTermination(600L, TimeUnit.SECONDS);
            this.classDefItemConsumer.shutdown();
            this.classDefItemConsumer.awaitTermination(600L, TimeUnit.SECONDS);
            for (Future<Boolean> f : this.addToDexFutures) {
                try {
                    f.get();
                }
                catch (ExecutionException ex) {
                    count = this.errors.incrementAndGet();
                    if (count >= 10) {
                        throw new InterruptedException("Too many errors");
                    }
                    if (this.args.debug) {
                        this.context.err.println("Uncaught translation error:");
                        ex.getCause().printStackTrace(this.context.err);
                        continue;
                    }
                    this.context.err.println("Uncaught translation error: " + ex.getCause());
                }
            }
        }
        catch (InterruptedException ie) {
            this.classTranslatorPool.shutdownNow();
            this.classDefItemConsumer.shutdownNow();
            throw new RuntimeException("Translation has been interrupted", ie);
        }
        catch (Exception e) {
            this.classTranslatorPool.shutdownNow();
            this.classDefItemConsumer.shutdownNow();
            e.printStackTrace(this.context.out);
            throw new RuntimeException("Unexpected exception in translator thread.", e);
        }
        errorNum = this.errors.get();
        if (errorNum != 0) {
            this.context.err.println(String.valueOf(errorNum) + " error" + (errorNum == 1 ? "" : "s") + "; aborting");
            return false;
        }
        if (this.args.incremental && !this.anyFilesProcessed) {
            return true;
        }
        if (!this.anyFilesProcessed && !this.args.emptyOk) {
            this.context.err.println("no classfiles specified");
            return false;
        }
        if (this.args.optimize && this.args.statistics) {
            this.context.codeStatistics.dumpStatistics(this.context.out);
        }
        return true;
    }

    private void createDexFile() {
        this.outputDex = new DexFile(this.args.dexOptions);
        if (this.args.dumpWidth != 0) {
            this.outputDex.setDumpWidth(this.args.dumpWidth);
        }
    }

    private void rotateDexFile() {
        if (this.outputDex != null) {
            if (this.dexOutPool != null) {
                this.dexOutputFutures.add(this.dexOutPool.submit(new DexWriter(this.outputDex)));
            } else {
                this.dexOutputArrays.add(this.writeDex(this.outputDex));
            }
        }
        this.createDexFile();
    }

    private void processOne(String pathname, ClassPathOpener.FileNameFilter filter) {
        ClassPathOpener opener = new ClassPathOpener(pathname, true, filter, new FileBytesConsumer());
        if (opener.process()) {
            this.updateStatus(true);
        }
    }

    private void updateStatus(boolean res) {
        this.anyFilesProcessed |= res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFileBytes(String name, long lastModified, byte[] bytes) {
        boolean keepResources;
        boolean isClass = name.endsWith(".class");
        boolean isClassesDex = name.equals("classes.dex");
        boolean bl = keepResources = this.outputResources != null;
        if (!(isClass || isClassesDex || keepResources)) {
            if (this.args.verbose) {
                this.context.out.println("ignored resource " + name);
            }
            return false;
        }
        if (this.args.verbose) {
            this.context.out.println("processing " + name + "...");
        }
        String fixedName = Main.fixPath(name);
        if (isClass) {
            if (keepResources && this.args.keepClassesInJar) {
                TreeMap<String, byte[]> treeMap = this.outputResources;
                synchronized (treeMap) {
                    this.outputResources.put(fixedName, bytes);
                }
            }
            if (lastModified < this.minimumFileAge) {
                return true;
            }
            this.processClass(fixedName, bytes);
            return false;
        }
        if (isClassesDex) {
            List<byte[]> list = this.libraryDexBuffers;
            synchronized (list) {
                this.libraryDexBuffers.add(bytes);
            }
            return true;
        }
        TreeMap<String, byte[]> treeMap = this.outputResources;
        synchronized (treeMap) {
            this.outputResources.put(fixedName, bytes);
        }
        return true;
    }

    private boolean processClass(String name, byte[] bytes) {
        if (!this.args.coreLibrary) {
            this.checkClassName(name);
        }
        try {
            new DirectClassFileConsumer(name, bytes, null).call(new ClassParserTask(name, bytes).call());
        }
        catch (ParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception parsing classes", ex);
        }
        return true;
    }

    private DirectClassFile parseClass(String name, byte[] bytes) {
        DirectClassFile cf = new DirectClassFile(bytes, name, this.args.cfOptions.strictNameCheck);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        cf.getMagic();
        return cf;
    }

    private ClassDefItem translateClass(byte[] bytes, DirectClassFile cf) {
        try {
            return CfTranslator.translate(this.context, cf, bytes, this.args.cfOptions, this.args.dexOptions, this.outputDex);
        }
        catch (ParseException ex) {
            this.context.err.println("\ntrouble processing:");
            if (this.args.debug) {
                ex.printStackTrace(this.context.err);
            } else {
                ex.printContext(this.context.err);
            }
            this.errors.incrementAndGet();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addClassToDex(ClassDefItem clazz) {
        DexFile dexFile = this.outputDex;
        synchronized (dexFile) {
            this.outputDex.add(clazz);
        }
        return true;
    }

    private void checkClassName(String name) {
        boolean bogus = false;
        if (name.startsWith("java/")) {
            bogus = true;
        } else if (name.startsWith("javax/")) {
            int slashAt = name.indexOf(47, 6);
            if (slashAt == -1) {
                bogus = true;
            } else {
                String pkg = name.substring(6, slashAt);
                boolean bl = bogus = Arrays.binarySearch(JAVAX_CORE, pkg) >= 0;
            }
        }
        if (!bogus) {
            return;
        }
        this.context.err.println("\ntrouble processing \"" + name + "\":\n\n" + IN_RE_CORE_CLASSES);
        this.errors.incrementAndGet();
        throw new StopProcessing();
    }

    private byte[] writeDex(DexFile outputDex) {
        byte[] outArray = null;
        try {
            try {
                if (this.args.methodToDump != null) {
                    outputDex.toDex(null, false);
                    this.dumpMethod(outputDex, this.args.methodToDump, this.humanOutWriter);
                } else {
                    outArray = outputDex.toDex(this.humanOutWriter, this.args.verboseDump);
                }
                if (this.args.statistics) {
                    this.context.out.println(outputDex.getStatistics().toHuman());
                }
            }
            finally {
                if (this.humanOutWriter != null) {
                    this.humanOutWriter.flush();
                }
            }
        }
        catch (Exception ex) {
            if (this.args.debug) {
                this.context.err.println("\ntrouble writing output:");
                ex.printStackTrace(this.context.err);
            } else {
                this.context.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return null;
        }
        return outArray;
    }

    private boolean createJar(String fileName) {
        try {
            Manifest manifest = this.makeManifest();
            OutputStream out = this.openOutput(fileName);
            JarOutputStream jarOut = new JarOutputStream(out, manifest);
            try {
                for (Map.Entry<String, byte[]> e : this.outputResources.entrySet()) {
                    String name = e.getKey();
                    byte[] contents = e.getValue();
                    JarEntry entry = new JarEntry(name);
                    int length = contents.length;
                    if (this.args.verbose) {
                        this.context.out.println("writing " + name + "; size " + length + "...");
                    }
                    entry.setSize(length);
                    jarOut.putNextEntry(entry);
                    jarOut.write(contents);
                    jarOut.closeEntry();
                }
            }
            finally {
                jarOut.finish();
                jarOut.flush();
                this.closeOutput(out);
            }
        }
        catch (Exception ex) {
            if (this.args.debug) {
                this.context.err.println("\ntrouble writing output:");
                ex.printStackTrace(this.context.err);
            } else {
                this.context.err.println("\ntrouble writing output: " + ex.getMessage());
            }
            return false;
        }
        return true;
    }

    private Manifest makeManifest() throws IOException {
        Attributes attribs;
        Manifest manifest;
        byte[] manifestBytes = this.outputResources.get(MANIFEST_NAME);
        if (manifestBytes == null) {
            manifest = new Manifest();
            attribs = manifest.getMainAttributes();
            attribs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        } else {
            manifest = new Manifest(new ByteArrayInputStream(manifestBytes));
            attribs = manifest.getMainAttributes();
            this.outputResources.remove(MANIFEST_NAME);
        }
        String createdBy = attribs.getValue(CREATED_BY);
        createdBy = createdBy == null ? "" : String.valueOf(createdBy) + " + ";
        createdBy = String.valueOf(createdBy) + "dx 1.16";
        attribs.put(CREATED_BY, createdBy);
        attribs.putValue("Dex-Location", "classes.dex");
        return manifest;
    }

    private OutputStream openOutput(String name) throws IOException {
        if (name.equals("-") || name.startsWith("-.")) {
            return this.context.out;
        }
        return new FileOutputStream(name);
    }

    private void closeOutput(OutputStream stream) throws IOException {
        if (stream == null) {
            return;
        }
        stream.flush();
        if (stream != this.context.out) {
            stream.close();
        }
    }

    private static String fixPath(String path) {
        int index;
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        if ((index = path.lastIndexOf("/./")) != -1) {
            return path.substring(index + 3);
        }
        if (path.startsWith("./")) {
            return path.substring(2);
        }
        return path;
    }

    private void dumpMethod(DexFile dex, String fqName, OutputStreamWriter out) {
        boolean wildcard = fqName.endsWith("*");
        int lastDot = fqName.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == fqName.length() - 1) {
            this.context.err.println("bogus fully-qualified method name: " + fqName);
            return;
        }
        String className = fqName.substring(0, lastDot).replace('.', '/');
        String methodName = fqName.substring(lastDot + 1);
        ClassDefItem clazz = dex.getClassOrNull(className);
        if (clazz == null) {
            this.context.err.println("no such class: " + className);
            return;
        }
        if (wildcard) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        ArrayList<EncodedMethod> allMeths = clazz.getMethods();
        TreeMap<CstNat, EncodedMethod> meths = new TreeMap<CstNat, EncodedMethod>();
        for (EncodedMethod meth : allMeths) {
            String methName = meth.getName().getString();
            if ((!wildcard || !methName.startsWith(methodName)) && (wildcard || !methName.equals(methodName))) continue;
            meths.put(meth.getRef().getNat(), meth);
        }
        if (meths.size() == 0) {
            this.context.err.println("no such method: " + fqName);
            return;
        }
        PrintWriter pw = new PrintWriter(out);
        for (EncodedMethod meth : meths.values()) {
            meth.debugPrint(pw, this.args.verboseDump);
            CstString sourceFile = clazz.getSourceFile();
            if (sourceFile != null) {
                pw.println("  source file: " + sourceFile.toQuoted());
            }
            Annotations methodAnnotations = clazz.getMethodAnnotations(meth.getRef());
            AnnotationsList parameterAnnotations = clazz.getParameterAnnotations(meth.getRef());
            if (methodAnnotations != null) {
                pw.println("  method annotations:");
                for (Annotation a : methodAnnotations.getAnnotations()) {
                    pw.println("    " + a);
                }
            }
            if (parameterAnnotations == null) continue;
            pw.println("  parameter annotations:");
            int sz = parameterAnnotations.size();
            int i = 0;
            while (i < sz) {
                pw.println("    parameter " + i);
                Annotations annotations = parameterAnnotations.get(i);
                for (Annotation a : annotations.getAnnotations()) {
                    pw.println("      " + a);
                }
                ++i;
            }
        }
        pw.flush();
    }

    static /* synthetic */ DexFile access$9(Main main) {
        return main.outputDex;
    }

    static /* synthetic */ void access$12(Main main) {
        main.rotateDexFile();
    }

    static /* synthetic */ ExecutorService access$15(Main main) {
        return main.classTranslatorPool;
    }

    static /* synthetic */ ExecutorService access$16(Main main) {
        return main.classDefItemConsumer;
    }

    static /* synthetic */ List access$17(Main main) {
        return main.addToDexFutures;
    }

    public static class Arguments {
        private static final String MINIMAL_MAIN_DEX_OPTION = "--minimal-main-dex";
        private static final String MAIN_DEX_LIST_OPTION = "--main-dex-list";
        private static final String MULTI_DEX_OPTION = "--multi-dex";
        private static final String NUM_THREADS_OPTION = "--num-threads";
        private static final String INCREMENTAL_OPTION = "--incremental";
        private static final String INPUT_LIST_OPTION = "--input-list";
        public final DxContext context;
        public boolean debug = false;
        public boolean warnings = true;
        public boolean verbose = false;
        public boolean verboseDump = false;
        public boolean coreLibrary = false;
        public String methodToDump = null;
        public int dumpWidth = 0;
        public String outName = null;
        public String humanOutName = null;
        public boolean strictNameCheck = true;
        public boolean emptyOk = false;
        public boolean jarOutput = false;
        public boolean keepClassesInJar = false;
        public int minSdkVersion = 13;
        public int positionInfo = 2;
        public boolean localInfo = true;
        public boolean incremental = false;
        public boolean forceJumbo = false;
        public String[] fileNames;
        public boolean optimize = true;
        public String optimizeListFile = null;
        public String dontOptimizeListFile = null;
        public boolean statistics;
        public CfOptions cfOptions;
        public DexOptions dexOptions;
        public int numThreads = 1;
        public boolean multiDex = false;
        public String mainDexListFile = null;
        public boolean minimalMainDex = false;
        public int maxNumberOfIdxPerDex = 65536;
        private List<String> inputList = null;
        private boolean outputIsDirectory = false;
        private boolean outputIsDirectDex = false;

        public Arguments(DxContext context) {
            this.context = context;
        }

        public Arguments() {
            this(new DxContext());
        }

        private void parseFlags(ArgumentsParser parser) {
            while (parser.getNext()) {
                if (parser.isArg("--debug")) {
                    this.debug = true;
                    continue;
                }
                if (parser.isArg("--no-warning")) {
                    this.warnings = false;
                    continue;
                }
                if (parser.isArg("--verbose")) {
                    this.verbose = true;
                    continue;
                }
                if (parser.isArg("--verbose-dump")) {
                    this.verboseDump = true;
                    continue;
                }
                if (parser.isArg("--no-files")) {
                    this.emptyOk = true;
                    continue;
                }
                if (parser.isArg("--no-optimize")) {
                    this.optimize = false;
                    continue;
                }
                if (parser.isArg("--no-strict")) {
                    this.strictNameCheck = false;
                    continue;
                }
                if (parser.isArg("--core-library")) {
                    this.coreLibrary = true;
                    continue;
                }
                if (parser.isArg("--statistics")) {
                    this.statistics = true;
                    continue;
                }
                if (parser.isArg("--optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        this.context.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.optimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--no-optimize-list=")) {
                    if (this.dontOptimizeListFile != null) {
                        this.context.err.println("--optimize-list and --no-optimize-list are incompatible.");
                        throw new UsageException();
                    }
                    this.optimize = true;
                    this.dontOptimizeListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--keep-classes")) {
                    this.keepClassesInJar = true;
                    continue;
                }
                if (parser.isArg("--output=")) {
                    this.outName = parser.getLastValue();
                    if (new File(this.outName).isDirectory()) {
                        this.jarOutput = false;
                        this.outputIsDirectory = true;
                        continue;
                    }
                    if (FileUtils.hasArchiveSuffix(this.outName)) {
                        this.jarOutput = true;
                        continue;
                    }
                    if (this.outName.endsWith(Main.DEX_EXTENSION) || this.outName.equals("-")) {
                        this.jarOutput = false;
                        this.outputIsDirectDex = true;
                        continue;
                    }
                    this.context.err.println("unknown output extension: " + this.outName);
                    throw new UsageException();
                }
                if (parser.isArg("--dump-to=")) {
                    this.humanOutName = parser.getLastValue();
                    continue;
                }
                if (parser.isArg("--dump-width=")) {
                    this.dumpWidth = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--dump-method=")) {
                    this.methodToDump = parser.getLastValue();
                    this.jarOutput = false;
                    continue;
                }
                if (parser.isArg("--positions=")) {
                    String pstr = parser.getLastValue().intern();
                    if (pstr == "none") {
                        this.positionInfo = 1;
                        continue;
                    }
                    if (pstr == "important") {
                        this.positionInfo = 3;
                        continue;
                    }
                    if (pstr == "lines") {
                        this.positionInfo = 2;
                        continue;
                    }
                    this.context.err.println("unknown positions option: " + pstr);
                    throw new UsageException();
                }
                if (parser.isArg("--no-locals")) {
                    this.localInfo = false;
                    continue;
                }
                if (parser.isArg("--num-threads=")) {
                    this.numThreads = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg(INCREMENTAL_OPTION)) {
                    this.incremental = true;
                    continue;
                }
                if (parser.isArg("--force-jumbo")) {
                    this.forceJumbo = true;
                    continue;
                }
                if (parser.isArg(MULTI_DEX_OPTION)) {
                    this.multiDex = true;
                    continue;
                }
                if (parser.isArg("--main-dex-list=")) {
                    this.mainDexListFile = parser.getLastValue();
                    continue;
                }
                if (parser.isArg(MINIMAL_MAIN_DEX_OPTION)) {
                    this.minimalMainDex = true;
                    continue;
                }
                if (parser.isArg("--set-max-idx-number=")) {
                    this.maxNumberOfIdxPerDex = Integer.parseInt(parser.getLastValue());
                    continue;
                }
                if (parser.isArg("--input-list=")) {
                    File inputListFile = new File(parser.getLastValue());
                    try {
                        this.inputList = new ArrayList<String>();
                        Main.readPathsFromFile(inputListFile.getAbsolutePath(), this.inputList);
                        continue;
                    }
                    catch (IOException e) {
                        this.context.err.println("Unable to read input list file: " + inputListFile.getName());
                        throw new UsageException();
                    }
                }
                if (parser.isArg("--min-sdk-version=")) {
                    int value;
                    String arg = parser.getLastValue();
                    try {
                        value = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException ex) {
                        value = -1;
                    }
                    if (value < 1) {
                        System.err.println("improper min-sdk-version option: " + arg);
                        throw new UsageException();
                    }
                    this.minSdkVersion = value;
                    continue;
                }
                this.context.err.println("unknown option: " + parser.getCurrent());
                throw new UsageException();
            }
        }

        private void parse(String[] args) {
            ArgumentsParser parser = new ArgumentsParser(args);
            this.parseFlags(parser);
            this.fileNames = parser.getRemaining();
            if (this.inputList != null && !this.inputList.isEmpty()) {
                this.inputList.addAll(Arrays.asList(this.fileNames));
                this.fileNames = this.inputList.toArray(new String[this.inputList.size()]);
            }
            if (this.fileNames.length == 0) {
                if (!this.emptyOk) {
                    this.context.err.println("no input files specified");
                    throw new UsageException();
                }
            } else if (this.emptyOk) {
                this.context.out.println("ignoring input files");
            }
            if (this.humanOutName == null && this.methodToDump != null) {
                this.humanOutName = "-";
            }
            if (this.mainDexListFile != null && !this.multiDex) {
                this.context.err.println("--main-dex-list is only supported in combination with --multi-dex");
                throw new UsageException();
            }
            if (this.minimalMainDex && (this.mainDexListFile == null || !this.multiDex)) {
                this.context.err.println("--minimal-main-dex is only supported in combination with --multi-dex and --main-dex-list");
                throw new UsageException();
            }
            if (this.multiDex && this.incremental) {
                this.context.err.println("--incremental is not supported with --multi-dex");
                throw new UsageException();
            }
            if (this.multiDex && this.outputIsDirectDex) {
                this.context.err.println("Unsupported output \"" + this.outName + "\". " + MULTI_DEX_OPTION + " supports only archive or directory output");
                throw new UsageException();
            }
            if (this.outputIsDirectory && !this.multiDex) {
                this.outName = new File(this.outName, "classes.dex").getPath();
            }
            this.makeOptionsObjects();
        }

        public void parseFlags(String[] flags) {
            this.parseFlags(new ArgumentsParser(flags));
        }

        public void makeOptionsObjects() {
            this.cfOptions = new CfOptions();
            this.cfOptions.positionInfo = this.positionInfo;
            this.cfOptions.localInfo = this.localInfo;
            this.cfOptions.strictNameCheck = this.strictNameCheck;
            this.cfOptions.optimize = this.optimize;
            this.cfOptions.optimizeListFile = this.optimizeListFile;
            this.cfOptions.dontOptimizeListFile = this.dontOptimizeListFile;
            this.cfOptions.statistics = this.statistics;
            this.cfOptions.warn = this.warnings ? this.context.err : this.context.noop;
            this.dexOptions = new DexOptions();
            this.dexOptions.minSdkVersion = this.minSdkVersion;
            this.dexOptions.forceJumbo = this.forceJumbo;
        }

        private static class ArgumentsParser {
            private final String[] arguments;
            private int index;
            private String current;
            private String lastValue;

            public ArgumentsParser(String[] arguments) {
                this.arguments = arguments;
                this.index = 0;
            }

            public String getCurrent() {
                return this.current;
            }

            public String getLastValue() {
                return this.lastValue;
            }

            public boolean getNext() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                if (this.current.equals("--") || !this.current.startsWith("--")) {
                    return false;
                }
                ++this.index;
                return true;
            }

            private boolean getNextValue() {
                if (this.index >= this.arguments.length) {
                    return false;
                }
                this.current = this.arguments[this.index];
                ++this.index;
                return true;
            }

            public String[] getRemaining() {
                int n = this.arguments.length - this.index;
                String[] remaining = new String[n];
                if (n > 0) {
                    System.arraycopy(this.arguments, this.index, remaining, 0, n);
                }
                return remaining;
            }

            public boolean isArg(String prefix) {
                int n = prefix.length();
                if (n > 0 && prefix.charAt(n - 1) == '=') {
                    if (this.current.startsWith(prefix)) {
                        this.lastValue = this.current.substring(n);
                        return true;
                    }
                    if (this.current.equals(prefix = prefix.substring(0, n - 1))) {
                        if (this.getNextValue()) {
                            this.lastValue = this.current;
                            return true;
                        }
                        System.err.println("Missing value after parameter " + prefix);
                        throw new UsageException();
                    }
                    return false;
                }
                return this.current.equals(prefix);
            }
        }
    }

    private class BestEffortMainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        Map<String, List<String>> map = new HashMap<String, List<String>>();

        public BestEffortMainDexListFilter() {
            for (String pathOfClass : Main.this.classesInMainDex) {
                String normalized = Main.fixPath(pathOfClass);
                String simple = this.getSimpleName(normalized);
                List<String> fullPath = this.map.get(simple);
                if (fullPath == null) {
                    fullPath = new ArrayList<String>(1);
                    this.map.put(simple, fullPath);
                }
                fullPath.add(normalized);
            }
        }

        @Override
        public boolean accept(String path) {
            if (path.endsWith(".class")) {
                String normalized = Main.fixPath(path);
                String simple = this.getSimpleName(normalized);
                List<String> fullPaths = this.map.get(simple);
                if (fullPaths != null) {
                    for (String fullPath : fullPaths) {
                        if (!normalized.endsWith(fullPath)) continue;
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private String getSimpleName(String path) {
            int index = path.lastIndexOf(47);
            if (index >= 0) {
                return path.substring(index + 1);
            }
            return path;
        }
    }

    private class ClassDefItemConsumer
    implements Callable<Boolean> {
        String name;
        Future<ClassDefItem> futureClazz;
        int maxMethodIdsInClass;
        int maxFieldIdsInClass;

        private ClassDefItemConsumer(String name, Future<ClassDefItem> futureClazz, int maxMethodIdsInClass, int maxFieldIdsInClass) {
            this.name = name;
            this.futureClazz = futureClazz;
            this.maxMethodIdsInClass = maxMethodIdsInClass;
            this.maxFieldIdsInClass = maxFieldIdsInClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Boolean bl;
            block12: {
                try {
                    ClassDefItem clazz = this.futureClazz.get();
                    if (clazz != null) {
                        Main.this.addClassToDex(clazz);
                        Main.this.updateStatus(true);
                    }
                    bl = true;
                    if (!((Main)Main.this).args.multiDex) break block12;
                }
                catch (ExecutionException ex) {
                    try {
                        Throwable t = ex.getCause();
                        throw t instanceof Exception ? (Exception)t : ex;
                    }
                    catch (Throwable throwable) {
                        if (((Main)Main.this).args.multiDex) {
                            Object object = Main.this.dexRotationLock;
                            synchronized (object) {
                                Main main = Main.this;
                                main.maxMethodIdsInProcess = main.maxMethodIdsInProcess - this.maxMethodIdsInClass;
                                Main main2 = Main.this;
                                main2.maxFieldIdsInProcess = main2.maxFieldIdsInProcess - this.maxFieldIdsInClass;
                                Main.this.dexRotationLock.notifyAll();
                            }
                        }
                        throw throwable;
                    }
                }
                Object object = Main.this.dexRotationLock;
                synchronized (object) {
                    Main main = Main.this;
                    main.maxMethodIdsInProcess = main.maxMethodIdsInProcess - this.maxMethodIdsInClass;
                    Main main3 = Main.this;
                    main3.maxFieldIdsInProcess = main3.maxFieldIdsInProcess - this.maxFieldIdsInClass;
                    Main.this.dexRotationLock.notifyAll();
                }
            }
            return bl;
        }
    }

    private class ClassParserTask
    implements Callable<DirectClassFile> {
        String name;
        byte[] bytes;

        private ClassParserTask(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        @Override
        public DirectClassFile call() throws Exception {
            DirectClassFile cf = Main.this.parseClass(this.name, this.bytes);
            return cf;
        }
    }

    private class ClassTranslatorTask
    implements Callable<ClassDefItem> {
        String name;
        byte[] bytes;
        DirectClassFile classFile;

        private ClassTranslatorTask(String name, byte[] bytes, DirectClassFile classFile) {
            this.name = name;
            this.bytes = bytes;
            this.classFile = classFile;
        }

        @Override
        public ClassDefItem call() {
            ClassDefItem clazz = Main.this.translateClass(this.bytes, this.classFile);
            return clazz;
        }
    }

    private class DexWriter
    implements Callable<byte[]> {
        private DexFile dexFile;

        private DexWriter(DexFile dexFile) {
            this.dexFile = dexFile;
        }

        @Override
        public byte[] call() throws IOException {
            return Main.this.writeDex(this.dexFile);
        }
    }

    private class DirectClassFileConsumer
    implements Callable<Boolean> {
        String name;
        byte[] bytes;
        Future<DirectClassFile> dcff;

        private DirectClassFileConsumer(String name, byte[] bytes, Future<DirectClassFile> dcff) {
            this.name = name;
            this.bytes = bytes;
            this.dcff = dcff;
        }

        @Override
        public Boolean call() throws Exception {
            DirectClassFile cf = this.dcff.get();
            return this.call(cf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private Boolean call(DirectClassFile cf) {
            block14: {
                maxMethodIdsInClass = 0;
                maxFieldIdsInClass = 0;
                if (!Main.access$5((Main)Main.this).multiDex) break block14;
                constantPoolSize = cf.getConstantPool().size();
                maxMethodIdsInClass = constantPoolSize + cf.getMethods().size() + 2;
                maxFieldIdsInClass = constantPoolSize + cf.getFields().size() + 9;
                var5_6 = Main.access$8(Main.this);
                synchronized (var5_6) {
                    var8_7 = Main.access$9(Main.this);
                    synchronized (var8_7) {
                        numMethodIds = Main.access$9(Main.this).getMethodIds().items().size();
                        numFieldIds = Main.access$9(Main.this).getFieldIds().items().size();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var8_7
                        if (true) ** GOTO lbl36
                    }
                    do {
                        if (Main.access$10(Main.this) > 0 || Main.access$11(Main.this) > 0) {
                            try {
                                Main.access$8(Main.this).wait();
                            }
                            catch (InterruptedException var8_8) {}
                        } else {
                            if (Main.access$9(Main.this).getClassDefs().items().size() <= 0) break;
                            Main.access$12(Main.this);
                        }
                        var8_7 = Main.access$9(Main.this);
                        synchronized (var8_7) {
                            numMethodIds = Main.access$9(Main.this).getMethodIds().items().size();
                            numFieldIds = Main.access$9(Main.this).getFieldIds().items().size();
                        }
lbl36:
                        // 2 sources

                    } while (numMethodIds + maxMethodIdsInClass + Main.access$10(Main.this) > Main.access$5((Main)Main.this).maxNumberOfIdxPerDex || numFieldIds + maxFieldIdsInClass + Main.access$11(Main.this) > Main.access$5((Main)Main.this).maxNumberOfIdxPerDex);
                    v2 = Main.this;
                    Main.access$13(v2, Main.access$10(v2) + maxMethodIdsInClass);
                    v3 = Main.this;
                    Main.access$14(v3, Main.access$11(v3) + maxFieldIdsInClass);
                }
            }
            cdif = Main.access$15(Main.this).submit(new ClassTranslatorTask(this.name, this.bytes, cf));
            res = Main.access$16(Main.this).submit(new ClassDefItemConsumer(this.name, cdif, maxMethodIdsInClass, maxFieldIdsInClass));
            Main.access$17(Main.this).add(res);
            return true;
        }
    }

    private class FileBytesConsumer
    implements ClassPathOpener.Consumer {
        private FileBytesConsumer() {
        }

        @Override
        public boolean processFileBytes(String name, long lastModified, byte[] bytes) {
            return Main.this.processFileBytes(name, lastModified, bytes);
        }

        @Override
        public void onException(Exception ex) {
            if (ex instanceof StopProcessing) {
                throw (StopProcessing)ex;
            }
            if (ex instanceof SimException) {
                ((Main)Main.this).context.err.println("\nEXCEPTION FROM SIMULATION:");
                ((Main)Main.this).context.err.println(String.valueOf(ex.getMessage()) + "\n");
                ((Main)Main.this).context.err.println(((SimException)ex).getContext());
            } else if (ex instanceof ParseException) {
                ((Main)Main.this).context.err.println("\nPARSE ERROR:");
                ParseException parseException = (ParseException)ex;
                if (((Main)Main.this).args.debug) {
                    parseException.printStackTrace(((Main)Main.this).context.err);
                } else {
                    parseException.printContext(((Main)Main.this).context.err);
                }
            } else {
                ((Main)Main.this).context.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
                ex.printStackTrace(((Main)Main.this).context.err);
            }
            Main.this.errors.incrementAndGet();
        }

        @Override
        public void onProcessArchiveStart(File file) {
            if (((Main)Main.this).args.verbose) {
                ((Main)Main.this).context.out.println("processing archive " + file + "...");
            }
        }
    }

    private class MainDexListFilter
    implements ClassPathOpener.FileNameFilter {
        private MainDexListFilter() {
        }

        @Override
        public boolean accept(String fullPath) {
            if (fullPath.endsWith(".class")) {
                String path = Main.fixPath(fullPath);
                return Main.this.classesInMainDex.contains(path);
            }
            return true;
        }
    }

    private static class NotFilter
    implements ClassPathOpener.FileNameFilter {
        private final ClassPathOpener.FileNameFilter filter;

        private NotFilter(ClassPathOpener.FileNameFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(String path) {
            return !this.filter.accept(path);
        }
    }

    private static class StopProcessing
    extends RuntimeException {
        private StopProcessing() {
        }
    }
}

