/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dexer;

import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;

class MiniServer {
    public static CountDownLatch latch;
    private int port = Integer.parseInt(System.getProperty("port"));

    public MiniServer() {
        latch = new CountDownLatch(1);
    }

    public void start() {
        Thread t = new Thread(new ServerHandler());
        t.setDaemon(true);
        t.start();
    }

    private class ServerHandler
    implements Runnable {
        private ServerHandler() {
        }

        @Override
        public void run() {
            ServerSocket serverSocket = null;
            Socket socket = null;
            try {
                try {
                    if (MiniServer.this.port == 0) {
                        latch.countDown();
                        return;
                    }
                    serverSocket = new ServerSocket(MiniServer.this.port);
                    System.out.println("waiting for connection on port: " + MiniServer.this.port);
                    socket = serverSocket.accept();
                    System.out.println("connected...");
                    System.out.println("" + socket.getInputStream().read());
                    socket.getOutputStream().write(33);
                    latch.countDown();
                    socket.close();
                    serverSocket.close();
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        if (serverSocket != null) {
                            serverSocket.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
                System.exit(1);
            }
        }
    }
}

