/*
 * Decompiled with CFR 0.152.
 */
package anyhwheresoftware.b4a.objects.sqlcipher;

import android.content.Context;
import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.sql.SQL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sqlcipher.Cursor;
import net.sqlcipher.DatabaseUtils;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteProgram;
import net.sqlcipher.database.SQLiteStatement;

@BA.ShortName(value="SQLCipher")
@BA.Version(value=1.5f)
public class SQLCipher
extends SQL {
    private SQLiteDatabase db;
    private volatile ArrayList<Object[]> nonQueryStatementsList = new ArrayList();

    private static SQLCipher cloneMe(SQLCipher sQLCipher) {
        SQLCipher sQLCipher2 = new SQLCipher();
        sQLCipher2.db = sQLCipher.db;
        sQLCipher2.nonQueryStatementsList = sQLCipher.nonQueryStatementsList;
        return sQLCipher2;
    }

    public void Initialize(String string, String string2, boolean bl, String string3, String string4) throws IOException, InterruptedException {
        SQLiteDatabase.loadLibs((Context)BA.applicationContext);
        this.db = SQLiteDatabase.openDatabase((String)new File(string, string2).toString(), (String)string3, null, (int)((bl ? 0x10000000 : 0) | 0x10));
    }

    private void checkNull() {
        if (this.db == null) {
            throw new RuntimeException("Object should first be initialized.");
        }
    }

    public boolean IsInitialized() {
        if (this.db == null) {
            return false;
        }
        return this.db.isOpen();
    }

    public void ExecNonQuery(String string) {
        this.checkNull();
        this.db.execSQL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ExecNonQuery2(String string, List list) {
        this.checkNull();
        try (SQLiteStatement sQLiteStatement = this.db.compileStatement(string);){
            int n = list.getSize();
            for (int i = 0; i < n; ++i) {
                DatabaseUtils.bindObjectToProgram((SQLiteProgram)sQLiteStatement, (int)(i + 1), (Object)list.Get(i));
            }
            sQLiteStatement.execute();
        }
    }

    public void AddNonQueryToBatch(String string, List list) {
        this.nonQueryStatementsList.add(new Object[]{string, list});
    }

    public Object ExecNonQueryBatch(final BA bA, final String string) {
        final ArrayList<Object[]> arrayList = this.nonQueryStatementsList;
        this.nonQueryStatementsList = new ArrayList();
        final SQLCipher sQLCipher = SQLCipher.cloneMe(this);
        BA.submitRunnable((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SQLiteDatabase sQLiteDatabase = SQLCipher.this.db;
                synchronized (sQLiteDatabase) {
                    try {
                        SQLCipher.this.BeginTransaction();
                        for (Object[] objectArray : arrayList) {
                            SQLCipher.this.ExecNonQuery2((String)objectArray[0], (List)objectArray[1]);
                        }
                        SQLCipher.this.TransactionSuccessful();
                        SQLCipher.this.EndTransaction();
                        bA.raiseEventFromDifferentThread((Object)sQLCipher, (Object)SQLCipher.this, 0, string.toLowerCase(BA.cul) + "_nonquerycomplete", true, new Object[]{true});
                    }
                    catch (Exception exception) {
                        SQLCipher.this.EndTransaction();
                        exception.printStackTrace();
                        bA.setLastException(exception);
                        bA.raiseEventFromDifferentThread((Object)sQLCipher, (Object)SQLCipher.this, 0, string.toLowerCase(BA.cul) + "_nonquerycomplete", true, new Object[]{false});
                    }
                }
            }
        }, (Object)((Object)this), (int)1);
        return sQLCipher;
    }

    public Object ExecQueryAsync(final BA bA, final String string, final String string2, final List list) {
        final SQLCipher sQLCipher = SQLCipher.cloneMe(this);
        BA.submitRunnable((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SQLiteDatabase sQLiteDatabase = SQLCipher.this.db;
                synchronized (sQLiteDatabase) {
                    try {
                        String[] stringArray = null;
                        if (list != null && list.IsInitialized()) {
                            stringArray = new String[list.getSize()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                Object object = list.Get(i);
                                stringArray[i] = object == null ? null : String.valueOf(object);
                            }
                        }
                        android.database.Cursor cursor = SQLCipher.this.ExecQuery2(string2, stringArray);
                        bA.raiseEventFromDifferentThread((Object)sQLCipher, (Object)SQLCipher.this, 0, string.toLowerCase(BA.cul) + "_querycomplete", true, new Object[]{true, AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new SQL.ResultSetWrapper(), (Object)cursor)});
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        bA.setLastException(exception);
                        bA.raiseEventFromDifferentThread((Object)sQLCipher, (Object)SQLCipher.this, 0, string.toLowerCase(BA.cul) + "_querycomplete", true, new Object[]{false, AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new SQL.ResultSetWrapper(), null)});
                    }
                }
            }
        }, (Object)((Object)this), (int)0);
        return sQLCipher;
    }

    public android.database.Cursor ExecQuery(String string) {
        this.checkNull();
        return this.ExecQuery2(string, null);
    }

    public android.database.Cursor ExecQuery2(String string, String[] stringArray) {
        this.checkNull();
        return this.db.rawQuery(string, stringArray);
    }

    public String ExecQuerySingleResult(String string) {
        return this.ExecQuerySingleResult2(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ExecQuerySingleResult2(String string, String[] stringArray) {
        this.checkNull();
        try (Cursor cursor = this.db.rawQuery(string, stringArray);){
            if (!cursor.moveToFirst()) {
                String string2 = null;
                return string2;
            }
            if (cursor.getColumnCount() == 0) {
                String string3 = null;
                return string3;
            }
            String string4 = cursor.getString(0);
            return string4;
        }
    }

    public void BeginTransaction() {
        this.checkNull();
        this.db.beginTransaction();
    }

    public void TransactionSuccessful() {
        this.db.setTransactionSuccessful();
    }

    public void EndTransaction() {
        this.db.endTransaction();
    }

    public void Close() {
        if (this.db != null && this.db.isOpen()) {
            this.db.close();
        }
    }
}

