/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.database;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.lang.reflect.Constructor;
import org.greenrobot.greendao.DaoException;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.StandardDatabase;

public abstract class DatabaseOpenHelper
extends SQLiteOpenHelper {
    private final Context context;
    private final String name;
    private final int version;
    private EncryptedHelper encryptedHelper;
    private boolean loadSQLCipherNativeLibs = true;

    public DatabaseOpenHelper(Context context, String name, int version) {
        this(context, name, null, version);
    }

    public DatabaseOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.context = context;
        this.name = name;
        this.version = version;
    }

    @SuppressLint(value={"NewApi"})
    public DatabaseOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
        super(context, name, factory, version, errorHandler);
        this.context = context;
        this.name = name;
        this.version = version;
    }

    public void setLoadSQLCipherNativeLibs(boolean loadSQLCipherNativeLibs) {
        this.loadSQLCipherNativeLibs = loadSQLCipherNativeLibs;
    }

    public Database getWritableDb() {
        return this.wrap(this.getWritableDatabase());
    }

    public Database getReadableDb() {
        return this.wrap(this.getReadableDatabase());
    }

    protected Database wrap(SQLiteDatabase sqLiteDatabase) {
        return new StandardDatabase(sqLiteDatabase);
    }

    public void onCreate(SQLiteDatabase db) {
        this.onCreate(this.wrap(db));
    }

    public void onCreate(Database db) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(this.wrap(db), oldVersion, newVersion);
    }

    public void onUpgrade(Database db, int oldVersion, int newVersion) {
    }

    public void onOpen(SQLiteDatabase db) {
        this.onOpen(this.wrap(db));
    }

    public void onOpen(Database db) {
    }

    private EncryptedHelper checkEncryptedHelper() {
        if (this.encryptedHelper == null) {
            try {
                Class.forName("net.sqlcipher.database.SQLiteOpenHelper");
            }
            catch (ClassNotFoundException e) {
                throw new DaoException("Using an encrypted database requires SQLCipher, make sure to add it to dependencies: https://greenrobot.org/greendao/documentation/database-encryption/");
            }
            try {
                Class<?> helperClass = Class.forName("org.greenrobot.greendao.database.SqlCipherEncryptedHelper");
                Constructor<?> constructor = helperClass.getConstructor(DatabaseOpenHelper.class, Context.class, String.class, Integer.TYPE, Boolean.TYPE);
                this.encryptedHelper = (EncryptedHelper)constructor.newInstance(new Object[]{this, this.context, this.name, this.version, this.loadSQLCipherNativeLibs});
            }
            catch (Exception e) {
                throw new DaoException(e);
            }
        }
        return this.encryptedHelper;
    }

    public Database getEncryptedWritableDb(String password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedWritableDb(password);
    }

    public Database getEncryptedWritableDb(char[] password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedWritableDb(password);
    }

    public Database getEncryptedReadableDb(String password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedReadableDb(password);
    }

    public Database getEncryptedReadableDb(char[] password) {
        EncryptedHelper encryptedHelper = this.checkEncryptedHelper();
        return encryptedHelper.getEncryptedReadableDb(password);
    }

    static interface EncryptedHelper {
        public Database getEncryptedReadableDb(String var1);

        public Database getEncryptedReadableDb(char[] var1);

        public Database getEncryptedWritableDb(String var1);

        public Database getEncryptedWritableDb(char[] var1);
    }
}

