/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.query;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.query.AbstractQuery;

abstract class AbstractQueryData<T, Q extends AbstractQuery<T>> {
    final String sql;
    final AbstractDao<T, ?> dao;
    final String[] initialValues;
    final Map<Long, WeakReference<Q>> queriesForThreads;

    AbstractQueryData(AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        this.dao = dao;
        this.sql = sql;
        this.initialValues = initialValues;
        this.queriesForThreads = new HashMap<Long, WeakReference<Q>>();
    }

    Q forCurrentThread(Q query) {
        if (Thread.currentThread() == ((AbstractQuery)query).ownerThread) {
            System.arraycopy(this.initialValues, 0, ((AbstractQuery)query).parameters, 0, this.initialValues.length);
            return query;
        }
        return this.forCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Q forCurrentThread() {
        long threadId = Thread.currentThread().getId();
        Map<Long, WeakReference<Q>> map = this.queriesForThreads;
        synchronized (map) {
            AbstractQuery<Object> query;
            WeakReference<Q> queryRef = this.queriesForThreads.get(threadId);
            AbstractQuery abstractQuery = query = queryRef != null ? (AbstractQuery)queryRef.get() : null;
            if (query == null) {
                this.gc();
                query = this.createQuery();
                this.queriesForThreads.put(threadId, new WeakReference<AbstractQuery>(query));
            } else {
                System.arraycopy(this.initialValues, 0, query.parameters, 0, this.initialValues.length);
            }
            return (Q)query;
        }
    }

    protected abstract Q createQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gc() {
        Map<Long, WeakReference<Q>> map = this.queriesForThreads;
        synchronized (map) {
            Iterator<Map.Entry<Long, WeakReference<Q>>> iterator = this.queriesForThreads.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, WeakReference<Q>> entry = iterator.next();
                if (entry.getValue().get() != null) continue;
                iterator.remove();
            }
        }
    }
}

