/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.greendao.rx;

import java.util.List;
import java.util.concurrent.Callable;
import org.greenrobot.greendao.annotation.apihint.Experimental;
import org.greenrobot.greendao.query.LazyList;
import org.greenrobot.greendao.query.Query;
import org.greenrobot.greendao.rx.RxBase;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.exceptions.Exceptions;

@Experimental
public class RxQuery<T>
extends RxBase {
    private final Query<T> query;

    public RxQuery(Query<T> query) {
        this.query = query;
    }

    public RxQuery(Query<T> query, Scheduler scheduler) {
        super(scheduler);
        this.query = query;
    }

    @Experimental
    public Observable<List<T>> list() {
        return this.wrap(new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                return RxQuery.this.query.forCurrentThread().list();
            }
        });
    }

    @Experimental
    public Observable<T> unique() {
        return this.wrap(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RxQuery.this.query.forCurrentThread().unique();
            }
        });
    }

    public Observable<T> oneByOne() {
        Observable observable = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(Subscriber<? super T> subscriber) {
                try {
                    try (LazyList lazyList = RxQuery.this.query.forCurrentThread().listLazyUncached();){
                        for (Object entity : lazyList) {
                            if (subscriber.isUnsubscribed()) {
                                break;
                            }
                            subscriber.onNext(entity);
                        }
                    }
                    if (!subscriber.isUnsubscribed()) {
                        subscriber.onCompleted();
                    }
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    subscriber.onError(e);
                }
            }
        });
        return this.wrap(observable);
    }
}

