/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.analytics.core.crypto;

import com.huawei.hms.analytics.core.crypto.HexUtil;
import com.huawei.hms.analytics.core.log.HiLog;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCipher {
    public static final Charset a = Charset.forName("UTF-8");

    public static String getGCMIv(String string) {
        if (string == null || string.length() < 24) {
            HiLog.e("AesCipher", "IV is invalid.");
            return "";
        }
        return string.substring(0, 24);
    }

    public static String getCBCIv(String string) {
        if (string == null || string.length() < 32) {
            HiLog.e("AesCipher", "cbc IV is invalid.");
            return "";
        }
        return string.substring(0, 32);
    }

    public static String getCbcEncryptWord(String string) {
        if (string == null || string.length() < 32) {
            return "";
        }
        return string.substring(32);
    }

    public static String getEncryptWord(String string) {
        if (string == null || string.length() < 24) {
            return "";
        }
        return string.substring(24);
    }

    public static String gcmEncrypt(String string, String object, AlgorithmParameterSpec algorithmParameterSpec) {
        if (string == null || string.isEmpty() || object == null) {
            HiLog.e("AesCipher", "content or key is not right");
            return "";
        }
        if (algorithmParameterSpec == null) {
            HiLog.e("AesCipher", "ivParameterSpec is null");
            return "";
        }
        byte[] byArray = HexUtil.hexString2ByteArray((String)object);
        object = byArray;
        if (byArray.length < 16) {
            HiLog.e("AesCipher", "key length is not right");
            return "";
        }
        object = new SecretKeySpec((byte[])object, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, (Key)object, algorithmParameterSpec);
            return HexUtil.byteArray2HexString(cipher.doFinal(string.getBytes(a)));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            HiLog.e("AesCipher", "InvalidAlgorithmParameterException gcmEncrypt: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException gcmEncrypt: " + noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException gcmEncrypt: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException gcmEncrypt: " + invalidKeyException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException gcmEncrypt: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException gcmEncrypt: " + illegalBlockSizeException.getMessage());
        }
        return "";
    }

    public static String gcmDecrypt(String object, String object2, AlgorithmParameterSpec algorithmParameterSpec) {
        if (object == null || ((String)object).isEmpty() || object2 == null) {
            HiLog.e("AesCipher", "gcmDecrypt : content or key is not right");
            return "";
        }
        byte[] byArray = HexUtil.hexString2ByteArray((String)object2);
        object2 = byArray;
        if (byArray.length < 16) {
            HiLog.e("AesCipher", "key length is not right");
            return "";
        }
        object2 = new SecretKeySpec((byte[])object2, "AES");
        object = HexUtil.hexString2ByteArray((String)object);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)object2, algorithmParameterSpec);
            return new String(cipher.doFinal((byte[])object), a);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            HiLog.e("AesCipher", "InvalidAlgorithmParameterException gcmDecrypt: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException gcmDecrypt: " + noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException gcmDecrypt: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException gcmDecrypt: " + invalidKeyException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException gcmDecrypt: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException gcmDecrypt: " + illegalBlockSizeException.getMessage());
        }
        return "";
    }

    public static String gcmEncrypt(SecretKey object, String object2) {
        if (object == null) {
            HiLog.e("AesCipher", "Encrypt secret key is null");
            return "";
        }
        if (object2 == null || ((String)object2).isEmpty()) {
            HiLog.e("AesCipher", "encrypt content is null or empty");
            return "";
        }
        try {
            Object object3 = Cipher.getInstance("AES/GCM/NoPadding");
            ((Cipher)object3).init(1, (Key)object);
            object = ((Cipher)object3).doFinal(((String)object2).getBytes(a));
            byte[] byArray = ((Cipher)object3).getIV();
            object2 = byArray;
            if (byArray == null || ((Object)object2).length != 12) {
                HiLog.e("AesCipher", "IV is invalid");
                return "";
            }
            Object object4 = object2;
            object3 = Arrays.copyOf((byte[])object4, ((Object)object4).length + ((Object)object).length);
            System.arraycopy(object, 0, object3, ((Object)object2).length, ((Object)object).length);
            return HexUtil.byteArray2HexString((byte[])object3);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException gcmEncryptKs: " + noSuchPaddingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException gcmEncryptKs: " + noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException gcmEncryptKs:" + invalidKeyException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException gcmEncryptKs: " + badPaddingException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException gcmEncryptKs: " + illegalBlockSizeException.getMessage());
        }
        return "";
    }

    public static String gcmDecrypt(SecretKey object, String object2) {
        if (object == null || object2 == null || ((String)object2).isEmpty()) {
            HiLog.e("AesCipher", "gcmDecrypt : secretKey or enContent is null");
            return "";
        }
        try {
            byte[] byArray = HexUtil.hexString2ByteArray((String)object2);
            object2 = byArray;
            if (byArray.length <= 12) {
                HiLog.e("AesCipher", "Decrypt source data is invalid.");
                return "";
            }
            Object object3 = Arrays.copyOf((byte[])object2, 12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            object3 = new GCMParameterSpec(128, (byte[])object3);
            cipher.init(2, (Key)object, (AlgorithmParameterSpec)object3);
            object = cipher.doFinal((byte[])object2, 12, ((Object)object2).length - 12);
            return new String((byte[])object, a);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException gcmDecryptKs: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException gcmDecryptKs: " + noSuchPaddingException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException gcmDecryptKs: " + invalidKeyException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            HiLog.e("AesCipher", "InvalidAlgorithmParameterException gcmDecryptKs: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException gcmDecryptKs: " + illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException gcmDecryptKs: " + badPaddingException.getMessage());
        }
        return "";
    }

    public static AlgorithmParameterSpec getSpec(byte[] byArray, boolean bl) {
        if (!bl) {
            return new IvParameterSpec(byArray);
        }
        return new GCMParameterSpec(128, byArray);
    }

    public static String encryptCbc(String string, String object) {
        if (string == null || string.isEmpty() || object == null) {
            HiLog.e("AesCipher", "cbc encrypt param is not right");
            return "";
        }
        byte[] byArray = HexUtil.hexString2ByteArray((String)object);
        object = byArray;
        if (byArray.length < 16) {
            HiLog.e("AesCipher", "key length is not right");
            return "";
        }
        return AesCipher.a(string.getBytes(a), (byte[])object);
    }

    public static String encryptCbc(byte[] byArray, String object) {
        if (byArray == null || byArray.length == 0 || object == null) {
            HiLog.e("AesCipher", "cbc encrypt(byte) param is not right");
            return "";
        }
        byte[] byArray2 = HexUtil.hexString2ByteArray((String)object);
        object = byArray2;
        if (byArray2.length < 16) {
            HiLog.e("AesCipher", "key length is not right");
            return "";
        }
        return AesCipher.a(byArray, (byte[])object);
    }

    private static String a(byte[] object, byte[] object2) {
        object2 = new SecretKeySpec((byte[])object2, "AES");
        try {
            byte[] byArray = HexUtil.initRandomByte(16);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(1, (Key)object2, ivParameterSpec);
            String string = HexUtil.byteArray2HexString(cipher.doFinal((byte[])object));
            object = string;
            if (string.isEmpty()) {
                return "";
            }
            return HexUtil.byteArray2HexString(byArray) + (String)object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException encryptCBC: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException encryptCBC: " + noSuchPaddingException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException encryptCBC: " + invalidKeyException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            HiLog.e("AesCipher", "InvalidAlgorithmParameterException encryptCBC: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException encryptCBC: " + illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException encryptCBC: " + badPaddingException.getMessage());
        }
        return "";
    }

    public static String decryptCbc(String string, String object) {
        if (string == null || string.isEmpty() || object == null) {
            HiLog.e("AesCipher", "cbc decrypt param is not right");
            return "";
        }
        byte[] byArray = HexUtil.hexString2ByteArray((String)object);
        object = byArray;
        if (byArray.length < 16) {
            HiLog.e("AesCipher", "key length is not right");
            return "";
        }
        String string2 = AesCipher.getCBCIv(string);
        return AesCipher.a(AesCipher.getCbcEncryptWord(string), (byte[])object, string2);
    }

    private static String a(String string, byte[] object, String object2) {
        if (string.isEmpty() || ((String)object2).isEmpty()) {
            return "";
        }
        object = new SecretKeySpec((byte[])object, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            object2 = new IvParameterSpec(HexUtil.hexString2ByteArray((String)object2));
            cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
            return new String(cipher.doFinal(HexUtil.hexString2ByteArray(string)), a);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException decryptCBC: " + noSuchAlgorithmException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException decryptCBC: " + illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException decryptCBC: " + badPaddingException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException decryptCBC: " + noSuchPaddingException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException decryptCBC: " + invalidKeyException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            HiLog.e("AesCipher", "InvalidAlgorithmParameterException decryptCBC: " + invalidAlgorithmParameterException.getMessage());
        }
        return "";
    }

    public static String encrypt(String object, byte[] object2) {
        HiLog.i("AesCipher", "aes encrypt begin 2");
        if (object == null || ((String)object).isEmpty() || object2 == null || ((byte[])object2).length < 16) {
            HiLog.e("AesCipher", "cbc encrypt param is not right");
            return "";
        }
        byte[] byArray = HexUtil.initRandomByte(16);
        object = ((String)object).getBytes(a);
        object2 = new SecretKeySpec((byte[])object2, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(1, (Key)object2, ivParameterSpec);
            object = HexUtil.byteArray2HexString(cipher.doFinal((byte[])object));
            if (((String)object).isEmpty()) {
                return "";
            }
            return HexUtil.byteArray2HexString(byArray) + (String)object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            HiLog.e("AesCipher", "NoSuchAlgorithmException encryptCBC: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            HiLog.e("AesCipher", "NoSuchPaddingException encryptCBC: " + noSuchPaddingException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            HiLog.e("AesCipher", "InvalidKeyException encryptCBC: " + invalidKeyException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            HiLog.e("AesCipher", "InvalidAlgorithmParameterException encryptCBC: " + invalidAlgorithmParameterException.getMessage());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            HiLog.e("AesCipher", "IllegalBlockSizeException encryptCBC: " + illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            HiLog.e("AesCipher", "BadPaddingException encryptCBC: " + badPaddingException.getMessage());
        }
        return "";
    }

    public static interface AesLen {
        public static final int AES_GCM_IV_LEN = 12;
        public static final int AES_128_CBC_KEY_LEN = 16;
        public static final int AES_128_CBC_IV_LEN = 16;
        public static final int ROOTKEY_COMPONET_LEN = 128;
    }
}

