/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.analytics.core.crypto;

import com.huawei.hms.analytics.core.log.HiLog;
import java.security.SecureRandom;
import java.util.Locale;

public abstract class HexUtil {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String byteArray2HexString(byte[] byArray) {
        if (byArray == null || 0 == byArray.length) {
            HiLog.w("HexUtil", "byteArray is empty");
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(a[(by & 0xF0) >> 4]).append(a[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String initRandomKey(int n) {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = new byte[n];
            secureRandom.nextBytes(byArray);
            return HexUtil.byteArray2HexString(byArray);
        }
        catch (Exception exception) {
            HiLog.e("EncryptUtil", "generate secure random error: " + exception.getMessage());
            return "";
        }
    }

    public static byte[] initRandomByte(int n) {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray = new byte[n];
            secureRandom.nextBytes(byArray);
            return byArray;
        }
        catch (Exception exception) {
            HiLog.e("EncryptUtil", "generate secure random error" + exception.getMessage());
            return new byte[0];
        }
    }

    public static byte[] hexString2ByteArray(String object) {
        if (object == null || ((String)object).length() == 0) {
            return new byte[0];
        }
        object = ((String)object).toUpperCase(Locale.ENGLISH);
        int n = ((String)object).length() / 2;
        object = ((String)object).toCharArray();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            if (n2 >= 0 && n2 < ((Object)object).length - 1) {
                Object object2 = object[n2];
                int n3 = (byte)"0123456789ABCDEF".indexOf((int)object2) << 4;
                object2 = object[n2 + 1];
                byArray[i] = (byte)(n3 | (byte)"0123456789ABCDEF".indexOf((int)object2));
                continue;
            }
            HiLog.e("HexUtil", "char error");
        }
        return byArray;
    }
}

