/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.analytics.core.transport.net;

import com.huawei.hms.analytics.core.log.HiLog;
import com.huawei.hms.analytics.core.transport.ITransportHandler;
import com.huawei.hms.analytics.core.transport.a;
import com.huawei.hms.analytics.core.transport.net.Response;
import com.huawei.hms.analytics.core.transport.net.f;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;

public class HttpTransportHandler
implements ITransportHandler {
    private static final String TAG = "HttpTransportCommander";
    private static final int RECONNECTION_TIMES = 3;
    private String[] collectURLs;
    private byte[] reportData;
    private Map<String, String> headers;
    private String caPath;
    private ITransportHandler.Protocols protocol;
    private boolean isHighCiphers;
    private HttpURLConnection connection;

    @Override
    public void setUrls(String[] stringArray) {
        this.collectURLs = stringArray != null ? (String[])stringArray.clone() : null;
    }

    @Override
    public void setReportData(String string) {
    }

    @Override
    public void setReportData(byte[] byArray) {
        this.reportData = byArray != null ? (byte[])byArray.clone() : new byte[]{};
    }

    @Override
    public void setHttpHeaders(Map<String, String> map) {
        this.headers = map;
    }

    @Override
    public void setSSLConfig(ITransportHandler.Protocols protocols, String string, boolean bl) {
        this.caPath = string;
        this.protocol = protocols;
        this.isHighCiphers = bl;
    }

    @Override
    public void execute(final a a2) {
        new Thread(new Runnable(){

            @Override
            public final void run() {
                Response response;
                if (a2 != null && 200 != (response = HttpTransportHandler.this.execute()).getHttpCode()) {
                    response.getHttpCode();
                }
            }
        }).start();
    }

    @Override
    public Response execute() {
        if (this.collectURLs == null || this.collectURLs.length == 0) {
            HiLog.e(TAG, "collectUrls is empty");
            return new Response(-100, "");
        }
        int n = 0;
        Response response = null;
        while (response == null || response.getHttpCode() == -104 && n < this.collectURLs.length) {
            HttpTransportHandler httpTransportHandler = this;
            response = httpTransportHandler.reconnection(httpTransportHandler.collectURLs[n]);
            HiLog.d(TAG, "request times: ".concat(String.valueOf(++n)));
        }
        return response;
    }

    private Response reconnection(String string) {
        Response response = new Response(-108, "");
        for (int i = 0; i < 3; ++i) {
            try {
                return this.post(string);
            }
            catch (Exception exception) {
                response = this.handlerException(exception);
                if (response.getHttpCode() == -104) continue;
                return response;
            }
        }
        return response;
    }

    private Response post(String object) {
        Response response;
        this.createConnection((String)object);
        object = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            if (this.reportData != null && this.reportData.length > 0) {
                object = this.connection.getOutputStream();
                bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                bufferedOutputStream.write(this.reportData);
                bufferedOutputStream.flush();
            } else {
                HiLog.i(TAG, "report data is empty");
            }
            int n = this.connection.getResponseCode();
            String string = this.readResponse();
            response = new Response(n, string);
        }
        catch (Throwable throwable) {
            f.a(bufferedOutputStream);
            f.a((Closeable)object);
            this.closeConnection();
            throw throwable;
        }
        f.a(bufferedOutputStream);
        f.a((Closeable)object);
        this.closeConnection();
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readResponse() {
        Object object;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            inputStream = this.connection.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[1024];
            while ((n = inputStream.read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            object = byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            try {
                HiLog.e(TAG, "IOException: " + iOException.getMessage());
            }
            catch (Throwable throwable) {
                f.a(byteArrayOutputStream);
                f.a(inputStream);
                throw throwable;
            }
            f.a(byteArrayOutputStream);
            f.a(inputStream);
            return "";
        }
        f.a(byteArrayOutputStream);
        f.a(inputStream);
        return object;
    }

    private void closeConnection() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private void createConnection(String object) {
        object = new URL((String)object);
        this.connection = (HttpURLConnection)((URL)object).openConnection();
        this.setHttpsConn();
        this.connection.setRequestMethod("POST");
        this.connection.setConnectTimeout(15000);
        this.connection.setReadTimeout(15000);
        this.connection.setDoOutput(true);
        this.connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        int n = this.reportData == null ? 0 : this.reportData.length;
        this.connection.setRequestProperty("Content-Length", String.valueOf(n));
        this.connection.setRequestProperty("Connection", "close");
        if (this.headers != null && this.headers.size() > 0) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String string = entry.getKey();
                if (string == null || string.isEmpty()) continue;
                this.connection.setRequestProperty(string, URLEncoder.encode(entry.getValue() == null ? "" : entry.getValue(), "UTF-8"));
            }
        }
    }

    private void setHttpsConn() {
        if (this.connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.connection;
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)com.huawei.hms.analytics.core.transport.net.a.a(this.caPath, this.protocol, this.isHighCiphers);
            if (sSLSocketFactory == null) {
                throw new com.huawei.hms.analytics.core.transport.a.a("No ssl socket factory set ");
            }
            httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
            httpsURLConnection.setHostnameVerifier(com.huawei.hms.analytics.core.transport.net.a.a);
        }
    }

    private Response handlerException(Exception exception) {
        if (exception instanceof SecurityException) {
            HiLog.e(TAG, "NE-003", "No Permission\uff1aINTERNET.");
            return new Response(-101, "");
        }
        if (exception instanceof SSLPeerUnverifiedException) {
            HiLog.e(TAG, "NE-002", "Certificate has not been verified,Request is restricted!");
            return new Response(-106, "");
        }
        if (exception instanceof SSLHandshakeException) {
            HiLog.e(TAG, "NE-002", "Chain validation failed,Certificate expired");
            return new Response(-109, "");
        }
        if (exception instanceof ConnectException) {
            HiLog.e(TAG, "NE-005", "Network is unreachable or Connection refused");
            return new Response(-103, "");
        }
        if (exception instanceof UnknownHostException) {
            HiLog.e(TAG, "NE-006", "Invalid URL.No address associated with hostname");
            return new Response(-104, "");
        }
        if (exception instanceof IOException) {
            HiLog.e(TAG, "NE-004", "IO Exception." + exception.getMessage());
            return new Response(-102, "");
        }
        if (exception instanceof com.huawei.hms.analytics.core.transport.a.a) {
            HiLog.e(TAG, "NE-001", "SSLConfigException:" + exception.getMessage());
            return new Response(-105, "");
        }
        HiLog.e(TAG, "other exception");
        return new Response(-108, "");
    }
}

