/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.libgdx.graphics;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgPixmap;
import anywheresoftware.b4a.libgdx.graphics.lgTexture;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;

@BA.ShortName(value="lgFrameBuffer")
public class lgFrameBuffer {
    private GLFrameBuffer a = null;
    public static final Pixmap.Format FORMAT_RGB565 = Pixmap.Format.RGB565;
    public static final Pixmap.Format FORMAT_RGBA4444 = Pixmap.Format.RGBA4444;
    public static final Pixmap.Format FORMAT_RGB888 = Pixmap.Format.RGB888;
    public static final Pixmap.Format FORMAT_RGBA8888 = Pixmap.Format.RGBA8888;

    public void Initialize(Pixmap.Format Format2, int Width, int Height) {
        if (this.IsInitialized()) {
            throw new RuntimeException("FrameBuffer already initialized.");
        }
        this.a = new GLFrameBuffer(Format2, Width, Height, false);
    }

    public void InitializeWithDepthBufferAttached(Pixmap.Format Format2, int Width, int Height) {
        if (this.IsInitialized()) {
            throw new RuntimeException("FrameBuffer already initialized.");
        }
        this.a = new GLFrameBuffer(Format2, Width, Height, true);
    }

    public boolean IsInitialized() {
        return this.a != null;
    }

    public void Bind() {
        this.a.bind();
    }

    public static void Unbind() {
        GLFrameBuffer.unbind();
    }

    public void Begin() {
        this.a.begin();
    }

    public void End() {
        this.a.end();
    }

    public void End2(int X, int Y, int Width, int Height) {
        this.a.end(X, Y, Width, Height);
    }

    public lgTexture getColorBufferTexture() {
        return new lgTexture(this.a.getColorBufferTexture());
    }

    public int getHeight() {
        return this.a.getHeight();
    }

    public int getWidth() {
        return this.a.getWidth();
    }

    public static String getManagedStatus() {
        return GLFrameBuffer.getManagedStatus();
    }

    public static byte[] GetDefaultFrameBufferPixels(int X, int Y, int Width, int Height, boolean FlipY) {
        Gdx.gl.glPixelStorei(3333, 1);
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(Width * Height * 4);
        Gdx.gl.glReadPixels(X, Y, Width, Height, 6408, 5121, byteBuffer);
        byte[] byArray = new byte[Width * Height * 4];
        if (FlipY) {
            int n = Width * 4;
            int n2 = 0;
            while (n2 < Height) {
                byteBuffer.position((Height - n2 - 1) * n);
                byteBuffer.get(byArray, n2 * n, n);
                ++n2;
            }
        } else {
            byteBuffer.clear();
            byteBuffer.get(byArray);
        }
        return byArray;
    }

    public static lgPixmap GetDefaultFrameBufferPixmap(int X, int Y, int Width, int Height, boolean FlipY) {
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(Width, Height, Pixmap.Format.RGBA8888);
        ByteBuffer byteBuffer = pixmap.getPixels();
        Gdx.gl.glReadPixels(X, Y, Width, Height, 6408, 5121, byteBuffer);
        if (FlipY) {
            Pixmap pixmap2 = new Pixmap(Width, Height, pixmap.getFormat());
            int n = 0;
            while (n < Width) {
                int n2 = 0;
                while (n2 < Height) {
                    pixmap2.drawPixel(n, n2, pixmap.getPixel(n, Height - n2 - 1));
                    ++n2;
                }
                ++n;
            }
            pixmap.dispose();
            return new lgPixmap(pixmap2);
        }
        return new lgPixmap(pixmap);
    }

    public void dispose() {
        this.a.dispose();
        this.a = null;
    }

    public GLFrameBuffer getInternalObject() {
        return this.a;
    }
}

