/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class InputMultiplexer
implements InputProcessor {
    private Array<InputProcessor> a = new Array(4);

    public InputMultiplexer() {
    }

    public InputMultiplexer(InputProcessor ... processors) {
        int n = 0;
        while (n < processors.length) {
            this.a.add(processors[n]);
            ++n;
        }
    }

    public void addProcessor(int index, InputProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor cannot be null");
        }
        this.a.insert(index, processor);
    }

    public void removeProcessor(int index) {
        this.a.removeIndex(index);
    }

    public void addProcessor(InputProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor cannot be null");
        }
        this.a.add(processor);
    }

    public void removeProcessor(InputProcessor processor) {
        this.a.removeValue(processor, true);
    }

    public int size() {
        return this.a.size;
    }

    public void clear() {
        this.a.clear();
    }

    public void setProcessors(Array<InputProcessor> processors) {
        this.a = processors;
    }

    public Array<InputProcessor> getProcessors() {
        return this.a;
    }

    @Override
    public boolean keyDown(int keycode) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).keyDown(keycode)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).keyUp(keycode)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).keyTyped(character)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).touchDown(screenX, screenY, pointer, button)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).touchUp(screenX, screenY, pointer, button)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).touchDragged(screenX, screenY, pointer)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).mouseMoved(screenX, screenY)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        int n = 0;
        int n2 = this.a.size;
        while (n < n2) {
            if (this.a.get(n).scrolled(amount)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

