/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetErrorListener;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.RefCountedContainer;
import com.badlogic.gdx.assets.a;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.BitmapFontLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.MusicLoader;
import com.badlogic.gdx.assets.loaders.ParticleEffectLoader;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.assets.loaders.SoundLoader;
import com.badlogic.gdx.assets.loaders.TextureAtlasLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.backends.android.AndroidMusic;
import com.badlogic.gdx.backends.android.AndroidSound;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonRegionLoader;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Logger;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.async.AsyncExecutor;
import com.badlogic.gdx.utils.async.ThreadUtils;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import java.util.Stack;

@BA.Hide
public class AssetManager
implements Disposable {
    private ObjectMap<Class, ObjectMap<String, RefCountedContainer>> b = new ObjectMap();
    private ObjectMap<String, Class> c = new ObjectMap();
    private ObjectMap<String, Array<String>> d = new ObjectMap();
    private ObjectSet<String> e = new ObjectSet();
    private ObjectMap<Class, ObjectMap<String, AssetLoader>> f = new ObjectMap();
    private Array<AssetDescriptor> g = new Array();
    private AsyncExecutor h;
    private Stack<a> i = new Stack();
    private AssetErrorListener j = null;
    private int k = 0;
    private int l = 0;
    private int m = 0;
    private FileHandleResolver n;
    Logger a = new Logger("AssetManager", 0);

    public AssetManager() {
        this(new InternalFileHandleResolver());
    }

    public AssetManager(FileHandleResolver resolver) {
        this(resolver, true);
    }

    public AssetManager(FileHandleResolver resolver, boolean defaultLoaders) {
        this.n = resolver;
        if (defaultLoaders) {
            this.setLoader(BitmapFont.class, new BitmapFontLoader(resolver));
            this.setLoader(AndroidMusic.class, new MusicLoader(resolver));
            this.setLoader(Pixmap.class, new PixmapLoader(resolver));
            this.setLoader(AndroidSound.class, new SoundLoader(resolver));
            this.setLoader(TextureAtlas.class, new TextureAtlasLoader(resolver));
            this.setLoader(Texture.class, new TextureLoader(resolver));
            this.setLoader(ParticleEffect.class, new ParticleEffectLoader(resolver));
            this.setLoader(PolygonRegion.class, new PolygonRegionLoader(resolver));
        }
        this.h = new AsyncExecutor(1);
    }

    public FileHandleResolver getFileHandleResolver() {
        return this.n;
    }

    public synchronized <T> T get(String fileName) {
        Class clazz = this.c.get(fileName);
        if (clazz == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        ObjectMap<String, RefCountedContainer> objectMap = this.b.get(clazz);
        if (objectMap == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        RefCountedContainer refCountedContainer = objectMap.get(fileName);
        if (refCountedContainer == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        Object t = refCountedContainer.getObject(clazz);
        if (t == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        return t;
    }

    public synchronized <T> T get(String fileName, Class<T> type) {
        ObjectMap<String, RefCountedContainer> objectMap = this.b.get(type);
        if (objectMap == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        RefCountedContainer refCountedContainer = objectMap.get(fileName);
        if (refCountedContainer == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        T t = refCountedContainer.getObject(type);
        if (t == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        return t;
    }

    public synchronized <T> Array<T> getAll(Class<T> type, Array<T> out) {
        ObjectMap<String, RefCountedContainer> objectMap = this.b.get(type);
        if (objectMap != null) {
            for (ObjectMap.Entry entry : objectMap.entries()) {
                out.add(((RefCountedContainer)entry.value).getObject(type));
            }
        }
        return out;
    }

    public synchronized <T> T get(AssetDescriptor<T> assetDescriptor) {
        return this.get(assetDescriptor.fileName, assetDescriptor.type);
    }

    public synchronized void unload(String fileName) {
        if (this.i.size() > 0) {
            a a2 = (a)this.i.firstElement();
            if (a2.a.fileName.equals(fileName)) {
                a2.f = true;
                this.a.debug("Unload (from tasks): ".concat(String.valueOf(fileName)));
                return;
            }
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.g.size) {
            if (this.g.get((int)n2).fileName.equals(fileName)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            --this.l;
            this.g.removeIndex(n);
            this.a.debug("Unload (from queue): ".concat(String.valueOf(fileName)));
            return;
        }
        Class clazz = this.c.get(fileName);
        if (clazz == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        RefCountedContainer refCountedContainer = this.b.get(clazz).get(fileName);
        refCountedContainer.decRefCount();
        if (refCountedContainer.getRefCount() <= 0) {
            this.a.debug("Unload (dispose): ".concat(String.valueOf(fileName)));
            if (refCountedContainer.getObject(Object.class) instanceof Disposable) {
                ((Disposable)refCountedContainer.getObject(Object.class)).dispose();
            }
            this.c.remove(fileName);
            this.b.get(clazz).remove(fileName);
        } else {
            this.a.debug("Unload (decrement): ".concat(String.valueOf(fileName)));
        }
        Array<String> array = this.d.get(fileName);
        if (array != null) {
            for (String string : array) {
                if (!this.isLoaded(string)) continue;
                this.unload(string);
            }
        }
        if (refCountedContainer.getRefCount() <= 0) {
            this.d.remove(fileName);
        }
    }

    public synchronized <T> boolean containsAsset(T asset) {
        ObjectMap<String, RefCountedContainer> objectMap = this.b.get(asset.getClass());
        if (objectMap == null) {
            return false;
        }
        for (String string : objectMap.keys()) {
            Object object = objectMap.get(string).getObject(Object.class);
            if (object != asset && !asset.equals(object)) continue;
            return true;
        }
        return false;
    }

    public synchronized <T> String getAssetFileName(T asset) {
        for (Class clazz : this.b.keys()) {
            ObjectMap<String, RefCountedContainer> objectMap = this.b.get(clazz);
            for (String string : objectMap.keys()) {
                Object object = objectMap.get(string).getObject(Object.class);
                if (object != asset && !asset.equals(object)) continue;
                return string;
            }
        }
        return null;
    }

    public synchronized boolean isLoaded(String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.c.containsKey(fileName);
    }

    public synchronized boolean isLoaded(String fileName, Class type) {
        ObjectMap<String, RefCountedContainer> objectMap = this.b.get(type);
        if (objectMap == null) {
            return false;
        }
        RefCountedContainer refCountedContainer = objectMap.get(fileName);
        if (refCountedContainer == null) {
            return false;
        }
        return refCountedContainer.getObject(type) != null;
    }

    public <T> AssetLoader getLoader(Class<T> type) {
        return this.getLoader(type, null);
    }

    public <T> AssetLoader getLoader(Class<T> type, String fileName) {
        ObjectMap<String, AssetLoader> objectMap = this.f.get(type);
        if (objectMap == null || objectMap.size <= 0) {
            return null;
        }
        if (fileName == null) {
            return objectMap.get("");
        }
        AssetLoader assetLoader = null;
        int n = -1;
        for (ObjectMap.Entry entry : objectMap.entries()) {
            if (((String)entry.key).length() <= n || !fileName.endsWith((String)entry.key)) continue;
            assetLoader = (AssetLoader)entry.value;
            n = ((String)entry.key).length();
        }
        return assetLoader;
    }

    public synchronized <T> void load(String fileName, Class<T> type) {
        this.load(fileName, type, null);
    }

    public synchronized <T> void load(String fileName, Class<T> type, AssetLoaderParameters<T> parameter) {
        AssetDescriptor<T> assetDescriptor;
        if (this.getLoader(type, fileName) == null) {
            throw new GdxRuntimeException("No loader for type: " + ClassReflection.getSimpleName(type));
        }
        if (this.g.size == 0) {
            this.k = 0;
            this.l = 0;
            this.m = 0;
        }
        int n = 0;
        while (n < this.g.size) {
            assetDescriptor = this.g.get(n);
            if (assetDescriptor.fileName.equals(fileName) && !assetDescriptor.type.equals(type)) {
                throw new GdxRuntimeException("Asset with name '" + fileName + "' already in preload queue, but has different type (expected: " + ClassReflection.getSimpleName(type) + ", found: " + ClassReflection.getSimpleName(assetDescriptor.type) + ")");
            }
            ++n;
        }
        n = 0;
        while (n < this.i.size()) {
            assetDescriptor = ((a)this.i.get((int)n)).a;
            if (assetDescriptor.fileName.equals(fileName) && !assetDescriptor.type.equals(type)) {
                throw new GdxRuntimeException("Asset with name '" + fileName + "' already in task list, but has different type (expected: " + ClassReflection.getSimpleName(type) + ", found: " + ClassReflection.getSimpleName(assetDescriptor.type) + ")");
            }
            ++n;
        }
        Class clazz = this.c.get(fileName);
        if (clazz != null && !clazz.equals(type)) {
            throw new GdxRuntimeException("Asset with name '" + fileName + "' already loaded, but has different type (expected: " + ClassReflection.getSimpleName(type) + ", found: " + ClassReflection.getSimpleName(clazz) + ")");
        }
        ++this.l;
        assetDescriptor = new AssetDescriptor<T>(fileName, type, parameter);
        this.g.add(assetDescriptor);
        this.a.debug("Queued: ".concat(String.valueOf(assetDescriptor)));
    }

    public synchronized void load(AssetDescriptor desc) {
        this.load(desc.fileName, desc.type, desc.params);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean update() {
        block10: {
            block9: {
                if (this.i.size() != 0) break block9;
                while (this.g.size != 0 && this.i.size() == 0) {
                    var2_1 = this;
                    var3_2 = var2_1.g.removeIndex(0);
                    if (var2_1.isLoaded(var3_2.fileName)) {
                        var2_1.a.debug("Already loaded: ".concat(String.valueOf(var3_2)));
                        var4_3 = var2_1.c.get(var3_2.fileName);
                        var2_1.b.get(var4_3).get(var3_2.fileName).incRefCount();
                        var2_1.a(var3_2.fileName);
                        if (var3_2.params != null && var3_2.params.loadedCallback != null) {
                            var3_2.params.loadedCallback.finishedLoading(var2_1, var3_2.fileName, var3_2.type);
                        }
                        ++var2_1.k;
                        continue;
                    }
                    var2_1.a.info("Loading: ".concat(String.valueOf(var3_2)));
                    var2_1.a(var3_2);
                }
                if (this.i.size() != 0) break block9;
                return true;
            }
            try {
                return this.a() != false && this.g.size == 0 && this.i.size() == 0;
            }
            catch (Throwable var1_4) {
                var6_5 = var1_4;
                var5_6 = this;
                var5_6.a.error("Error loading asset.", var6_5);
                if (var5_6.i.isEmpty()) {
                    throw new GdxRuntimeException(var6_5);
                }
                var7_7 = var5_6.i.pop();
                var8_8 = var7_7.a;
                if (!var7_7.c || var7_7.d == null) break block10;
                ** for (var9_10 : var7_7.d)
            }
lbl-1000:
            // 1 sources

            {
                var5_6.unload(var9_10.fileName);
                continue;
            }
        }
        var5_6.i.clear();
        if (var5_6.j == null) {
            throw new GdxRuntimeException(var6_5);
        }
        var5_6.j.error(var8_8, var6_5);
        return this.g.size == 0;
    }

    public boolean update(int millis) {
        long l = TimeUtils.millis() + (long)millis;
        boolean bl;
        while (!(bl = this.update()) && TimeUtils.millis() <= l) {
            ThreadUtils.yield();
        }
        return bl;
    }

    public void finishLoading() {
        this.a.debug("Waiting for loading to complete...");
        while (!this.update()) {
            ThreadUtils.yield();
        }
        this.a.debug("Loading complete.");
    }

    public void finishLoadingAsset(String fileName) {
        this.a.debug("Waiting for asset to be loaded: ".concat(String.valueOf(fileName)));
        while (!this.isLoaded(fileName)) {
            this.update();
            ThreadUtils.yield();
        }
        this.a.debug("Asset loaded: ".concat(String.valueOf(fileName)));
    }

    final synchronized void a(String string, Array<AssetDescriptor> array) {
        ObjectSet<String> objectSet = this.e;
        for (AssetDescriptor assetDescriptor : array) {
            if (objectSet.contains(assetDescriptor.fileName)) continue;
            objectSet.add(assetDescriptor.fileName);
            this.a(string, assetDescriptor);
        }
        objectSet.clear();
    }

    private synchronized void a(String string, AssetDescriptor assetDescriptor) {
        Array<String> array = this.d.get(string);
        if (array == null) {
            array = new Array();
            this.d.put(string, array);
        }
        array.add(assetDescriptor.fileName);
        if (this.isLoaded(assetDescriptor.fileName)) {
            this.a.debug("Dependency already loaded: ".concat(String.valueOf(assetDescriptor)));
            Class clazz = this.c.get(assetDescriptor.fileName);
            this.b.get(clazz).get(assetDescriptor.fileName).incRefCount();
            this.a(assetDescriptor.fileName);
            return;
        }
        this.a.info("Loading dependency: ".concat(String.valueOf(assetDescriptor)));
        this.a(assetDescriptor);
    }

    private void a(AssetDescriptor assetDescriptor) {
        AssetLoader assetLoader = this.getLoader(assetDescriptor.type, assetDescriptor.fileName);
        if (assetLoader == null) {
            throw new GdxRuntimeException("No loader for type: " + ClassReflection.getSimpleName(assetDescriptor.type));
        }
        this.i.push(new a(this, assetDescriptor, assetLoader, this.h));
        ++this.m;
    }

    protected <T> void addAsset(String fileName, Class<T> type, T asset) {
        this.c.put(fileName, type);
        ObjectMap<String, RefCountedContainer> objectMap = this.b.get(type);
        if (objectMap == null) {
            objectMap = new ObjectMap();
            this.b.put(type, objectMap);
        }
        objectMap.put(fileName, new RefCountedContainer(asset));
    }

    private boolean a() {
        a a2 = this.i.peek();
        boolean bl = true;
        try {
            bl = a2.f || a2.a();
        }
        catch (RuntimeException runtimeException) {
            a2.f = true;
            this.taskFailed(a2.a, runtimeException);
        }
        if (bl) {
            if (this.i.size() == 1) {
                ++this.k;
                this.m = 0;
            }
            this.i.pop();
            if (a2.f) {
                return true;
            }
            this.addAsset(a2.a.fileName, a2.a.type, a2.e);
            if (a2.a.params != null && a2.a.params.loadedCallback != null) {
                a2.a.params.loadedCallback.finishedLoading(this, a2.a.fileName, a2.a.type);
            }
            long l = TimeUtils.nanoTime();
            this.a.debug("Loaded: " + (float)(l - a2.b) / 1000000.0f + "ms " + a2.a);
            return true;
        }
        return false;
    }

    protected void taskFailed(AssetDescriptor assetDesc, RuntimeException ex) {
        throw ex;
    }

    private void a(String string) {
        Array<String> array = this.d.get(string);
        if (array == null) {
            return;
        }
        for (String string2 : array) {
            Class clazz = this.c.get(string2);
            this.b.get(clazz).get(string2).incRefCount();
            this.a(string2);
        }
    }

    public synchronized <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> type, AssetLoader<T, P> loader) {
        this.setLoader(type, null, loader);
    }

    public synchronized <T, P extends AssetLoaderParameters<T>> void setLoader(Class<T> type, String suffix, AssetLoader<T, P> loader) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null.");
        }
        this.a.debug("Loader set: " + ClassReflection.getSimpleName(type) + " -> " + ClassReflection.getSimpleName(loader.getClass()));
        ObjectMap objectMap = this.f.get(type);
        if (objectMap == null) {
            objectMap = new ObjectMap();
            this.f.put(type, objectMap);
        }
        objectMap.put(suffix == null ? "" : suffix, loader);
    }

    public synchronized int getLoadedAssets() {
        return this.c.size;
    }

    public synchronized int getQueuedAssets() {
        return this.g.size + this.i.size();
    }

    public synchronized float getProgress() {
        if (this.l == 0) {
            return 1.0f;
        }
        float f = this.k;
        if (this.m > 0) {
            f += (float)(this.m - this.i.size()) / (float)this.m;
        }
        return Math.min(1.0f, f / (float)this.l);
    }

    public synchronized void setErrorListener(AssetErrorListener listener) {
        this.j = listener;
    }

    @Override
    public synchronized void dispose() {
        this.a.debug("Disposing.");
        this.clear();
        this.h.dispose();
    }

    public synchronized void clear() {
        this.g.clear();
        while (!this.update()) {
        }
        ObjectIntMap<String> objectIntMap = new ObjectIntMap<String>();
        while (this.c.size > 0) {
            objectIntMap.clear();
            Array<String> array = this.c.keys().toArray();
            for (String string : array) {
                objectIntMap.put(string, 0);
            }
            for (String string : array) {
                Array<String> array2 = this.d.get(string);
                if (array2 == null) continue;
                for (String string2 : array2) {
                    int n = objectIntMap.get(string2, 0);
                    objectIntMap.put(string2, ++n);
                }
            }
            for (String string : array) {
                if (objectIntMap.get(string, 0) != 0) continue;
                this.unload(string);
            }
        }
        this.b.clear();
        this.c.clear();
        this.d.clear();
        this.k = 0;
        this.l = 0;
        this.m = 0;
        this.g.clear();
        this.i.clear();
    }

    public Logger getLogger() {
        return this.a;
    }

    public void setLogger(Logger logger) {
        this.a = logger;
    }

    public synchronized int getReferenceCount(String fileName) {
        Class clazz = this.c.get(fileName);
        if (clazz == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        return this.b.get(clazz).get(fileName).getRefCount();
    }

    public synchronized void setReferenceCount(String fileName, int refCount) {
        Class clazz = this.c.get(fileName);
        if (clazz == null) {
            throw new GdxRuntimeException("Asset not loaded: ".concat(String.valueOf(fileName)));
        }
        this.b.get(clazz).get(fileName).setRefCount(refCount);
    }

    public synchronized String getDiagnostics() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.c.keys()) {
            stringBuffer.append(string);
            stringBuffer.append(", ");
            Class clazz = this.c.get(string);
            RefCountedContainer refCountedContainer = this.b.get(clazz).get(string);
            Array<String> array = this.d.get(string);
            stringBuffer.append(ClassReflection.getSimpleName(clazz));
            stringBuffer.append(", refs: ");
            stringBuffer.append(refCountedContainer.getRefCount());
            if (array != null) {
                stringBuffer.append(", deps: [");
                for (String string2 : array) {
                    stringBuffer.append(string2);
                    stringBuffer.append(",");
                }
                stringBuffer.append("]");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public synchronized Array<String> getAssetNames() {
        return this.c.keys().toArray();
    }

    public synchronized Array<String> getDependencies(String fileName) {
        return this.d.get(fileName);
    }

    public synchronized Class getAssetType(String fileName) {
        return this.c.get(fileName);
    }
}

