/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.Hide
public class BitmapFontLoader
extends AsynchronousAssetLoader<BitmapFont, BitmapFontParameter> {
    private BitmapFont.BitmapFontData a;

    public BitmapFontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, BitmapFontParameter parameter) {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        if (parameter != null && parameter.bitmapFontData != null) {
            this.a = parameter.bitmapFontData;
            return array;
        }
        this.a = new BitmapFont.BitmapFontData(file, parameter != null ? parameter.flip : false);
        if (parameter != null && parameter.atlasName != null) {
            array.add(new AssetDescriptor<TextureAtlas>(parameter.atlasName, TextureAtlas.class));
        } else {
            int n = 0;
            while (n < this.a.getImagePaths().length) {
                String string = this.a.getImagePath(n);
                FileHandle fileHandle = this.resolve(string);
                TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
                if (parameter != null) {
                    textureParameter.genMipMaps = parameter.genMipMaps;
                    textureParameter.minFilter = parameter.minFilter;
                    textureParameter.magFilter = parameter.magFilter;
                }
                AssetDescriptor<Texture> assetDescriptor = new AssetDescriptor<Texture>(fileHandle, Texture.class, textureParameter);
                array.add(assetDescriptor);
                ++n;
            }
        }
        return array;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, BitmapFontParameter parameter) {
    }

    @Override
    public BitmapFont loadSync(AssetManager manager, String fileName, FileHandle file, BitmapFontParameter parameter) {
        if (parameter != null && parameter.atlasName != null) {
            String string;
            TextureAtlas textureAtlas = manager.get(parameter.atlasName, TextureAtlas.class);
            TextureAtlas.AtlasRegion atlasRegion = textureAtlas.findRegion(string = file.sibling(this.a.imagePaths[0]).nameWithoutExtension().toString());
            if (atlasRegion == null) {
                throw new GdxRuntimeException("Could not find font region " + string + " in atlas " + parameter.atlasName);
            }
            return new BitmapFont(file, atlasRegion);
        }
        int n = this.a.getImagePaths().length;
        TextureRegion[] textureRegionArray = new TextureRegion[n];
        int n2 = 0;
        while (n2 < n) {
            textureRegionArray[n2] = new TextureRegion(manager.get(this.a.getImagePath(n2), Texture.class));
            ++n2;
        }
        return new BitmapFont(this.a, textureRegionArray, true);
    }

    @BA.Hide
    public static class BitmapFontParameter
    extends AssetLoaderParameters<BitmapFont> {
        public boolean flip = false;
        public boolean genMipMaps = false;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
        public BitmapFont.BitmapFontData bitmapFontData = null;
        public String atlasName = null;
    }
}

