/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class ParticleEffectLoader
extends SynchronousAssetLoader<ParticleEffect, ParticleEffectParameter> {
    public ParticleEffectLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public ParticleEffect load(AssetManager am, String fileName, FileHandle file, ParticleEffectParameter param) {
        ParticleEffect particleEffect = new ParticleEffect();
        if (param != null && param.atlasFile != null) {
            particleEffect.load(file, am.get(param.atlasFile, TextureAtlas.class), param.atlasPrefix);
        } else if (param != null && param.imagesDir != null) {
            particleEffect.load(file, param.imagesDir);
        } else {
            FileHandle fileHandle = file;
            particleEffect.load(fileHandle, fileHandle.parent());
        }
        return particleEffect;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, ParticleEffectParameter param) {
        Array<AssetDescriptor<TextureAtlas>> array = null;
        if (param != null && param.atlasFile != null) {
            array = new Array<AssetDescriptor<TextureAtlas>>();
            array.add(new AssetDescriptor<TextureAtlas>(param.atlasFile, TextureAtlas.class));
        }
        return array;
    }

    @BA.Hide
    public static class ParticleEffectParameter
    extends AssetLoaderParameters<ParticleEffect> {
        public String atlasFile;
        public String atlasPrefix;
        public FileHandle imagesDir;
    }
}

