/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class TextureAtlasLoader
extends SynchronousAssetLoader<TextureAtlas, TextureAtlasParameter> {
    private TextureAtlas.TextureAtlasData a;

    public TextureAtlasLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public TextureAtlas load(AssetManager assetManager, String fileName, FileHandle file, TextureAtlasParameter parameter) {
        for (TextureAtlas.TextureAtlasData.Page page : this.a.getPages()) {
            Texture texture;
            page.texture = texture = assetManager.get(page.textureFile.path().replaceAll("\\\\", "/"), Texture.class);
        }
        return new TextureAtlas(this.a);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle atlasFile, TextureAtlasParameter parameter) {
        FileHandle fileHandle = atlasFile.parent();
        this.a = parameter != null ? new TextureAtlas.TextureAtlasData(atlasFile, fileHandle, parameter.flip) : new TextureAtlas.TextureAtlasData(atlasFile, fileHandle, false);
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        for (TextureAtlas.TextureAtlasData.Page page : this.a.getPages()) {
            TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
            new TextureLoader.TextureParameter().format = page.format;
            textureParameter.genMipMaps = page.useMipMaps;
            textureParameter.minFilter = page.minFilter;
            textureParameter.magFilter = page.magFilter;
            array.add(new AssetDescriptor<Texture>(page.textureFile, Texture.class, textureParameter));
        }
        return array;
    }

    @BA.Hide
    public static class TextureAtlasParameter
    extends AssetLoaderParameters<TextureAtlas> {
        public boolean flip = false;

        public TextureAtlasParameter() {
        }

        public TextureAtlasParameter(boolean flip) {
            this.flip = flip;
        }
    }
}

