/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class TextureLoader
extends AsynchronousAssetLoader<Texture, TextureParameter> {
    private TextureLoaderInfo a = new TextureLoaderInfo();

    public TextureLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, TextureParameter parameter) {
        this.a.a = fileName;
        if (parameter == null || parameter.textureData == null) {
            Pixmap.Format format = null;
            boolean bl = false;
            this.a.c = null;
            if (parameter != null) {
                format = parameter.format;
                bl = parameter.genMipMaps;
                this.a.c = parameter.texture;
            }
            this.a.b = TextureData.Factory.loadFromFile(file, format, bl);
        } else {
            this.a.b = parameter.textureData;
            this.a.c = parameter.texture;
        }
        if (!this.a.b.isPrepared()) {
            this.a.b.prepare();
        }
    }

    @Override
    public Texture loadSync(AssetManager manager, String fileName, FileHandle file, TextureParameter parameter) {
        if (this.a == null) {
            return null;
        }
        Texture texture = this.a.c;
        if (texture != null) {
            texture.load(this.a.b);
        } else {
            texture = new Texture(this.a.b);
        }
        if (parameter != null) {
            texture.setFilter(parameter.minFilter, parameter.magFilter);
            texture.setWrap(parameter.wrapU, parameter.wrapV);
        }
        return texture;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, TextureParameter parameter) {
        return null;
    }

    @BA.Hide
    public static class TextureLoaderInfo {
        String a;
        TextureData b;
        Texture c;
    }

    @BA.ShortName(value="lgTextureLoaderParam")
    public static class TextureParameter
    extends AssetLoaderParameters<Texture> {
        public static final Texture.TextureFilter FILTER_Linear = Texture.TextureFilter.Linear;
        public static final Texture.TextureFilter FILTER_MipMap = Texture.TextureFilter.MipMap;
        public static final Texture.TextureFilter FILTER_MipMapLinearLinear = Texture.TextureFilter.MipMapLinearLinear;
        public static final Texture.TextureFilter FILTER_MipMapLinearNearest = Texture.TextureFilter.MipMapLinearNearest;
        public static final Texture.TextureFilter FILTER_MipMapNearestLinear = Texture.TextureFilter.MipMapNearestLinear;
        public static final Texture.TextureFilter FILTER_MipMapNearestNearest = Texture.TextureFilter.MipMapNearestNearest;
        public static final Texture.TextureFilter FILTER_Nearest = Texture.TextureFilter.Nearest;
        public static final Texture.TextureWrap WRAP_ClampToEdge = Texture.TextureWrap.ClampToEdge;
        public static final Texture.TextureWrap WRAP_MirroredRepeat = Texture.TextureWrap.MirroredRepeat;
        public static final Texture.TextureWrap WRAP_Repeat = Texture.TextureWrap.Repeat;
        public static final Pixmap.Format FORMAT_Alpha = Pixmap.Format.Alpha;
        public static final Pixmap.Format FORMAT_Intensity = Pixmap.Format.Intensity;
        public static final Pixmap.Format FORMAT_LuminanceAlpha = Pixmap.Format.LuminanceAlpha;
        public static final Pixmap.Format FORMAT_RGB565 = Pixmap.Format.RGB565;
        public static final Pixmap.Format FORMAT_RGBA4444 = Pixmap.Format.RGBA4444;
        public static final Pixmap.Format FORMAT_RGB888 = Pixmap.Format.RGB888;
        public static final Pixmap.Format FORMAT_RGBA8888 = Pixmap.Format.RGBA8888;
        public Pixmap.Format format = null;
        public boolean genMipMaps = false;
        @BA.Hide
        public Texture texture = null;
        @BA.Hide
        public TextureData textureData = null;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureWrap wrapU = Texture.TextureWrap.ClampToEdge;
        public Texture.TextureWrap wrapV = Texture.TextureWrap.ClampToEdge;
    }
}

