/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.audio.lgAudio;
import anywheresoftware.b4a.libgdx.graphics.lgGraphics;
import anywheresoftware.b4a.libgdx.input.lgInput;
import anywheresoftware.b4a.libgdx.lgGdx;
import anywheresoftware.b4a.libgdx.lgScreenManager;
import anywheresoftware.b4a.libgdx.net.lgNet;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.AndroidPreferences;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.lang.reflect.Method;

@BA.Hide
public class AndroidApplication
implements AndroidApplicationBase {
    protected Activity _Activity;
    @BA.Hide
    public lgScreenManager ScreenMgr = null;
    protected AndroidGraphics graphics;
    protected AndroidInput input;
    protected AndroidAudio audio;
    protected AndroidFiles files;
    protected AndroidNet net;
    protected ApplicationListener listener;
    protected Handler handler;
    protected boolean firstResume = true;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected final Array<LifecycleListener> lifecycleListeners = new Array();
    public int logLevel = 2;
    protected boolean useImmersiveMode = false;
    protected boolean hideStatusBar = false;
    private AndroidClipboard a;

    static {
        GdxNativesLoader.load();
    }

    @BA.Hide
    public void initialize(BA ba, ApplicationListener listener) {
        AndroidApplicationConfiguration androidApplicationConfiguration = new AndroidApplicationConfiguration();
        this.initialize(ba, listener, androidApplicationConfiguration);
    }

    @BA.Hide
    public void initialize(BA ba, ApplicationListener listener, AndroidApplicationConfiguration config) {
        this.a(ba, listener, config, false);
    }

    @BA.Hide
    public View initializeForView(BA ba, ApplicationListener listener) {
        AndroidApplicationConfiguration androidApplicationConfiguration = new AndroidApplicationConfiguration();
        return this.initializeForView(ba, listener, androidApplicationConfiguration);
    }

    @BA.Hide
    public View initializeForView(BA ba, ApplicationListener listener, AndroidApplicationConfiguration config) {
        this.a(ba, listener, config, true);
        return this.graphics.getView();
    }

    private void a(BA bA, ApplicationListener applicationListener, AndroidApplicationConfiguration androidApplicationConfiguration, boolean bl) {
        if (this.getVersion() < 8) {
            throw new GdxRuntimeException("LibGDX requires Android API Level 8 or later.");
        }
        this._Activity = bA.activity;
        AndroidApplicationConfiguration androidApplicationConfiguration2 = androidApplicationConfiguration;
        this.graphics = new AndroidGraphics(this, androidApplicationConfiguration2, androidApplicationConfiguration2.resolutionStrategy == null ? new FillResolutionStrategy() : androidApplicationConfiguration.resolutionStrategy);
        this.input = AndroidInputFactory.newAndroidInput(this, (Context)this._Activity, this.graphics.b, androidApplicationConfiguration);
        this.audio = new AndroidAudio((Context)this._Activity, androidApplicationConfiguration);
        this._Activity.getFilesDir();
        this.files = new AndroidFiles(this._Activity.getAssets(), this._Activity.getFilesDir().getAbsolutePath());
        this.net = new AndroidNet(this);
        this.listener = applicationListener;
        this.handler = new Handler();
        this.useImmersiveMode = androidApplicationConfiguration.useImmersiveMode;
        this.hideStatusBar = androidApplicationConfiguration.hideStatusBar;
        this.addLifecycleListener(new LifecycleListener(this){
            private /* synthetic */ AndroidApplication a;
            {
                this.a = androidApplication;
            }

            @Override
            public final void resume() {
            }

            @Override
            public final void pause() {
                this.a.audio.pause();
            }

            @Override
            public final void dispose() {
                this.a.audio.dispose();
            }
        });
        Gdx.app = this;
        Gdx.input = this.getInput();
        Gdx.audio = this.getAudio();
        Gdx.files = this.getFiles();
        Gdx.graphics = this.getGraphics();
        Gdx.net = this.getNet();
        this.a = new AndroidClipboard((Context)this._Activity);
        lgGdx.Input = new lgInput(this.input);
        lgGdx.InputProcessors = new InputMultiplexer();
        lgGdx.Audio = new lgAudio(this.audio);
        lgGdx.Files = this.files;
        lgGdx.Graphics = new lgGraphics(this.graphics);
        lgGdx.Net = new lgNet(this.net);
        if (!bl) {
            this._Activity.getWindow().setFlags(1024, 1024);
            this._Activity.getWindow().clearFlags(2048);
            this._Activity.setContentView(this.graphics.getView(), (ViewGroup.LayoutParams)this.createLayoutParams());
        }
        this.createWakeLock(androidApplicationConfiguration.useWakelock);
        AndroidApplication androidApplication = this;
        androidApplication.hideStatusBar(androidApplication.hideStatusBar);
        AndroidApplication androidApplication2 = this;
        androidApplication2.useImmersiveMode(androidApplication2.useImmersiveMode);
        if (this.useImmersiveMode && this.getVersion() >= 19) {
            try {
                this.a();
                return;
            }
            catch (Exception exception) {
                this.log("AndroidApplication", "Failed to create AndroidVisibilityListener", exception);
            }
        }
    }

    protected FrameLayout.LayoutParams createLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        new FrameLayout.LayoutParams(-1, -1).gravity = 17;
        return layoutParams;
    }

    protected void createWakeLock(boolean use) {
        if (use) {
            this._Activity.getWindow().addFlags(128);
        }
    }

    protected void hideStatusBar(boolean hide) {
        if (!hide || this.getVersion() < 11) {
            return;
        }
        View view = this._Activity.getWindow().getDecorView();
        try {
            Method method = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
            if (this.getVersion() <= 13) {
                method.invoke((Object)view, 0);
            }
            method.invoke((Object)view, 1);
            return;
        }
        catch (Exception exception) {
            this.log("AndroidApplication", "Can't hide status bar", exception);
            return;
        }
    }

    @Override
    @BA.Hide
    @TargetApi(value=19)
    public void useImmersiveMode(boolean use) {
        if (!use || this.getVersion() < 19) {
            return;
        }
        View view = this._Activity.getWindow().getDecorView();
        try {
            View.class.getMethod("setSystemUiVisibility", Integer.TYPE).invoke((Object)view, 5894);
            return;
        }
        catch (Exception exception) {
            this.log("AndroidApplication", "Can't set immersive mode", exception);
            return;
        }
    }

    private void a() {
        this.getApplicationWindow().getDecorView().setOnSystemUiVisibilityChangeListener(new View.OnSystemUiVisibilityChangeListener(this){
            private /* synthetic */ AndroidApplication a;
            {
                this.a = androidApplication;
            }

            public final void onSystemUiVisibilityChange(int visibility) {
                this.a.getHandler().post(new Runnable(this){
                    private /* synthetic */ 2 a;
                    {
                        this.a = var1_1;
                    }

                    @Override
                    public final void run() {
                        this.a.a.useImmersiveMode(true);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Pause() {
        boolean bl = this.graphics.isContinuousRendering();
        boolean bl2 = AndroidGraphics.a;
        AndroidGraphics.a = true;
        this.graphics.setContinuousRendering(true);
        AndroidGraphics androidGraphics = this.graphics;
        Object object = androidGraphics.h;
        synchronized (object) {
            if (!androidGraphics.d) {
            } else {
                androidGraphics.d = false;
                androidGraphics.e = true;
                while (androidGraphics.e) {
                    try {
                        androidGraphics.h.wait(4000L);
                        if (!androidGraphics.e) continue;
                        Gdx.app.error("AndroidGraphics", "waiting for pause synchronization took too long; assuming deadlock and killing");
                        Process.killProcess((int)Process.myPid());
                    }
                    catch (InterruptedException interruptedException) {
                        Gdx.app.log("AndroidGraphics", "waiting for pause synchronization failed!");
                    }
                }
            }
        }
        this.input.onPause();
        if (this._Activity.isFinishing()) {
            this.graphics.clearManagedCaches();
            androidGraphics = this.graphics;
            object = androidGraphics.h;
            synchronized (object) {
                androidGraphics.d = false;
                androidGraphics.g = true;
                while (androidGraphics.g) {
                    try {
                        androidGraphics.h.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Gdx.app.log("AndroidGraphics", "waiting for destroy synchronization failed!");
                    }
                }
            }
        }
        AndroidGraphics.a = bl2;
        this.graphics.setContinuousRendering(bl);
        this.graphics.onPauseGLSurfaceView();
    }

    public void Resume() {
        Gdx.app = this;
        Gdx.input = this.getInput();
        Gdx.audio = this.getAudio();
        Gdx.files = this.getFiles();
        Gdx.graphics = this.getGraphics();
        Gdx.net = this.getNet();
        this.input.onResume();
        if (this.graphics != null) {
            this.graphics.onResumeGLSurfaceView();
        }
        if (!this.firstResume) {
            this.graphics.a();
            AndroidApplication androidApplication = this;
            androidApplication.hideStatusBar(androidApplication.hideStatusBar);
            AndroidApplication androidApplication2 = this;
            androidApplication2.useImmersiveMode(androidApplication2.useImmersiveMode);
            return;
        }
        this.firstResume = false;
    }

    @Override
    @BA.Hide
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public lgAudio Audio() {
        return lgGdx.Audio;
    }

    @Override
    @BA.Hide
    public Audio getAudio() {
        return this.audio;
    }

    public AndroidFiles Files() {
        return this.files;
    }

    @Override
    @BA.Hide
    public Files getFiles() {
        return this.files;
    }

    public lgGraphics Graphics() {
        return lgGdx.Graphics;
    }

    @Override
    @BA.Hide
    public Graphics getGraphics() {
        return this.graphics;
    }

    public lgInput Input() {
        return lgGdx.Input;
    }

    @Override
    @BA.Hide
    public AndroidInput getInput() {
        return this.input;
    }

    public lgNet Net() {
        return lgGdx.Net;
    }

    @Override
    @BA.Hide
    public Net getNet() {
        return this.net;
    }

    @Override
    @BA.Hide
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Android;
    }

    @Override
    public int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    @Override
    @BA.Hide
    public Preferences getPreferences(String name) {
        return new AndroidPreferences(this._Activity.getSharedPreferences(name, 0));
    }

    @Override
    @BA.Hide
    public Clipboard getClipboard() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @BA.Hide
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            Gdx.graphics.requestRendering();
            return;
        }
    }

    @Override
    public void exit() {
        this.handler.post(new Runnable(this){
            private /* synthetic */ AndroidApplication a;
            {
                this.a = androidApplication;
            }

            @Override
            public final void run() {
                this.a._Activity.finish();
            }
        });
    }

    @Override
    @BA.Hide
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message);
            BA.Log((String)message);
        }
    }

    @Override
    @BA.Hide
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message, (Throwable)exception);
            BA.Log((String)message);
        }
    }

    @Override
    @BA.Hide
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message);
            BA.Log((String)message);
        }
    }

    @Override
    @BA.Hide
    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message, (Throwable)exception);
            BA.Log((String)message);
        }
    }

    @Override
    @BA.Hide
    public void error(String tag, String message) {
        if (this.logLevel > 0) {
            Log.e((String)tag, (String)message);
            BA.Log((String)message);
        }
    }

    @Override
    @BA.Hide
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel > 0) {
            Log.e((String)tag, (String)message, (Throwable)exception);
            BA.Log((String)message);
        }
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @BA.Hide
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @BA.Hide
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue(listener, true);
            return;
        }
    }

    @Override
    @BA.Hide
    public Context getContext() {
        return this._Activity;
    }

    @Override
    @BA.Hide
    public Array<Runnable> getRunnables() {
        return this.runnables;
    }

    @Override
    @BA.Hide
    public Array<Runnable> getExecutedRunnables() {
        return this.executedRunnables;
    }

    @Override
    @BA.Hide
    public Array<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    @BA.Hide
    public Window getApplicationWindow() {
        return this._Activity.getWindow();
    }

    @Override
    @BA.Hide
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    @BA.Hide
    public WindowManager getWindowManager() {
        return this._Activity.getWindowManager();
    }

    @Override
    @BA.Hide
    public void runOnUiThread(Runnable runnable) {
        this._Activity.runOnUiThread(runnable);
    }

    @Override
    @BA.Hide
    public void startActivity(Intent intent) {
        this._Activity.startActivity(intent);
    }
}

