/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.SoundPool;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudioDevice;
import com.badlogic.gdx.backends.android.AndroidAudioRecorder;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidMusic;
import com.badlogic.gdx.backends.android.AndroidSound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@BA.Hide
public final class AndroidAudio
implements Audio {
    private final SoundPool a;
    private final AudioManager b;
    protected final List<AndroidMusic> musics = new ArrayList<AndroidMusic>();

    public AndroidAudio(Context context, AndroidApplicationConfiguration config) {
        if (!config.disableAudio) {
            this.a = new SoundPool(config.maxSimultaneousSounds, 3, 100);
            this.b = (AudioManager)context.getSystemService("audio");
            if (context instanceof Activity) {
                ((Activity)context).setVolumeControlStream(3);
                return;
            }
        } else {
            this.a = null;
            this.b = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void pause() {
        if (this.a == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            for (AndroidMusic androidMusic : this.musics) {
                if (androidMusic.isPlaying()) {
                    androidMusic.pause();
                    androidMusic.wasPlaying = true;
                    continue;
                }
                androidMusic.wasPlaying = false;
            }
        }
        this.a.autoPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void resume() {
        if (this.a == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            int n = 0;
            while (n < this.musics.size()) {
                if (this.musics.get((int)n).wasPlaying) {
                    this.musics.get(n).play();
                }
                ++n;
            }
        }
        this.a.autoResume();
    }

    @Override
    public final AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        if (this.a == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AndroidAudioDevice(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Music newMusic(FileHandle file) {
        if (this.a == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        AndroidFileHandle androidFileHandle = (AndroidFileHandle)file;
        MediaPlayer mediaPlayer = new MediaPlayer();
        if (androidFileHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor assetFileDescriptor = androidFileHandle.getAssetFileDescriptor();
                mediaPlayer.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
                assetFileDescriptor.close();
                mediaPlayer.prepare();
                AndroidMusic androidMusic = new AndroidMusic(this, mediaPlayer);
                List<AndroidMusic> list = this.musics;
                synchronized (list) {
                    this.musics.add(androidMusic);
                }
                return androidMusic;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", exception);
            }
        }
        try {
            mediaPlayer.setDataSource(androidFileHandle.file().getPath());
            mediaPlayer.prepare();
            AndroidMusic androidMusic = new AndroidMusic(this, mediaPlayer);
            List<AndroidMusic> list = this.musics;
            synchronized (list) {
                this.musics.add(androidMusic);
            }
            return androidMusic;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error loading audio file: ".concat(String.valueOf(file)), exception);
        }
    }

    @Override
    public final Sound newSound(FileHandle file) {
        if (this.a == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        AndroidFileHandle androidFileHandle = (AndroidFileHandle)file;
        if (androidFileHandle.type() == Files.FileType.Internal) {
            try {
                AssetFileDescriptor assetFileDescriptor = androidFileHandle.getAssetFileDescriptor();
                AndroidSound androidSound = new AndroidSound(this.a, this.b, this.a.load(assetFileDescriptor, 1));
                assetFileDescriptor.close();
                return androidSound;
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error loading audio file: " + file + "\nNote: Internal audio files must be placed in the assets directory.", iOException);
            }
        }
        try {
            return new AndroidSound(this.a, this.b, this.a.load(androidFileHandle.file().getPath(), 1));
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Error loading audio file: ".concat(String.valueOf(file)), exception);
        }
    }

    @Override
    public final AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        if (this.a == null) {
            throw new GdxRuntimeException("Android audio is not enabled by the application config.");
        }
        return new AndroidAudioRecorder(samplingRate, isMono);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        if (this.a == null) {
            return;
        }
        List<AndroidMusic> list = this.musics;
        synchronized (list) {
            Iterator<AndroidMusic> iterator = new ArrayList<AndroidMusic>(this.musics).iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.a.release();
    }
}

