/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioTrack;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.audio.AudioDevice;

@BA.ShortName(value="lgAudioDevice")
public class AndroidAudioDevice
implements AudioDevice {
    private final AudioTrack a;
    private short[] b = new short[1024];
    private final boolean c;
    private final int d;

    public AndroidAudioDevice() {
        this.a = null;
        this.d = 0;
        this.c = false;
    }

    AndroidAudioDevice(int samplingRate, boolean isMono) {
        this.c = isMono;
        int n = AudioTrack.getMinBufferSize((int)samplingRate, (int)(isMono ? 4 : 12), (int)2);
        this.a = new AudioTrack(3, samplingRate, isMono ? 4 : 12, 2, n, 1);
        this.a.play();
        this.d = n / (isMono ? 1 : 2);
    }

    @Override
    public void dispose() {
        this.a.stop();
        this.a.release();
    }

    @Override
    public boolean isMono() {
        return this.c;
    }

    @Override
    public void writeSamples(short[] samples, int offset, int numSamples) {
        int n = this.a.write(samples, offset, numSamples);
        while (n != numSamples) {
            n += this.a.write(samples, offset + n, numSamples - n);
        }
    }

    @Override
    public void writeSamples(float[] samples, int offset, int numSamples) {
        if (this.b.length < samples.length) {
            this.b = new short[samples.length];
        }
        int n = offset + numSamples;
        int n2 = offset;
        int n3 = 0;
        while (n2 < n) {
            short s;
            float f;
            float f2 = samples[n2];
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            if (f2 < -1.0f) {
                f2 = -1.0f;
            }
            this.b[n3] = s = (short)(f2 * 32767.0f);
            ++n2;
            ++n3;
        }
        n2 = this.a.write(this.b, 0, numSamples);
        while (n2 != numSamples) {
            n2 += this.a.write(this.b, n2, numSamples - n2);
        }
    }

    @Override
    public int getLatency() {
        return this.d;
    }

    @Override
    public void setVolume(float volume) {
        float f = volume;
        this.a.setStereoVolume(f, f);
    }
}

