/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.media.AudioRecord;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.ShortName(value="lgAudioRecorder")
public class AndroidAudioRecorder
implements AudioRecorder {
    private AudioRecord a;

    public AndroidAudioRecorder() {
    }

    public AndroidAudioRecorder(int samplingRate, boolean isMono) {
        int n = isMono ? 16 : 12;
        int n2 = AudioRecord.getMinBufferSize((int)samplingRate, (int)n, (int)2);
        this.a = new AudioRecord(1, samplingRate, n, 2, n2);
        if (this.a.getState() != 1) {
            throw new GdxRuntimeException("Unable to initialize AudioRecorder.\nDo you have the RECORD_AUDIO permission?");
        }
        this.a.startRecording();
    }

    @Override
    public void dispose() {
        this.a.stop();
        this.a.release();
    }

    @Override
    public void read(short[] samples, int offset, int numSamples) {
        int n = 0;
        while (n != numSamples) {
            n += this.a.read(samples, offset + n, numSamples - n);
        }
    }
}

