/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@BA.Hide
public class AndroidFileHandle
extends FileHandle {
    private final AssetManager a;

    AndroidFileHandle(AssetManager assets, String fileName, Files.FileType type) {
        super(fileName.replace('\\', '/'), type);
        this.a = assets;
    }

    AndroidFileHandle(AssetManager assets, File file, Files.FileType type) {
        super(file, type);
        this.a = assets;
    }

    @Override
    public FileHandle child(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            return new AndroidFileHandle(this.a, new File(name), this.type);
        }
        return new AndroidFileHandle(this.a, new File(this.file, name), this.type);
    }

    @Override
    public FileHandle sibling(String name) {
        name = name.replace('\\', '/');
        if (this.file.getPath().length() == 0) {
            throw new GdxRuntimeException("Cannot get the sibling of the root.");
        }
        return Gdx.files.getFileHandle(new File(this.file.getParent(), name).getPath(), this.type);
    }

    @Override
    public FileHandle parent() {
        File file = this.file.getParentFile();
        if (file == null) {
            file = this.type == Files.FileType.Absolute ? new File("/") : new File("");
        }
        return new AndroidFileHandle(this.a, file, this.type);
    }

    @Override
    public InputStream read() {
        if (this.type == Files.FileType.Internal) {
            try {
                return this.a.open(this.file.getPath());
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error reading file: " + this.file + " (" + (Object)((Object)this.type) + ")", iOException);
            }
        }
        return super.read();
    }

    @Override
    public FileHandle[] list() {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] stringArray = this.a.list(this.file.getPath());
                FileHandle[] fileHandleArray = new FileHandle[stringArray.length];
                int n = 0;
                int n2 = fileHandleArray.length;
                while (n < n2) {
                    fileHandleArray[n] = new AndroidFileHandle(this.a, new File(this.file, stringArray[n]), this.type);
                    ++n;
                }
                return fileHandleArray;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error listing children: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
            }
        }
        return super.list();
    }

    @Override
    public FileHandle[] list(String suffix) {
        if (this.type == Files.FileType.Internal) {
            try {
                String[] stringArray = this.a.list(this.file.getPath());
                FileHandle[] fileHandleArray = new FileHandle[stringArray.length];
                int n = 0;
                int n2 = 0;
                int n3 = fileHandleArray.length;
                while (n2 < n3) {
                    String string = stringArray[n2];
                    if (string.endsWith(suffix)) {
                        fileHandleArray[n] = new AndroidFileHandle(this.a, new File(this.file, string), this.type);
                        ++n;
                    }
                    ++n2;
                }
                if (n < stringArray.length) {
                    FileHandle[] fileHandleArray2 = new FileHandle[n];
                    System.arraycopy(fileHandleArray, 0, fileHandleArray2, 0, n);
                    fileHandleArray = fileHandleArray2;
                }
                return fileHandleArray;
            }
            catch (Exception exception) {
                throw new GdxRuntimeException("Error listing children: " + this.file + " (" + (Object)((Object)this.type) + ")", exception);
            }
        }
        return super.list(suffix);
    }

    @Override
    public boolean isDirectory() {
        if (this.type == Files.FileType.Internal) {
            try {
                return this.a.list(this.file.getPath()).length > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return super.isDirectory();
    }

    @Override
    public boolean exists() {
        if (this.type == Files.FileType.Internal) {
            String string = this.file.getPath();
            try {
                this.a.open(string).close();
                return true;
            }
            catch (Exception exception) {
                try {
                    return this.a.list(string).length > 0;
                }
                catch (Exception exception2) {
                    return false;
                }
            }
        }
        return super.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long length() {
        long l;
        if (this.type != Files.FileType.Internal) return super.length();
        AssetFileDescriptor assetFileDescriptor = null;
        try {
            assetFileDescriptor = this.a.openFd(this.file.getPath());
            l = assetFileDescriptor.getLength();
            if (assetFileDescriptor == null) return l;
        }
        catch (IOException iOException) {
            if (assetFileDescriptor == null) return super.length();
            try {
                assetFileDescriptor.close();
                return super.length();
            }
            catch (IOException iOException2) {
                return super.length();
            }
        }
        catch (Throwable throwable) {
            if (assetFileDescriptor == null) throw throwable;
            try {
                assetFileDescriptor.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            assetFileDescriptor.close();
            return l;
        }
        catch (IOException iOException) {}
        return l;
    }

    @Override
    public long lastModified() {
        return super.lastModified();
    }

    @Override
    public File file() {
        if (this.type == Files.FileType.Local) {
            return new File(Gdx.files.getLocalStoragePath(), this.file.getPath());
        }
        return super.file();
    }

    public AssetFileDescriptor getAssetFileDescriptor() throws IOException {
        if (this.a != null) {
            return this.a.openFd(this.path());
        }
        return null;
    }
}

