/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetManager;
import android.os.Environment;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.APKExpansionSupport;
import com.badlogic.gdx.backends.android.AndroidApplication;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidZipFileHandle;
import com.badlogic.gdx.backends.android.ZipResourceFile;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;

@BA.ShortName(value="lgFiles")
public class AndroidFiles
implements Files {
    public static final Files.FileType FILETYPE_Absolute = Files.FileType.Absolute;
    public static final Files.FileType FILETYPE_External = Files.FileType.External;
    public static final Files.FileType FILETYPE_Internal = Files.FileType.Internal;
    public static final Files.FileType FILETYPE_Local = Files.FileType.Local;
    protected final String sdcard = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + "/";
    protected final String localpath;
    protected final AssetManager assets;
    private ZipResourceFile a = null;

    public AndroidFiles(AssetManager assets) {
        this.assets = assets;
        this.localpath = this.sdcard;
    }

    public AndroidFiles(AssetManager assets, String localpath) {
        this.assets = assets;
        this.localpath = localpath.endsWith("/") ? localpath : String.valueOf(localpath) + "/";
    }

    @Override
    public FileHandle getFileHandle(String path, Files.FileType type) {
        FileHandle fileHandle = new AndroidFileHandle(type == Files.FileType.Internal ? this.assets : null, path, type);
        if (this.a != null && type == Files.FileType.Internal) {
            fileHandle = this.a(fileHandle, path);
        }
        return fileHandle;
    }

    private FileHandle a(FileHandle fileHandle, String string) {
        try {
            this.assets.open(string).close();
            return fileHandle;
        }
        catch (Exception exception) {
            AndroidZipFileHandle androidZipFileHandle = new AndroidZipFileHandle(string);
            if (!((FileHandle)androidZipFileHandle).isDirectory()) {
                return androidZipFileHandle;
            }
            if (((FileHandle)androidZipFileHandle).exists()) {
                return androidZipFileHandle;
            }
            return fileHandle;
        }
    }

    @Override
    @BA.Hide
    public FileHandle classpath(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.Classpath);
    }

    @Override
    public FileHandle internal(String path) {
        FileHandle fileHandle = new AndroidFileHandle(this.assets, path, Files.FileType.Internal);
        if (this.a != null) {
            fileHandle = this.a(fileHandle, path);
        }
        return fileHandle;
    }

    @Override
    public FileHandle external(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.External);
    }

    @Override
    public FileHandle absolute(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.Absolute);
    }

    @Override
    public FileHandle local(String path) {
        return new AndroidFileHandle(null, path, Files.FileType.Local);
    }

    @Override
    public String getExternalStoragePath() {
        return this.sdcard;
    }

    @Override
    public boolean isExternalStorageAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    @Override
    public String getLocalStoragePath() {
        return this.localpath;
    }

    @Override
    public boolean isLocalStorageAvailable() {
        return true;
    }

    public boolean SetAPKExpansion(int mainVersion, int patchVersion) {
        try {
            this.a = APKExpansionSupport.getAPKExpansionZipFile(((AndroidApplication)Gdx.app).getContext(), mainVersion, patchVersion);
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("APK expansion main version " + mainVersion + " or patch version " + patchVersion + " couldn't be opened!");
        }
        return this.a != null;
    }

    public ZipResourceFile getExpansionFile() {
        return this.a;
    }
}

