/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGL20;
import com.badlogic.gdx.backends.android.surfaceview.GLSurfaceView20;
import com.badlogic.gdx.backends.android.surfaceview.GdxEglConfigChooser;
import com.badlogic.gdx.backends.android.surfaceview.ResolutionStrategy;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.WindowedMean;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

@BA.Hide
public class AndroidGraphics
implements GLSurfaceView.Renderer,
Graphics {
    static volatile boolean a = false;
    final View b;
    private int i;
    private int j;
    AndroidApplicationBase c;
    private GL20 k;
    private EGLContext l;
    private String m;
    protected long lastFrameTime = System.nanoTime();
    protected float deltaTime = 0.0f;
    protected long frameStart = System.nanoTime();
    protected int frames = 0;
    protected int fps;
    protected WindowedMean mean = new WindowedMean(5);
    private volatile boolean n = false;
    volatile boolean d = false;
    volatile boolean e = false;
    volatile boolean f = false;
    volatile boolean g = false;
    private float o = 0.0f;
    private float p = 0.0f;
    private float q = 0.0f;
    private float r = 0.0f;
    private float s = 1.0f;
    protected final AndroidApplicationConfiguration config;
    private Graphics.BufferFormat t = new Graphics.BufferFormat(5, 6, 5, 0, 16, 0, 0, false);
    private boolean u = true;
    private int[] v = new int[1];
    Object h = new Object();

    public AndroidGraphics(AndroidApplicationBase application, AndroidApplicationConfiguration config, ResolutionStrategy resolutionStrategy) {
        this(application, config, resolutionStrategy, true);
    }

    public AndroidGraphics(AndroidApplicationBase application, AndroidApplicationConfiguration config, ResolutionStrategy resolutionStrategy, boolean focusableView) {
        this.config = config;
        this.c = application;
        this.b = this.createGLSurfaceView(application, resolutionStrategy);
        this.preserveEGLContextOnPause();
        if (focusableView) {
            this.b.setFocusable(true);
            this.b.setFocusableInTouchMode(true);
        }
    }

    protected void preserveEGLContextOnPause() {
        if (Build.VERSION.SDK_INT >= 11 && this.b instanceof GLSurfaceView20) {
            try {
                this.b.getClass().getMethod("setPreserveEGLContextOnPause", Boolean.TYPE).invoke((Object)this.b, Boolean.TRUE);
                return;
            }
            catch (Exception exception) {
                Gdx.app.log("AndroidGraphics", "Method GLSurfaceView.setPreserveEGLContextOnPause not found");
            }
        }
    }

    protected View createGLSurfaceView(AndroidApplicationBase application, ResolutionStrategy resolutionStrategy) {
        if (!this.checkGL20()) {
            throw new GdxRuntimeException("Libgdx requires OpenGL ES 2.0");
        }
        GLSurfaceView.EGLConfigChooser eGLConfigChooser = this.getEglConfigChooser();
        GLSurfaceView20 gLSurfaceView20 = new GLSurfaceView20(application.getContext(), resolutionStrategy);
        if (eGLConfigChooser != null) {
            gLSurfaceView20.setEGLConfigChooser(eGLConfigChooser);
        } else {
            gLSurfaceView20.setEGLConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil);
        }
        gLSurfaceView20.setRenderer(this);
        return gLSurfaceView20;
    }

    public void onPauseGLSurfaceView() {
        if (this.b != null && this.b instanceof GLSurfaceView) {
            ((GLSurfaceView)this.b).onPause();
        }
    }

    public void onResumeGLSurfaceView() {
        if (this.b != null && this.b instanceof GLSurfaceView) {
            ((GLSurfaceView)this.b).onResume();
        }
    }

    protected GLSurfaceView.EGLConfigChooser getEglConfigChooser() {
        return new GdxEglConfigChooser(this.config.r, this.config.g, this.config.b, this.config.a, this.config.depth, this.config.stencil, this.config.numSamples);
    }

    private void b() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.c.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        this.o = displayMetrics.xdpi;
        this.p = displayMetrics.ydpi;
        this.q = displayMetrics.xdpi / 2.54f;
        this.r = displayMetrics.ydpi / 2.54f;
        this.s = displayMetrics.density;
    }

    protected boolean checkGL20() {
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        EGLDisplay eGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int[] nArray = new int[2];
        eGL10.eglInitialize(eGLDisplay, nArray);
        int[] nArray2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344};
        EGLConfig[] eGLConfigArray = new EGLConfig[10];
        int[] nArray3 = new int[1];
        eGL10.eglChooseConfig(eGLDisplay, nArray2, eGLConfigArray, 10, nArray3);
        eGL10.eglTerminate(eGLDisplay);
        return nArray3[0] > 0;
    }

    @Override
    public GL20 getGL20() {
        return this.k;
    }

    @Override
    public int getHeight() {
        return this.j;
    }

    @Override
    public int getWidth() {
        return this.i;
    }

    @Override
    public int getBackBufferWidth() {
        return this.i;
    }

    @Override
    public int getBackBufferHeight() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.i = width;
        this.j = height;
        this.b();
        gl.glViewport(0, 0, this.i, this.j);
        if (!this.n) {
            this.c.getApplicationListener().create();
            this.n = true;
            AndroidGraphics androidGraphics = this;
            synchronized (androidGraphics) {
                this.d = true;
            }
        }
        this.c.getApplicationListener().resize(width, height);
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.l = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        GL10 gL10 = gl;
        AndroidGraphics androidGraphics = this;
        if (androidGraphics.k == null) {
            Gdx.gl = androidGraphics.k = new AndroidGL20();
            Gdx.gl20 = androidGraphics.k;
            Gdx.app.log("AndroidGraphics", "OGL renderer: " + gL10.glGetString(7937));
            Gdx.app.log("AndroidGraphics", "OGL vendor: " + gL10.glGetString(7936));
            Gdx.app.log("AndroidGraphics", "OGL version: " + gL10.glGetString(7938));
            Gdx.app.log("AndroidGraphics", "OGL extensions: " + gL10.glGetString(7939));
        }
        gL10 = config;
        androidGraphics = this;
        EGL10 eGL10 = (EGL10)EGLContext.getEGL();
        EGLDisplay eGLDisplay = eGL10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        int n = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12324);
        int n2 = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12323);
        int n3 = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12322);
        int n4 = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12321);
        int n5 = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12325);
        int n6 = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12326);
        int n7 = Math.max(androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12337), androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12513));
        boolean bl = androidGraphics.a(eGL10, eGLDisplay, (EGLConfig)gL10, 12513) != 0;
        Gdx.app.log("AndroidGraphics", "framebuffer: (" + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        Gdx.app.log("AndroidGraphics", "depthbuffer: (" + n5 + ")");
        Gdx.app.log("AndroidGraphics", "stencilbuffer: (" + n6 + ")");
        Gdx.app.log("AndroidGraphics", "samples: (" + n7 + ")");
        Gdx.app.log("AndroidGraphics", "coverage sampling: (" + bl + ")");
        androidGraphics.t = new Graphics.BufferFormat(n, n2, n3, n4, n5, n6, n7, bl);
        this.b();
        Mesh.invalidateAllMeshes(this.c);
        Texture.invalidateAllTextures(this.c);
        ShaderProgram.invalidateAllShaderPrograms(this.c);
        GLFrameBuffer.invalidateAllFrameBuffers(this.c);
        this.logManagedCachesStatus();
        Display display = this.c.getWindowManager().getDefaultDisplay();
        this.i = display.getWidth();
        this.j = display.getHeight();
        this.mean = new WindowedMean(5);
        this.lastFrameTime = System.nanoTime();
        gl.glViewport(0, 0, this.i, this.j);
    }

    private int a(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n) {
        if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.v)) {
            return this.v[0];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a() {
        Object object = this.h;
        synchronized (object) {
            this.d = true;
            this.f = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void onDrawFrame(GL10 gl) {
        Iterator<Object> iterator;
        Array<LifecycleListener> array;
        long l = System.nanoTime();
        this.deltaTime = (float)(l - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = l;
        if (!this.f) {
            this.mean.addValue(this.deltaTime);
        } else {
            this.deltaTime = 0.0f;
        }
        Array<Object> array2 = this.h;
        // MONITORENTER : array2
        boolean bl = this.d;
        boolean bl2 = this.e;
        boolean bl3 = this.g;
        boolean bl4 = this.f;
        if (this.f) {
            this.f = false;
        }
        if (this.e) {
            this.e = false;
            this.h.notifyAll();
        }
        if (this.g) {
            this.g = false;
            this.h.notifyAll();
        }
        // MONITOREXIT : array2
        if (bl4) {
            array2 = this.c.getLifecycleListeners();
            array = array2;
            // MONITORENTER : array2
            iterator = array2.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT : array
                    break;
                }
                ((LifecycleListener)iterator.next()).resume();
            }
            this.c.getApplicationListener().resume();
            Gdx.app.log("AndroidGraphics", "resumed");
        }
        if (bl) {
            array2 = this.c.getRunnables();
            // MONITORENTER : array2
            this.c.getExecutedRunnables().clear();
            this.c.getExecutedRunnables().addAll(this.c.getRunnables());
            this.c.getRunnables().clear();
            // MONITOREXIT : array2
            int n = 0;
            while (n < this.c.getExecutedRunnables().size) {
                try {
                    this.c.getExecutedRunnables().get(n).run();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                ++n;
            }
            this.c.getInput().a();
            this.c.getApplicationListener().render();
        }
        if (bl2) {
            Array<LifecycleListener> array3;
            array = array3 = this.c.getLifecycleListeners();
            // MONITORENTER : array3
            iterator = array3.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT : array
                    break;
                }
                ((LifecycleListener)iterator.next()).pause();
            }
            this.c.getApplicationListener().pause();
            Gdx.app.log("AndroidGraphics", "paused");
        }
        if (bl3) {
            Array<LifecycleListener> array4;
            array = array4 = this.c.getLifecycleListeners();
            // MONITORENTER : array4
            iterator = array4.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT : array
                    break;
                }
                ((LifecycleListener)iterator.next()).dispose();
            }
            this.c.getApplicationListener().dispose();
            Gdx.app.log("AndroidGraphics", "destroyed");
        }
        if (l - this.frameStart > 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = l;
        }
        ++this.frames;
    }

    @Override
    public float getDeltaTime() {
        if (this.mean.getMean() == 0.0f) {
            return this.deltaTime;
        }
        return this.mean.getMean();
    }

    @Override
    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.AndroidGL;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    public void clearManagedCaches() {
        Mesh.clearAllMeshes(this.c);
        Texture.clearAllTextures(this.c);
        ShaderProgram.clearAllShaderPrograms(this.c);
        GLFrameBuffer.clearAllFrameBuffers(this.c);
        this.logManagedCachesStatus();
    }

    protected void logManagedCachesStatus() {
        Gdx.app.log("AndroidGraphics", Mesh.getManagedStatus());
        Gdx.app.log("AndroidGraphics", Texture.getManagedStatus());
        Gdx.app.log("AndroidGraphics", ShaderProgram.getManagedStatus());
        Gdx.app.log("AndroidGraphics", GLFrameBuffer.getManagedStatus());
    }

    public View getView() {
        return this.b;
    }

    @Override
    public float getPpiX() {
        return this.o;
    }

    @Override
    public float getPpiY() {
        return this.p;
    }

    @Override
    public float getPpcX() {
        return this.q;
    }

    @Override
    public float getPpcY() {
        return this.r;
    }

    @Override
    public float getDensity() {
        return this.s;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return false;
    }

    @Override
    public boolean setDisplayMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[]{this.getDesktopDisplayMode()};
    }

    @Override
    public boolean setDisplayMode(int width, int height, boolean fullscreen) {
        return false;
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public Graphics.DisplayMode getDesktopDisplayMode() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.c.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return new a(this, displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.t;
    }

    @Override
    public void setVSync(boolean vsync) {
    }

    @Override
    public boolean supportsExtension(String extension) {
        if (this.m == null) {
            this.m = Gdx.gl.glGetString(7939);
        }
        return this.m.contains(extension);
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
        if (this.b != null) {
            int n;
            this.u = a || isContinuous;
            int n2 = n = this.u ? 1 : 0;
            if (this.b instanceof GLSurfaceView) {
                ((GLSurfaceView)this.b).setRenderMode(n);
            }
            this.mean.clear();
        }
    }

    @Override
    public boolean isContinuousRendering() {
        return this.u;
    }

    @Override
    public void requestRendering() {
        if (this.b != null && this.b instanceof GLSurfaceView) {
            ((GLSurfaceView)this.b).requestRender();
        }
    }

    @Override
    public boolean isFullscreen() {
        return true;
    }

    final class a
    extends Graphics.DisplayMode {
        private /* synthetic */ AndroidGraphics a;

        protected a(AndroidGraphics androidGraphics, int n, int n2) {
            this.a = androidGraphics;
            super(n, n2, 0, 0);
        }
    }
}

