/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.audio.lgAudio;
import anywheresoftware.b4a.libgdx.graphics.lgGraphics;
import anywheresoftware.b4a.libgdx.input.lgInput;
import anywheresoftware.b4a.libgdx.lgGdx;
import anywheresoftware.b4a.libgdx.net.lgNet;
import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphicsLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidInput;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaperService;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.AndroidPreferences;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxNativesLoader;
import com.badlogic.gdx.utils.GdxRuntimeException;

@BA.Hide
public class AndroidLiveWallpaper
implements AndroidApplicationBase {
    protected AndroidLiveWallpaperService service;
    protected AndroidGraphicsLiveWallpaper graphics;
    protected AndroidInput input;
    protected AndroidAudio audio;
    protected AndroidFiles files;
    protected AndroidNet net;
    protected ApplicationListener listener;
    protected boolean firstResume = true;
    public final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected final Array<LifecycleListener> lifecycleListeners = new Array();
    protected int logLevel = 2;
    private AndroidClipboard a;

    static {
        GdxNativesLoader.load();
    }

    public AndroidLiveWallpaper(AndroidLiveWallpaperService service) {
        this.service = service;
    }

    public void initialize(BA ba, ApplicationListener listener, AndroidApplicationConfiguration config) {
        if (this.getVersion() < 8) {
            throw new GdxRuntimeException("LibGDX requires Android API Level 8 or later.");
        }
        AndroidApplicationConfiguration androidApplicationConfiguration = config;
        this.graphics = new AndroidGraphicsLiveWallpaper(this, androidApplicationConfiguration, androidApplicationConfiguration.resolutionStrategy == null ? new FillResolutionStrategy() : config.resolutionStrategy);
        this.input = AndroidInputFactory.newAndroidInput(this, (Context)this.getService(), this.graphics.b, config);
        this.audio = new AndroidAudio((Context)this.getService(), config);
        this.getService().getFilesDir();
        this.files = new AndroidFiles(this.getService().getAssets(), this.getService().getFilesDir().getAbsolutePath());
        this.net = new AndroidNet(this);
        this.listener = listener;
        Gdx.app = this;
        Gdx.input = this.input;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
        Gdx.net = this.net;
        this.a = new AndroidClipboard(ba.context);
        lgGdx.Audio = new lgAudio(this.audio);
        lgGdx.Files = this.files;
        lgGdx.Graphics = new lgGraphics(this.graphics);
        lgGdx.Input = new lgInput(this.input);
        lgGdx.InputProcessors = new InputMultiplexer();
        lgGdx.Net = new lgNet(this.net);
    }

    public void onPause() {
        if (AndroidLiveWallpaperService.DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onPause()");
        }
        this.audio.pause();
        this.input.onPause();
        if (this.graphics != null) {
            this.graphics.onPauseGLSurfaceView();
        }
        this.listener.pause();
        if (AndroidLiveWallpaperService.DEBUG) {
            Log.d((String)"WallpaperService", (String)" > AndroidLiveWallpaper - onPause() done!");
        }
    }

    public void onResume() {
        Gdx.app = this;
        Gdx.input = this.input;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
        Gdx.net = this.net;
        this.input.onResume();
        if (this.graphics != null) {
            this.graphics.onResumeGLSurfaceView();
        }
        if (!this.firstResume) {
            this.audio.resume();
            this.graphics.a();
            return;
        }
        this.firstResume = false;
    }

    public void onDestroy() {
        if (this.graphics != null) {
            this.graphics.onDestroyGLSurfaceView();
        }
        if (this.audio != null) {
            this.audio.dispose();
        }
        this.listener.dispose();
    }

    @Override
    public WindowManager getWindowManager() {
        return this.service.getWindowManager();
    }

    public AndroidLiveWallpaperService getService() {
        return this.service;
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            return;
        }
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public AndroidInput getInput() {
        return this.input;
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.Android;
    }

    @Override
    public int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    @Override
    public Preferences getPreferences(String name) {
        return new AndroidPreferences(this.service.getSharedPreferences(name, 0));
    }

    @Override
    public AndroidClipboard getClipboard() {
        return this.a;
    }

    @Override
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message);
        }
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message, (Throwable)exception);
        }
    }

    @Override
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message);
        }
    }

    @Override
    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message, (Throwable)exception);
        }
    }

    @Override
    public void error(String tag, String message) {
        if (this.logLevel > 0) {
            Log.e((String)tag, (String)message);
        }
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel > 0) {
            Log.e((String)tag, (String)message, (Throwable)exception);
        }
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void exit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue(listener, true);
            return;
        }
    }

    @Override
    public Context getContext() {
        return this.service;
    }

    @Override
    public Array<Runnable> getRunnables() {
        return this.runnables;
    }

    @Override
    public Array<Runnable> getExecutedRunnables() {
        return this.executedRunnables;
    }

    @Override
    public Array<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public void startActivity(Intent intent) {
        this.service.startActivity(intent);
    }

    @Override
    public Window getApplicationWindow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Handler getHandler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            new Handler(Looper.getMainLooper()).post(runnable);
            return;
        }
        runnable.run();
    }

    @Override
    public void useImmersiveMode(boolean b2) {
        throw new UnsupportedOperationException();
    }
}

